/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.utils;

import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;

public class OnChangeUtils {
    public static void setOnChangeArgument(JsonObject onChangeJson, String paramTitle, ArrayList<Argument> argumentsList) {
        for (Map.Entry entry : onChangeJson.entrySet()) {
            for (int j = 0; j < ((JsonElement)entry.getValue()).getAsJsonArray().size(); ++j) {
                JsonObject onChangeParam = ((JsonElement)entry.getValue()).getAsJsonArray().get(j).getAsJsonObject();
                onChangeParam.addProperty("isOnChange", Boolean.valueOf(true));
                onChangeParam.addProperty("onChangeParam", paramTitle);
                onChangeParam.addProperty("onChangeOption", (String)entry.getKey());
                if (onChangeParam.has("onchange")) {
                    OnChangeUtils.setOnChangeArgument(onChangeParam.get("onchange").getAsJsonObject(), onChangeParam.get("title").getAsString(), argumentsList);
                }
                argumentsList.add(ConnectorUtils.convertJsonToArgument((JsonElement)onChangeParam));
            }
        }
    }

    public static JsonObject getOnChangeConnectorParamOptionList(JsonObject infoContentObj) {
        JsonObject configuration;
        if (!infoContentObj.has("configuration")) {
            infoContentObj.add("configuration", (JsonElement)new JsonObject());
        }
        if (!(configuration = infoContentObj.getAsJsonObject("configuration")).has("fields")) {
            configuration.add("fields", (JsonElement)new JsonArray());
        }
        JsonArray fields = configuration.get("fields").getAsJsonArray();
        JsonObject onChangeParamOption = new JsonObject();
        OnChangeUtils.setOnChangeParamOptionList(fields, onChangeParamOption);
        return onChangeParamOption;
    }

    public static JsonObject setOnChangeParamOptionList(JsonArray fields, JsonObject onChangeParamOption) {
        for (int i = 0; i < fields.size(); ++i) {
            JsonArray checkboxJsonArray = new JsonArray();
            checkboxJsonArray.add("true");
            JsonObject paramObj = fields.get(i).getAsJsonObject();
            if (paramObj.get("type").getAsString().equals("select")) {
                onChangeParamOption.add(paramObj.get("title").getAsString(), (JsonElement)paramObj.get("options").getAsJsonArray());
            } else if (paramObj.get("type").getAsString().equals("checkbox")) {
                onChangeParamOption.add(paramObj.get("title").getAsString(), (JsonElement)checkboxJsonArray);
            }
            if (!paramObj.has("onchange")) continue;
            for (Map.Entry entry : paramObj.get("onchange").getAsJsonObject().entrySet()) {
                OnChangeUtils.setOnChangeParamOptionList(((JsonElement)entry.getValue()).getAsJsonArray(), onChangeParamOption);
            }
        }
        return onChangeParamOption;
    }

    public static JsonObject getOnChangeOperationParamOptionList(ArrayList<Argument> operationParamList) {
        JsonObject onChangeParamOptionList = new JsonObject();
        return OnChangeUtils.setOnChangeParamOptionList(operationParamList, onChangeParamOptionList);
    }

    public static JsonObject setOnChangeParamOptionList(ArrayList<Argument> operationParamList, JsonObject onChangeParamOptionList) {
        for (Argument arg : operationParamList) {
            if (arg.getType().toLowerCase().equals("select")) {
                String[] values = arg.getOptions().split(",");
                JsonArray jsonArray = new JsonArray();
                for (String value : values) {
                    jsonArray.add(value);
                }
                onChangeParamOptionList.add(arg.getTitle(), (JsonElement)jsonArray);
            } else if (arg.getType().toLowerCase().equals("checkbox")) {
                JsonArray jsonArray = new JsonArray();
                jsonArray.add("true");
                onChangeParamOptionList.add(arg.getTitle(), (JsonElement)jsonArray);
            }
            if (arg.getOnchange() == null) continue;
            for (Map.Entry entry : arg.getOnchange().getAsJsonObject().entrySet()) {
                OnChangeUtils.setOnChangeParamOptionList(((JsonElement)entry.getValue()).getAsJsonArray(), onChangeParamOptionList);
            }
        }
        return onChangeParamOptionList;
    }

    public static ArrayList<Argument> arrangeOnChangeParamToJson(ArrayList<Argument> operationFields) {
        ArrayList<Argument> restructuredParameter = new ArrayList<Argument>();
        OnChangeUtils.cleanOnChangeData(operationFields);
        block0: for (Argument arg : operationFields) {
            if (!arg.getIsOnChange().booleanValue()) continue;
            for (Argument onChangeArg : operationFields) {
                JsonArray onChangeJsonArray;
                if (!onChangeArg.getTitle().equals(arg.getOnChangeParam())) continue;
                JsonElement argJsonElement = ConnectorUtils.convertArgumentToJson(onChangeArg);
                if (!argJsonElement.getAsJsonObject().has("onchange")) {
                    argJsonElement.getAsJsonObject().add("onchange", (JsonElement)new JsonObject());
                }
                if (!argJsonElement.getAsJsonObject().get("onchange").getAsJsonObject().has(arg.getOnChangeOption())) {
                    argJsonElement.getAsJsonObject().get("onchange").getAsJsonObject().add(arg.getOnChangeOption(), (JsonElement)new JsonArray());
                }
                if (!ConnectorUtils.containsJsonObjectWithSameName(onChangeJsonArray = argJsonElement.getAsJsonObject().get("onchange").getAsJsonObject().get(arg.getOnChangeOption()).getAsJsonArray(), ConnectorUtils.convertArgumentToJson(arg).getAsJsonObject())) {
                    onChangeJsonArray.add(ConnectorUtils.convertArgumentToJson(arg));
                }
                operationFields.set(operationFields.indexOf(onChangeArg), ConnectorUtils.convertJsonToArgument(argJsonElement));
                continue block0;
            }
        }
        for (Argument arg : operationFields) {
            if (arg.getIsOnChange().booleanValue()) continue;
            restructuredParameter.add(arg);
        }
        return restructuredParameter;
    }

    public static ArrayList cleanOnChangeData(ArrayList<Argument> configurationFields) {
        for (Argument arg : configurationFields) {
            if (arg.getOnchange() == null && arg.getOnchange() != null) continue;
            arg.setOnChange((JsonElement)new JsonObject());
        }
        return configurationFields;
    }

    public static void markOnChangeParamVisible(List<Map<String, Object>> onChangeObjects, JsonObject onChangeJsonObject, String selectedOperation, JsonObject configData) {
        for (Map<String, Object> onChangeObject : onChangeObjects) {
            block1: for (Map.Entry entry : onChangeJsonObject.entrySet()) {
                if (!onChangeObject.get("onChangeOption").toString().equals(entry.getKey())) continue;
                for (JsonElement onChangeValue : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!onChangeObject.get("onChangeArgumentName").toString().equals(onChangeValue.getAsJsonObject().get("name").getAsString())) continue;
                    if (onChangeObject.containsKey("onChangeLabel")) {
                        JLabel onChangeJLabel = (JLabel)onChangeObject.get("onChangeLabel");
                        onChangeJLabel.setVisible(selectedOperation.equals(entry.getKey()));
                    } else if (onChangeObject.containsKey("onChangeComponent")) {
                        Component onChangeInputField = (Component)onChangeObject.get("onChangeComponent");
                        onChangeInputField.setVisible(selectedOperation.equals(entry.getKey()));
                    }
                    if (((JsonObject)onChangeValue).get("onchange") == null) continue block1;
                    Set keys = onChangeValue.getAsJsonObject().get("onchange").getAsJsonObject().keySet();
                    if (!keys.isEmpty()) {
                        selectedOperation = (String)keys.iterator().next();
                    }
                    if (configData.has(onChangeValue.getAsJsonObject().get("name").getAsString())) {
                        selectedOperation = configData.get(onChangeValue.getAsJsonObject().get("name").getAsString()).getAsString();
                    }
                    OnChangeUtils.markOnChangeParamVisible(onChangeObjects, ((JsonObject)onChangeValue).get("onchange").getAsJsonObject(), selectedOperation, configData);
                    continue block1;
                }
            }
        }
    }

    public static void markOnChangeParamVisible(List<Map<String, Object>> onChangeObjects, JsonObject onChangeJsonObject, Boolean isSelected, JsonObject configData) {
        for (Map<String, Object> onChangeObject : onChangeObjects) {
            block1: for (Map.Entry entry : onChangeJsonObject.entrySet()) {
                if (!onChangeObject.get("onChangeOption").toString().equals(entry.getKey())) continue;
                for (JsonElement onChangeValue : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!onChangeObject.get("onChangeArgumentName").toString().equals(onChangeValue.getAsJsonObject().get("name").getAsString())) continue;
                    if (onChangeObject.containsKey("onChangeLabel")) {
                        JLabel onChangeJLabel = (JLabel)onChangeObject.get("onChangeLabel");
                        onChangeJLabel.setVisible(isSelected.toString().equals(entry.getKey()));
                    } else if (onChangeObject.containsKey("onChangeComponent")) {
                        Component onChangeInputField = (Component)onChangeObject.get("onChangeComponent");
                        onChangeInputField.setVisible(isSelected.toString().equals(entry.getKey()));
                    }
                    if (((JsonObject)onChangeValue).get("onchange") == null) continue block1;
                    isSelected = false;
                    if (configData.has(onChangeValue.getAsJsonObject().get("name").getAsString())) {
                        isSelected = configData.get(onChangeValue.getAsJsonObject().get("name").getAsString()).getAsBoolean();
                    }
                    OnChangeUtils.markOnChangeParamVisible(onChangeObjects, ((JsonObject)onChangeValue).get("onchange").getAsJsonObject(), isSelected, configData);
                    continue block1;
                }
            }
        }
    }
}

