/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fortinet.fortisoar.execution.FortiRunConfiguration;
import com.fortinet.fortisoar.execution.FortiRunDebugConfiguration;
import com.fortinet.fortisoar.init.ConfigReader;
import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.model.Connector;
import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.ui.FortiSOARToolWindow;
import com.fortinet.fortisoar.ui.connector.OperationsTabbedPane;
import com.fortinet.fortisoar.ui.operation.CloseButtonPanel;
import com.fortinet.fortisoar.ui.operation.OperationDialog;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.EncryptionDecryption;
import com.fortinet.fortisoar.utils.FortiSOARTerminalUtil;
import com.fortinet.fortisoar.utils.IOUtils;
import com.fortinet.fortisoar.utils.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import com.intellij.ui.content.Content;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectorUtils {
    public static final Logger logger = Logger.getInstance(ConnectorUtils.class);

    public static void createNewOperationFile(Project project, Connector connectorDetail, String operationName, String operationLabel, String operationDescription, String operationEndpoint, String operationMethod) {
        String operationFileName = Paths.get(connectorDetail.getInfoFilePath(), new String[0]).getParent().toString() + "/" + operationName + ".py";
        logger.info(String.format("Create new operation file triggered. Info File Path: %s; Connector Name: %s; Operation Name: %s; Operation File Path: %s", connectorDetail.getInfoFilePath(), connectorDetail.getName(), operationName, operationFileName));
        File file = new File(FilenameUtils.normalize((String)operationFileName));
        if (!file.exists()) {
            try {
                file.createNewFile();
                Map configYml = ConfigReader.configYML;
                Map fileContents = (Map)configYml.get("file_contents");
                String content = fileContents.get("new_operation_template").toString();
                IOUtils.writeStringToFile(file.getPath(), String.format(content, operationName, operationEndpoint, operationMethod));
            }
            catch (Exception ex) {
                logger.error("Unable to complete create new operation file action. Error: " + ex.getMessage());
            }
        }
        ConnectorUtils.createOperationUnitTestFile(connectorDetail.getInfoFilePath(), connectorDetail.getName(), operationName);
        IOUtils.reloadFromDisk(project);
        ConnectorUtils.openFile(project, operationFileName);
    }

    public static void createOperationUnitTestFile(String infoFilePath, String connectorName, String operationName) {
        Path connectorParent = Paths.get(infoFilePath, new String[0]).getParent().getParent();
        String operationTestFileName = Paths.get(connectorParent.toString(), String.format("tests/test_%s.py", operationName)).toString();
        logger.info(String.format("Create new operation test file triggered. File: %s", operationTestFileName));
        File testFile = new File(FilenameUtils.normalize((String)operationTestFileName));
        if (!testFile.exists()) {
            try {
                testFile.createNewFile();
                Map configYml = ConfigReader.configYML;
                Map fileContents = (Map)configYml.get("file_contents");
                String content = fileContents.get("unit_test_template").toString();
                IOUtils.writeStringToFile(testFile.getPath(), String.format(content, connectorName, operationName));
            }
            catch (Exception ioException) {
                logger.error(String.format("Create new operation test file failed. Error: %s", ioException.getMessage()));
            }
        }
    }

    public static JsonElement createOutputSchema(String output_schema) {
        return JsonParser.parseString((String)output_schema);
    }

    public static void generateOperationPyFile(String operationFile, String[] operationList) {
        logger.info("Regenerate \"operations.py\" triggered.");
        StringBuilder content = new StringBuilder("\"\"\"\nThis file will be auto-generated on each \"new operation action\", so avoid editing in this file.\n\"\"\"\n\n\n");
        for (String s : operationList) {
            content.append(String.format("from .%s import %s\n", s, s));
        }
        content.append("\n\n\n");
        content.append("operations = {\n");
        for (String s : operationList) {
            content.append(String.format("    \"%s\": %s,\n", s, s));
        }
        content.append("}\n");
        IOUtils.writeStringToFile(operationFile.replace("file:", ""), content.toString());
    }

    public static boolean validateRequiredField(JTextField inputField, Color defaultColor) {
        if (inputField.getText().strip().length() == 0) {
            inputField.setBorder(BorderFactory.createLineBorder(Color.red));
            return false;
        }
        inputField.setBorder(BorderFactory.createLineBorder(defaultColor));
        return true;
    }

    public static boolean validateRequiredField(JTextArea inputField, Color defaultColor) {
        if (inputField.getText().strip().length() == 0) {
            inputField.setBorder(BorderFactory.createLineBorder(Color.red));
            return false;
        }
        inputField.setBorder(BorderFactory.createLineBorder(defaultColor));
        return true;
    }

    public static boolean validateRequiredField(ComboBox inputField, Color defaultColor) {
        if (inputField != null) {
            if (inputField.getSelectedItem() == Constants.UI_TEXT.getProperty("dropDownDefaultValue")) {
                inputField.setBorder(BorderFactory.createLineBorder(Color.red));
                return false;
            }
            if (inputField.getSelectedItem() == null || Objects.requireNonNull(inputField.getSelectedItem()).toString().strip().length() == 0) {
                inputField.setBorder(BorderFactory.createLineBorder(Color.red));
                return false;
            }
            inputField.setBorder(BorderFactory.createLineBorder(defaultColor));
            return true;
        }
        return true;
    }

    public static boolean validateRequiredField(JBList inputField, Color defaultColor) {
        if (inputField.getSelectedValuesList().size() == 0) {
            inputField.setBorder(BorderFactory.createLineBorder(Color.red));
            return false;
        }
        if (inputField.getSelectedValuesList().size() == 1 && inputField.getSelectedValuesList().contains(Constants.UI_TEXT.getProperty("multiSelectDropDownDefaultValue"))) {
            inputField.setBorder(BorderFactory.createLineBorder(Color.red));
            return false;
        }
        inputField.setBorder(BorderFactory.createLineBorder(defaultColor));
        return true;
    }

    public static boolean validateVersionTextField(JTextField version, Color defaultColor) {
        if (!ConnectorUtils.isValidVersion(version.getText())) {
            version.setBorder(BorderFactory.createLineBorder(Color.red));
            return false;
        }
        version.setBorder(BorderFactory.createLineBorder(defaultColor));
        return true;
    }

    public static boolean isValidVersion(String version) {
        return version.strip().length() != 0 && Constants.VERSION_REGEX.matcher(version.strip()).find();
    }

    public static void runPlaybookGenerationScript(Project project, String infoFilePath) {
        logger.info(String.format("Generate sample playbooks action triggered. Info File Path: %s", infoFilePath));
        Properties popMessage = Constants.POP_MESSAGE;
        if (!CommonUtils.askYesNoQuestion(String.format(popMessage.getProperty("playbookOverwriteWarning"), new Object[0]))) {
            return;
        }
        String pythonPath = ConnectorUtils.getPythonPath(project);
        try {
            if (!CommonUtils.isValidPythonPath(pythonPath)) {
                return;
            }
            String[] commands = new String[]{pythonPath, "-m", "connectors.scripts.generate_sample_playbook", "--connector-info", infoFilePath};
            String output = ConnectorUtils.invokePythonScript(List.of(commands));
            if (output.strip().length() == 0) {
                CommonUtils.showInfoMessage(popMessage.getProperty("playbookGeneratedSuccess"));
            } else {
                logger.debug(String.format("Generate sample playbook Python script failed with following error: %s", output));
                CommonUtils.showErrorMessage(String.format(popMessage.getProperty("playbookGeneratedFailed"), output));
            }
        }
        catch (Exception ex) {
            logger.error("Generate sample playbook action failed.", (Throwable)ex);
            CommonUtils.showErrorMessage(String.format(popMessage.getProperty("playbookGeneratedFailed"), ex.getMessage()));
        }
    }

    public static void runDocsGenerationScript(Project project, String infoFilePath) {
        logger.info(String.format("Generate document action triggered. Info File Path: %s", infoFilePath));
        Properties popMessage = Constants.POP_MESSAGE;
        String pythonPath = ConnectorUtils.getPythonPath(project);
        try {
            if (!CommonUtils.isValidPythonPath(pythonPath) || !CommonUtils.askYesNoQuestion("Make sure you have successfully generated the sample playbook.\nDo you want to continue?")) {
                return;
            }
            String outputPath = Paths.get(ConnectorUtils.getConnectorParentFolder(infoFilePath, project.getName()), "docs").toString();
            String[] commands = new String[]{pythonPath, "-m", "connectors.scripts.generate_document", "--connector-info", infoFilePath, "--output-path", outputPath};
            String output = ConnectorUtils.invokePythonScript(List.of(commands));
            if (output.strip().length() == 0) {
                CommonUtils.showInfoMessage(String.format(popMessage.getProperty("docsGeneratedSuccess"), outputPath));
            } else {
                logger.debug("Generate docs python script failed with following error: %s", new Object[]{output});
                CommonUtils.showErrorMessage(String.format(popMessage.getProperty("docsGeneratedFailed"), output));
            }
            IOUtils.reloadFromDisk(project);
        }
        catch (Exception ex) {
            logger.error("Generate document action failed.", (Throwable)ex);
            CommonUtils.showErrorMessage(String.format(popMessage.getProperty("docsGeneratedFailed"), ex.getMessage()));
        }
    }

    public static String getConnectorParentFolder(String infoFilePath, String projectFolderName) {
        File infoFile = new File(infoFilePath).getAbsoluteFile();
        while (!infoFile.getParentFile().getName().equals(projectFolderName)) {
            File parentDir;
            infoFile = parentDir = infoFile.getParentFile();
        }
        return infoFile.getPath();
    }

    public static void runConnectorValidation(Project project, String infoFilePath) {
        logger.info(String.format("Generate connector inspect action triggered. Info File Path: %s", infoFilePath));
        Properties popMessage = Constants.POP_MESSAGE;
        String pythonPath = ConnectorUtils.getPythonPath(project);
        try {
            if (!CommonUtils.isValidPythonPath(pythonPath)) {
                return;
            }
            String outputPath = Paths.get(ConnectorUtils.getConnectorParentFolder(infoFilePath, project.getName()), "validate-connector").toString();
            String[] commands = new String[]{pythonPath, "-m", "connectors.scripts.generate_connector_inspect", "--connector-info", infoFilePath, "--output-path", outputPath};
            String output = ConnectorUtils.invokePythonScript(List.of(commands));
            if (output.strip().length() != 0) {
                CommonUtils.showInfoMessage(String.format(popMessage.getProperty("connectorInspectGeneratedSuccess"), outputPath));
            } else {
                logger.debug("Generate connector inspect python script failed with following error: %s", new Object[]{output});
                CommonUtils.showErrorMessage(String.format(popMessage.getProperty("connectorInspectGeneratedFailed"), output));
            }
            IOUtils.reloadFromDisk(project);
        }
        catch (Exception ex) {
            logger.error("Generate connector inspect action failed.", (Throwable)ex);
            CommonUtils.showErrorMessage(String.format(popMessage.getProperty("connectorInspectGeneratedFailed"), ex.getMessage()));
        }
    }

    public static String invokePythonScript(List<String> commands) {
        logger.info(String.format("Invoke python script triggered. Commands: %s", commands));
        StringBuilder output = new StringBuilder();
        try {
            ProcessBuilder pb = new ProcessBuilder(commands);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String s = null;
            while ((s = stdInput.readLine()) != null) {
                output.append(s);
            }
        }
        catch (IOException ioException) {
            logger.error("Invoke python script failed.", (Throwable)ioException);
        }
        return output.toString();
    }

    public static ColoredProcessHandler createFortiSOARTerminal(Project project, List<String> commandsToExecute, String displayName, String initialText, boolean showInTerminal, String[] commandsToPrint) {
        logger.info(String.format("Create FortiSOAR Terminal triggered with following commands: %S", List.of(commandsToPrint)));
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(commandsToExecute);
        generalCommandLine.setCharset(StandardCharsets.UTF_8);
        generalCommandLine.setWorkDirectory(project.getBasePath());
        ColoredProcessHandler processHandler = null;
        try {
            processHandler = new ColoredProcessHandler(generalCommandLine);
        }
        catch (ExecutionException ex) {
            logger.error("Process Handler creation failed.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        processHandler.startNotify();
        if (showInTerminal) {
            FortiSOARTerminalUtil.activateConsoleView(project, displayName);
            Content content = FortiSOARTerminalUtil.getConsoleViewContent(project);
            assert (content != null);
            ConsoleView console = (ConsoleView)content.getComponent();
            console.print(String.format("Commands: %s\n", List.of(commandsToPrint)), ConsoleViewContentType.SYSTEM_OUTPUT);
            console.print(initialText, ConsoleViewContentType.LOG_INFO_OUTPUT);
            console.attachToProcess((ProcessHandler)processHandler);
            console.requestScrollingToEnd();
        }
        return processHandler;
    }

    public static void openConnectorFile(PsiDirectory connectorDir, Project project) {
        try {
            @Nullable PsiFile infoFile = connectorDir.findFile("info.json");
            @NonNls @NotNull String infoFilePath = infoFile.getVirtualFile().getPath();
            ConnectorUtils.openFile(project, infoFilePath);
        }
        catch (Exception ex) {
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("fileNotFound"));
            logger.debug(String.format("Open connector info.json failed. Error: %s", ex.getMessage()));
        }
    }

    public static void openOperationFile(Operation operationDetail, OperationsTabbedPane mainTabbedPane, Project project, int defaultTabIndex) {
        try {
            String operationFileName = Paths.get(operationDetail.getInfoFilePath(), new String[0]).getParent().toString() + "/" + operationDetail.getOperation() + ".py";
            ConnectorUtils.openFile(project, operationFileName);
            ConnectorUtils.reloadOperationPanel(operationDetail, mainTabbedPane, project, defaultTabIndex);
        }
        catch (Exception ex) {
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("operationFileNotFound") + ex.getMessage());
            logger.debug(String.format("Open operation file failed. Error: %s", ex.getMessage()));
        }
    }

    private static void openFile(Project project, String filePath) {
        try {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
            if (file != null) {
                FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file, 0), true);
            }
        }
        catch (Exception ex) {
            logger.debug(String.format("Open file in editor failed. Error: %s", ex.getMessage()));
        }
    }

    public static File findInfoFile(VirtualFile currentFile) {
        VirtualFile currDir = currentFile.getParent();
        String currDirName = currDir.getPath();
        String infoFilePath = currDirName.concat("/info.json");
        File file = new File(infoFilePath);
        if (!file.exists()) {
            String parentDirName = currDir.getParent().getPath();
            infoFilePath = parentDirName.concat("/info.json");
            file = new File(infoFilePath);
        }
        return file;
    }

    public static void reloadOperationPanel(Operation operation, OperationsTabbedPane operationsTabbedPane, Project project, int defaultTabIndex) {
        String operationName = operation.getTitle();
        int tabIndex = ConnectorUtils.findIndexOfOperationTab(operationsTabbedPane, operationName);
        if (tabIndex == -1) {
            tabIndex = operationsTabbedPane.getTabCount();
            CloseButtonPanel closeButtonPanel = new CloseButtonPanel(operationsTabbedPane, operationName);
            OperationDialog operationDialog = new OperationDialog(operation, project);
            operationDialog.setSelectedIndex(defaultTabIndex);
            operationsTabbedPane.addTab(operationName, (Component)((Object)operationDialog));
            operationsTabbedPane.setTabComponentAt(tabIndex, closeButtonPanel);
        } else {
            OperationDialog operationDialog = (OperationDialog)((Object)operationsTabbedPane.getComponentAt(tabIndex));
            operationDialog.setSelectedIndex(defaultTabIndex);
        }
        operationsTabbedPane.setSelectedIndex(tabIndex);
    }

    private static int findIndexOfOperationTab(JTabbedPane operationTabbedPane, String name) {
        int index = -1;
        for (int i = 0; i < operationTabbedPane.getTabCount(); ++i) {
            if (!operationTabbedPane.getTitleAt(i).equals(name)) continue;
            index = i;
            break;
        }
        return index;
    }

    public static void setupPythonEnv(Project project, String pythonPath, boolean showOutput) {
        IOUtils.copyResources(project, FortiSOARToolWindow.class);
        String library_path = project.getBasePath() + Constants.FORTISOAR_CONNECTOR_ENGINE_LIBRARY_PATH;
        Object[] commands = new String[]{pythonPath, "-m", "pip", "install", library_path, "--force-reinstall"};
        logger.info(String.format("Setup python environment triggered with following commands: %s", Arrays.toString(commands)));
        ColoredProcessHandler process = ConnectorUtils.createFortiSOARTerminal(project, List.of(commands), "Setup", "", showOutput, (String[])commands);
        CompletableFuture.runAsync(() -> {
            process.waitFor();
            IOUtils.deleteResources(project);
        });
    }

    public static void testConnectorAllActions(Project project, String infoFilePath, String connectorName) {
        String pythonPath = ConnectorUtils.getPythonPath(project);
        if (CommonUtils.isValidPythonPath(pythonPath)) {
            String initialText = String.format("Connector: %s\nOperation: All\n", connectorName);
            String testScope = Paths.get(Paths.get(infoFilePath, new String[0]).getParent().getParent().toString(), "tests").toString();
            String[] commands = new String[]{pythonPath, "-m", "pytest", "--no-header", "--color=yes", "-v", testScope};
            String tabName = connectorName + " > test_all";
            ConnectorUtils.createFortiSOARTerminal(project, List.of(commands), tabName, initialText, true, commands);
        }
    }

    public static void testOperationAction(Project project, String infoFilePath, String operationName, String connectorName) {
        String pythonPath = ConnectorUtils.getPythonPath(project);
        if (CommonUtils.isValidPythonPath(pythonPath)) {
            String initialText = String.format("Connector: %s\nOperation: %s\n", connectorName, operationName);
            String testScope = Paths.get(Paths.get(infoFilePath, new String[0]).getParent().getParent().toString(), String.format("tests/test_%s.py", operationName)).toString();
            String[] commands = new String[]{pythonPath, "-m", "pytest", "--no-header", "--color=yes", "-v", testScope};
            String tabName = String.format("%s > test_%s.py", connectorName, operationName);
            ConnectorUtils.openFile(project, testScope);
            ConnectorUtils.createFortiSOARTerminal(project, List.of(commands), tabName, initialText, true, commands);
        }
    }

    public static void createConfiguration(Project project, String infoFilePath, String operationAPIName, Set<String> fieldTypePasswordKeys, Map<String, String> configParam, Boolean isConfigValue) {
        Path infoFile = Paths.get(infoFilePath, new String[0]);
        Path connectorPath = infoFile.getParent();
        String connectorName = String.valueOf(connectorPath.getFileName());
        String localDataPath = Paths.get(Objects.requireNonNull(project.getBasePath()), "/.fortisoar/local_data.json").toString();
        JsonObject connectorLocalDataToExecute = ConnectorUtils.getLocalData(project).getAsJsonObject();
        if (connectorLocalDataToExecute.has(connectorName)) {
            connectorLocalDataToExecute = connectorLocalDataToExecute.get(connectorName).getAsJsonObject();
            connectorLocalDataToExecute = EncryptionDecryption.decryptJsonData(fieldTypePasswordKeys, connectorLocalDataToExecute, configParam);
        }
        Set<String> keysToMask = ConnectorUtils.getConfigAndActionsPasswordParameter(infoFilePath);
        String runDebugInLineCommands = "--connector-path %s --connector-name %s --operation-name %s --config-name %s --connector-data %s --keys-to-mask %s --local-data-path %s";
        String keysToMaskString = keysToMask.isEmpty() ? "\"\"" : String.join((CharSequence)",", keysToMask);
        Gson gson = new Gson();
        String escapedGsonData = ConnectorUtils.convertToDesiredFormat(gson.toJson((JsonElement)connectorLocalDataToExecute));
        runDebugInLineCommands = String.format(runDebugInLineCommands, connectorPath, connectorName, operationAPIName, configParam.get("config"), escapedGsonData, ConnectorUtils.convertToDesiredFormat(keysToMaskString), localDataPath);
        FortiRunDebugConfiguration.createRunDebugConfiguration(project, infoFilePath, "connectors.scripts.execute_operation", runDebugInLineCommands, isConfigValue);
        IOUtils.reloadFromDisk(project);
    }

    public static String convertToDesiredFormat(String jsonInput) {
        String escapedQuotesJson = jsonInput.replace("\"", "\\&quot;");
        return "&quot;" + escapedQuotesJson + "&quot;";
    }

    public static JsonObject maskPasswordTypeField(JsonObject connectorLocalData, Set<String> keysToMask) {
        for (Map.Entry entry : connectorLocalData.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonObject()) {
                ConnectorUtils.maskPasswordTypeField(value.getAsJsonObject(), keysToMask);
                continue;
            }
            if (!keysToMask.contains(key)) continue;
            connectorLocalData.add(key, (JsonElement)new JsonPrimitive("********"));
        }
        return connectorLocalData;
    }

    public static JsonObject getLocalData(Project project) {
        return JsonUtils.readJsonFile(Paths.get(project.getBasePath(), "/.fortisoar/local_data.json").toString());
    }

    public static void setPythonPath(Project project, String pythonPath, boolean showOutput) {
        File file = new File(pythonPath);
        if (file.exists() && file.canExecute()) {
            ConnectorUtils.setupPythonEnv(project, pythonPath, showOutput);
            ConnectorUtils.savePythonPath(project, pythonPath);
            logger.info(String.format("PYTHON_PATH updated to: %s", pythonPath));
        } else if (showOutput) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("pythonPathIsNotValid"), pythonPath));
        }
    }

    public static void installConnectorRequirements(Project project, String infoFilePath) {
        Properties popMessage = Constants.POP_MESSAGE;
        Properties fileName = Constants.FILE_NAME;
        try {
            String requirementsPath = infoFilePath.replace(fileName.getProperty("infoJsonFileName"), fileName.getProperty("requirementsFileName"));
            File file = new File(requirementsPath);
            if (!file.exists()) {
                String errorMessage = String.format(popMessage.getProperty("noRequirementFileExists"), fileName.getProperty("requirementsFileName"));
                logger.info(errorMessage);
                CommonUtils.showInfoMessage(errorMessage);
                return;
            }
            Path filePath = Paths.get(requirementsPath, new String[0]);
            List nonCommentLines = Files.lines(filePath).filter(line -> !line.trim().startsWith("#")).collect(Collectors.toList());
            if (nonCommentLines.isEmpty()) {
                String infoMessage = String.format(popMessage.getProperty("installRequirementEmptyMessage"), fileName.getProperty("requirementsFileName"));
                CommonUtils.showInfoMessage(infoMessage);
                logger.info(infoMessage);
                return;
            }
            String pythonPath = ConnectorUtils.getPythonPath(project);
            if (CommonUtils.isValidPythonPath(pythonPath)) {
                String[] commands = new String[]{pythonPath, "-m", "pip", "install", "-r", requirementsPath};
                String initialText = String.format("Requirements Path: %s\n", requirementsPath);
                ConnectorUtils.createFortiSOARTerminal(project, List.of(commands), "Requirements", initialText, true, commands);
                logger.info("Successfully installed required dependencies of connector.");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static RunnerAndConfigurationSettings createNewRunnerAndConfigSettings(Project project) {
        ConfigurationType type = ConfigurationTypeUtil.findConfigurationType((String)"FortiRunConfiguration");
        ConfigurationFactory[] factories = type.getConfigurationFactories();
        RunnerAndConfigurationSettings racs = RunManager.getInstance((Project)project).createConfiguration("testConfig", factories[0]);
        RunManager.getInstance((Project)project).addConfiguration(racs);
        RunManager.getInstance((Project)project).setSelectedConfiguration(racs);
        return racs;
    }

    public static void updateRunnerAndConfigSettings(Project project, RunnerAndConfigurationSettings runnerAndConfig, String connectorName, String operationName, String commands) {
        runnerAndConfig.setName(String.format("%s > %s", connectorName, operationName));
        @NotNull FortiRunConfiguration config = (FortiRunConfiguration)runnerAndConfig.getConfiguration();
        config.setScriptName(ConnectorUtils.getPythonPath(project));
        config.setCommands(commands);
    }

    public static void savePythonPath(Project project, String pythonPath) {
        String localDataFilePath = Paths.get(Objects.requireNonNull(project.getBasePath()), "/.fortisoar/local_data.json").toString();
        JsonUtils.createLocalDataFileIfNotFound(localDataFilePath);
        JsonObject localData = JsonUtils.readJsonFile(localDataFilePath);
        localData.addProperty("PYTHON_PATH", pythonPath);
        JsonUtils.writeInfoJsonFile(localDataFilePath, localData);
    }

    public static String getPythonPath(Project project) {
        String pythonPath;
        String localDataFilePath = Paths.get(Objects.requireNonNull(project.getBasePath()), "/.fortisoar/local_data.json").toString();
        JsonUtils.createLocalDataFileIfNotFound(localDataFilePath);
        JsonObject localData = JsonUtils.readJsonFile(localDataFilePath);
        if (!localData.has("PYTHON_PATH")) {
            localData.addProperty("PYTHON_PATH", "");
        }
        if (!CommonUtils.stringIsNotEmptyOrNull(pythonPath = localData.get("PYTHON_PATH").getAsString()).booleanValue()) {
            ConnectorUtils.getDefaultPythonPath(project);
        }
        return pythonPath;
    }

    public static String getDefaultPythonPath(Project project) {
        String pythonPath = "";
        for (String basePythonPath : Constants.defaultPythonPathList) {
            Path defaultPythonPath = Paths.get(project.getBasePath(), basePythonPath);
            if (!ConnectorUtils.checkPythonPath(defaultPythonPath)) continue;
            pythonPath = defaultPythonPath.toString();
            break;
        }
        return pythonPath;
    }

    public static boolean checkPythonPath(Path pythonPath) {
        File defaultPythonFile = new File(pythonPath.toString());
        return defaultPythonFile.exists() && defaultPythonFile.canExecute();
    }

    public static ColoredProcessHandler captureOutputSchema(Project project, String infoFilePath, String configName, String operationName, Set<String> fieldTypePasswordKeys) {
        String pythonPath = ConnectorUtils.getPythonPath(project);
        if (CommonUtils.isValidPythonPath(pythonPath)) {
            Path infoFile = Paths.get(infoFilePath, new String[0]);
            Path connectorPath = infoFile.getParent();
            String connectorName = String.valueOf(connectorPath.getFileName());
            String localDataPath = Paths.get(Objects.requireNonNull(project.getBasePath()), "/.fortisoar/local_data.json").toString();
            JsonObject connectorLocalDataToExecute = ConnectorUtils.getLocalData(project).getAsJsonObject().get(connectorName).getAsJsonObject();
            HashMap<String, String> configParam = new HashMap<String, String>();
            configParam.put("config", configName);
            configParam.put("params", operationName);
            connectorLocalDataToExecute = EncryptionDecryption.decryptJsonData(fieldTypePasswordKeys, connectorLocalDataToExecute, configParam);
            Set<String> keysToMask = ConnectorUtils.getConfigAndActionsPasswordParameter(infoFilePath);
            JsonObject connectorLocalDataToPrint = ConnectorUtils.maskPasswordTypeField(ConnectorUtils.getLocalData(project).getAsJsonObject().get(connectorName).getAsJsonObject(), keysToMask);
            String[] commandsToExecute = new String[]{pythonPath, "-m", "connectors.scripts.capture_output_schema", "--connector-path", connectorPath.toString(), "--connector-name", connectorName, "--config-name", configName, "--operation-name", operationName, "--local-data-path", localDataPath, "--connector-data", String.valueOf(connectorLocalDataToExecute), "--keys-to-mask", String.join((CharSequence)",", keysToMask)};
            String[] commandsToPrint = new String[]{pythonPath, "-m", "connectors.scripts.capture_output_schema", "--connector-path", connectorPath.toString(), "--connector-name", connectorName, "--config-name", configName, "--operation-name", operationName, "--local-data-path", localDataPath, "--connector-data", String.valueOf(connectorLocalDataToPrint)};
            ColoredProcessHandler process = ConnectorUtils.createFortiSOARTerminal(project, List.of(commandsToExecute), operationName, "", true, commandsToPrint);
            return process;
        }
        return null;
    }

    public static String[] createDropDownValue(Argument arg) {
        ArrayList<String> dropDownList = new ArrayList<String>();
        if (arg.getType().equals("Multiselect")) {
            dropDownList.add(Constants.UI_TEXT.getProperty("multiSelectDropDownDefaultValue"));
            dropDownList.addAll(List.of(arg.getOptions().split(",\\s*")));
            return dropDownList.toArray(new String[0]);
        }
        dropDownList.add(Constants.UI_TEXT.getProperty("dropDownDefaultValue"));
        if (!arg.getOptions().isEmpty()) {
            dropDownList.addAll(List.of(arg.getOptions().split(",\\s*")));
        }
        return dropDownList.toArray(new String[0]);
    }

    public static void setDropDownValueAsEmpty(Map<String, String> selectMultiSelectTypeKey, JsonObject selectedConfigData) {
        for (Map.Entry<String, String> data : selectMultiSelectTypeKey.entrySet()) {
            if (selectedConfigData.has(data.getKey()) && data.getValue().equals("select")) {
                if (!selectedConfigData.get(data.getKey()).getAsString().equals(Constants.UI_TEXT.getProperty("dropDownDefaultValue"))) continue;
                selectedConfigData.addProperty(data.getKey(), "");
                continue;
            }
            if (!selectedConfigData.has(data.getKey()) || !data.getValue().equals("multiselect")) continue;
            JsonArray newList = new JsonArray();
            for (int i = 0; i < selectedConfigData.get(data.getKey()).getAsJsonArray().size(); ++i) {
                if (selectedConfigData.get(data.getKey()).getAsJsonArray().get(i).getAsString().equals(Constants.UI_TEXT.getProperty("multiSelectDropDownDefaultValue"))) continue;
                newList.add(selectedConfigData.get(data.getKey()).getAsJsonArray().get(i).getAsString());
            }
            selectedConfigData.add(data.getKey(), (JsonElement)newList);
        }
    }

    public static Set<String> getConfigurationPasswordParameter(String infoFilePath) {
        HashSet<String> fieldTypePasswordKeys = new HashSet<String>();
        try {
            JsonObject infoJsonData = JsonUtils.readJsonFile(infoFilePath);
            if (ConnectorUtils.isConfigurationArgumentExists(infoJsonData.getAsJsonObject()).booleanValue()) {
                JsonElement configurationFieldsData = infoJsonData.getAsJsonObject().get("configuration").getAsJsonObject().get("fields");
                for (JsonElement field : configurationFieldsData.getAsJsonArray()) {
                    JsonObject argument = field.getAsJsonObject();
                    String fieldType = argument.get("type").getAsString();
                    if ("password".equals(fieldType)) {
                        fieldTypePasswordKeys.add(argument.get("name").getAsString());
                    }
                    if (!argument.has("onchange")) continue;
                    JsonElement onChangeData = argument.get("onchange");
                    for (Map.Entry entry : onChangeData.getAsJsonObject().entrySet()) {
                        JsonElement onChangeParamList = (JsonElement)entry.getValue();
                        for (JsonElement onChangeParam : onChangeParamList.getAsJsonArray()) {
                            if (!"password".equals(onChangeParam.getAsJsonObject().get("type").getAsString())) continue;
                            fieldTypePasswordKeys.add(onChangeParam.getAsJsonObject().get("name").getAsString());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return fieldTypePasswordKeys;
    }

    public static Set<String> getActionPasswordParameter(String infoFilePath) {
        HashSet<String> fieldTypePasswordKeys = new HashSet<String>();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode infoJsonData = objectMapper.readTree(Paths.get(infoFilePath, new String[0]).toFile());
            JsonNode actionsFieldsData = infoJsonData.get("operations");
            for (JsonNode action : actionsFieldsData) {
                JsonNode actionParameters = action.get("parameters");
                for (JsonNode parameter : actionParameters) {
                    String fieldType = parameter.get("type").asText();
                    if (!"password".equals(fieldType)) continue;
                    fieldTypePasswordKeys.add(parameter.get("name").asText());
                }
            }
        }
        catch (IOException e) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("readJsonFileFailedIO"), e.getMessage()));
            logger.error("Unable to read info.json.", (Throwable)e);
        }
        return fieldTypePasswordKeys;
    }

    public static Set<String> getConfigAndActionsPasswordParameter(String infoFilePath) {
        Set<String> configParams = ConnectorUtils.getConfigurationPasswordParameter(infoFilePath);
        Set<String> actionParams = ConnectorUtils.getActionPasswordParameter(infoFilePath);
        actionParams.addAll(configParams);
        return actionParams;
    }

    public static boolean isValidConnectorName(String connectorName, Boolean displayMessage) {
        Pattern regex = Pattern.compile(Constants.INVALID_SPECIAL_CHARACTERS);
        if (regex.matcher(connectorName).find()) {
            if (displayMessage.booleanValue()) {
                CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("invalidConnectorNameMessage"));
            }
            return false;
        }
        return true;
    }

    public static Boolean isValidateParameter(ArrayList<Argument> connectorParameter) {
        for (Argument parameter : connectorParameter) {
            if (ConnectorUtils.isValidConnectorName(parameter.getName(), false) && ConnectorUtils.isValidConnectorName(parameter.getTitle(), false)) continue;
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("invalidConnectorNameMessage"));
            return false;
        }
        return true;
    }

    public static boolean containsJsonObjectWithSameName(JsonArray jsonArray, JsonObject newJsonObject) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject existingJsonObject = jsonArray.get(i).getAsJsonObject();
            if (!existingJsonObject.has("name") || !existingJsonObject.get("name").equals(newJsonObject.get("name"))) continue;
            return true;
        }
        return false;
    }

    public static JsonElement convertArgumentToJson(Argument arg) {
        Gson gson = new GsonBuilder().create();
        JsonElement fieldsArray = gson.toJsonTree((Object)arg);
        return fieldsArray;
    }

    public static Argument convertJsonToArgument(JsonElement json) {
        Gson gson = new GsonBuilder().create();
        Argument arg = (Argument)gson.fromJson(json, Argument.class);
        return arg;
    }

    public static Boolean isConfigurationArgumentExists(JsonObject connectorInfo) {
        if (!connectorInfo.has("configuration")) {
            return false;
        }
        if (!connectorInfo.get("configuration").getAsJsonObject().has("fields")) {
            return false;
        }
        if (connectorInfo.get("configuration").getAsJsonObject().get("fields").getAsJsonArray().size() == 0) {
            return false;
        }
        return true;
    }
}

