/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.utils;

import com.fortinet.fortisoar.utils.Constants;
import com.intellij.openapi.ui.Messages;
import java.awt.Desktop;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CommonUtils {
    public static void showErrorMessage(String message) {
        Messages.showMessageDialog((String)message, (String)Constants.POP_MESSAGE.getProperty("popUpTitle"), (Icon)Messages.getErrorIcon());
    }

    public static void showInfoMessage(String message) {
        Messages.showMessageDialog((String)message, (String)Constants.POP_MESSAGE.getProperty("popUpTitle"), (Icon)Messages.getInformationIcon());
    }

    public static boolean askYesNoQuestion(String question) {
        int messageDialog = Messages.showYesNoDialog((String)StringUtils.capitalize((String)question), (String)Constants.POP_MESSAGE.getProperty("popUpTitle"), (String)"Yes", (String)"No", (Icon)Messages.getQuestionIcon());
        return messageDialog != 1;
    }

    @NotNull
    public static Boolean stringIsNotEmptyOrNull(String str) {
        Boolean bl = str != null && !str.isEmpty() && !str.equals("null");
        if (bl == null) {
            CommonUtils.$$$reportNull$$$0(0);
        }
        return bl;
    }

    public static Boolean booleanIsNotEmptyOrNull(Boolean bool) {
        return bool != null;
    }

    public static Boolean checkValidOperationName(String name) {
        if ((name = name.strip()).isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String convertLowerCamelCase(String st) {
        st = st.strip();
        char[] ch = st.toCharArray();
        boolean flag = false;
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < st.length(); ++i) {
            if (i == 0) {
                res.append(Character.toLowerCase(ch[i]));
                continue;
            }
            if (ch[i] == ' ') {
                flag = true;
                continue;
            }
            if (flag) {
                res.append(Character.toUpperCase(ch[i]));
                flag = false;
                continue;
            }
            res.append(Character.toLowerCase(ch[i]));
        }
        return res.toString();
    }

    public static String convertToAPIName(String st) {
        st = st.strip();
        char[] ch = st.toCharArray();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < st.length(); ++i) {
            if (ch[i] == ' ') {
                res.append("_");
                continue;
            }
            res.append(Character.toLowerCase(ch[i]));
        }
        return res.toString();
    }

    public static String convertToConnectorName(String st) {
        st = st.strip();
        char[] ch = st.toCharArray();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < st.length(); ++i) {
            if (ch[i] == ' ') {
                res.append("-");
                continue;
            }
            res.append(Character.toLowerCase(ch[i]));
        }
        return res.toString();
    }

    public static String revertLowerCamelCase(String st) {
        st = st.strip();
        char[] ch = st.toCharArray();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < st.length(); ++i) {
            if (i == 0) {
                res.append(Character.toUpperCase(ch[i]));
                continue;
            }
            if (Character.isUpperCase(ch[i])) {
                res.append(" ").append(ch[i]);
                continue;
            }
            res.append(ch[i]);
        }
        return res.toString();
    }

    public static boolean isValidPythonPath(String pythonPath) {
        if (!pythonPath.isBlank()) {
            File file = new File(pythonPath);
            return file.exists() && file.canExecute();
        }
        CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("pythonPathNotConfigured"));
        return false;
    }

    public static boolean openWebpage(String urlStr) {
        try {
            URL url = new URL(urlStr);
            return CommonUtils.openWebpage(url.toURI());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/fortinet/fortisoar/utils/CommonUtils", "stringIsNotEmptyOrNull"));
    }
}

