/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.operation;

import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.operation.ArgumentsPanel;
import com.fortinet.fortisoar.ui.operation.ExecutionPanel;
import com.fortinet.fortisoar.ui.operation.OperationDetailsPanel;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.IOUtils;
import com.fortinet.fortisoar.utils.OnChangeUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.border.Border;
import org.jdesktop.swingx.JXButton;

public class OperationDialog
extends JBTabbedPane {
    private static Logger logger = Logger.getInstance(OperationDialog.class);
    public Project project;
    public boolean isChanged = false;
    private Operation operationDetail;
    private Argument operationArgument;
    private JPanel operationDetailPanel;
    private ArgumentsPanel operationArgumentPanel;
    private JPanel argumentsPanel;
    private JPanel buttonPanel;
    private JPanel finalArgsPanel;
    private JPanel wrapPanel;
    private GridBagConstraints generalPanelCons = new GridBagConstraints();
    private GridBagConstraints argumentsConstraints;
    private GridBagLayout argumentsPanelLayout;
    private JXButton newArgumentButton;
    private ArrayList<ArgumentsPanel> argPanelList = new ArrayList();
    private JBScrollPane argsScrollPanel;
    private ExecutionPanel executionPanel;

    public OperationDialog(Operation operationDetail, Project project) {
        this.operationDetail = operationDetail;
        this.operationArgument = new Argument();
        this.project = project;
        JBScrollPane finalDetailsPanel = this.createOperationDetailsScroll();
        this.finalArgsPanel = this.createArgumentsScroll();
        this.executionPanel = new ExecutionPanel(project, operationDetail);
        FSRTheme.decorateBackground((JComponent)finalDetailsPanel);
        this.addTab(Constants.UI_TEXT.getProperty("opDetailsTab"), (Component)finalDetailsPanel);
        this.addTab(Constants.UI_TEXT.getProperty("opArgsTab"), this.finalArgsPanel);
        this.addTab(Constants.UI_TEXT.getProperty("executeTab"), this.executionPanel);
        this.setVisible(true);
    }

    public Operation getOperationDetail() {
        return this.operationDetail;
    }

    private JPanel createArgumentsPanel() {
        this.argumentsPanel = new JPanel();
        Border titledBorder = FSRTheme.createFSRTitleBorder("opArgsBorder");
        this.argumentsPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.argumentsConstraints = new GridBagConstraints();
        this.argumentsConstraints.fill = 2;
        this.argumentsConstraints.weightx = 1.0;
        this.argumentsConstraints.weighty = 1.0;
        this.argumentsPanelLayout = new GridBagLayout();
        this.argumentsPanel.setLayout(this.argumentsPanelLayout);
        int i = 0;
        while (i < this.operationDetail.getParameters().size()) {
            ArgumentsPanel arg = new ArgumentsPanel(this.project, this.operationDetail.getParameters().get(i), this.operationDetail, this);
            this.argPanelList.add(arg);
            arg.setName(this.operationDetail.getParameters().get(i).getName());
            this.argumentsConstraints.gridy = i++;
            this.argumentsPanelLayout.setConstraints(arg, this.argumentsConstraints);
            this.argumentsPanel.add(arg);
        }
        FSRTheme.decorateBackground(this.argumentsPanel);
        return this.argumentsPanel;
    }

    private void addNewArgument() {
        this.argumentsConstraints.gridy = this.operationDetail.getParameters().size();
        this.argumentsConstraints.weightx = 1.0;
        this.argumentsConstraints.weighty = 1.0;
        this.argumentsConstraints.fill = 1;
        this.argumentsConstraints.insets = JBUI.insets((int)0);
        Argument arg = this.operationDetail.addEmptyArg();
        ArgumentsPanel newArg = new ArgumentsPanel(this.project, arg, this.operationDetail, this);
        this.argPanelList.add(newArg);
        this.argumentsPanelLayout.setConstraints(newArg, this.argumentsConstraints);
        this.argumentsPanel.add((Component)newArg, -1);
        this.argumentsConstraints.gridy = this.operationDetail.getParameters().size() + 1;
        this.argumentsConstraints.fill = 0;
        this.argumentsConstraints.anchor = 20;
        this.argumentsConstraints.insets = JBUI.insetsTop((int)10);
        this.argumentsPanel.revalidate();
        this.scrollDownPanel();
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        this.newArgumentButton = FSRTheme.createFSRTealButton("argsAdd", "/icons/add.png", ((Object)((Object)this)).getClass());
        this.newArgumentButton.addActionListener(e -> this.addNewArgument());
        JXButton saveButton = FSRTheme.createFSRSaveButton("argsSave", "/icons/save.png", ((Object)((Object)this)).getClass());
        saveButton.addActionListener(e -> {
            if (this.validateArgsPanel()) {
                try {
                    ArrayList<Argument> restructuredOperationsFields = OnChangeUtils.arrangeOnChangeParamToJson(this.operationDetail.getParameters());
                    if (!ConnectorUtils.isValidateParameter(restructuredOperationsFields).booleanValue()) {
                        return;
                    }
                    this.operationDetail.saveParamsField(restructuredOperationsFields);
                    ArgumentsPanel.getOnChangeParamOptionList(this.operationDetail);
                    IOUtils.reloadFromDisk(this.project);
                    this.executionPanel.reloadFields();
                    this.isChanged = false;
                }
                catch (Exception ex) {
                    logger.error("Save operation details failed.", (Throwable)ex);
                }
            }
        });
        JPanel emptyPanel1 = new JPanel();
        JPanel emptyPanel2 = new JPanel();
        FSRTheme.decorateBackground(emptyPanel1);
        FSRTheme.decorateBackground(emptyPanel2);
        buttonPanel.add((Component)saveButton, new GridConstraints(0, 3, 1, 1, 2, 2, 0, 0, null, null, null));
        buttonPanel.add((Component)this.newArgumentButton, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        buttonPanel.add((Component)emptyPanel2, new GridConstraints(0, 1, 1, 1, 1, 3, 3, 3, null, null, null));
        buttonPanel.add((Component)emptyPanel1, new GridConstraints(0, 0, 1, 1, 1, 3, 3, 3, null, null, null));
        FSRTheme.decorateBackground(buttonPanel);
        return buttonPanel;
    }

    private JPanel createArgumentsScroll() {
        JPanel argsPanel = this.createArgumentsPanel();
        this.argsScrollPanel = new JBScrollPane((Component)argsPanel, 20, 30);
        FSRTheme.setEmptyBorder((JComponent)this.argsScrollPanel);
        JPanel finalArgumentsPanel = new JPanel();
        finalArgumentsPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(finalArgumentsPanel);
        this.buttonPanel = this.createButtonPanel();
        finalArgumentsPanel.add((Component)this.buttonPanel, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, new Dimension(500, 10000)));
        finalArgumentsPanel.add((Component)this.argsScrollPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 10000)));
        return finalArgumentsPanel;
    }

    private JBScrollPane createOperationDetailsScroll() {
        OperationDetailsPanel operationDetailsPanel = new OperationDetailsPanel(this.operationDetail, this);
        JBScrollPane operationScrollPanel = new JBScrollPane((Component)operationDetailsPanel, 20, 30);
        FSRTheme.setEmptyBorder((JComponent)operationScrollPanel);
        return operationScrollPanel;
    }

    public void repaintArguments() {
        int argsPanelIndex = this.getSelectedIndex();
        this.remove(this.finalArgsPanel);
        this.finalArgsPanel = this.createArgumentsScroll();
        this.insertTab(Constants.UI_TEXT.getProperty("opArgsTab"), null, this.finalArgsPanel, "", argsPanelIndex);
        this.setSelectedIndex(argsPanelIndex);
    }

    private boolean validateArgsPanel() {
        boolean flag = true;
        for (ArgumentsPanel panel : this.argPanelList) {
            flag = panel.validateRequiredField() && flag;
        }
        return flag;
    }

    public void scrollDownPanel() {
        final JScrollBar verticalBar = this.argsScrollPanel.getVerticalScrollBar();
        AdjustmentListener scroller = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Adjustable adjustable = e.getAdjustable();
                adjustable.setValue(verticalBar.getMaximum());
                verticalBar.removeAdjustmentListener(this);
            }
        };
        verticalBar.addAdjustmentListener(scroller);
    }
}

