/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.operation;

import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.operation.ArgumentsPanel;
import com.fortinet.fortisoar.ui.operation.OperationDialog;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.IOUtils;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import org.jdesktop.swingx.JXButton;

public class OperationDetailsPanel
extends JPanel {
    private Operation operation;
    private JPanel basicPanel;
    private JPanel outputPanel;
    private JPanel actionsPanel;
    private JPanel saveButtonPanel;
    private JTextField nameTextField;
    private JTextField titleTextField;
    private JTextField annotationTextField;
    private ComboBox categoryField;
    private JCheckBox enabledField;
    private JCheckBox configRequiredField;
    private JCheckBox visibleField;
    private JTextArea descriptionTextField;
    private JTextArea outputSchemaField;
    private OperationDialog operationDialog;

    public OperationDetailsPanel(Operation operation, OperationDialog operationDialog) {
        this.operation = operation;
        this.operationDialog = operationDialog;
        this.basicPanel = new JPanel();
        this.basicPanel.setLayout((LayoutManager)new GridLayoutManager(12, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        Border titledBorder = FSRTheme.createFSRTitleBorder("opDetailsBasicBorder");
        this.basicPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        FSRTheme.decorateBackground(this.basicPanel);
        this.createTitleField();
        this.createNameField();
        this.createCategoryField();
        this.createDescriptionField();
        this.createAttributesField();
        this.createOutputPanel();
        this.createActionsPanel();
        this.createSaveButtonPanel(operationDialog);
        this.setLayout((LayoutManager)new GridLayoutManager(8, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        this.add((Component)this.basicPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 1000)));
        this.add((Component)this.outputPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 1000)));
        this.add((Component)this.actionsPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 1000)));
        this.add((Component)this.saveButtonPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 500)));
        FSRTheme.decorateBackground(this);
    }

    private void createNameField() {
        JLabel nameLabel = new JLabel();
        this.nameTextField = new JTextField(this.operation.getName());
        this.nameTextField.setName("nameTextField");
        FSRTheme.decorateInputField(this.nameTextField);
        this.nameTextField.setEditable(false);
        nameLabel.setLabelFor(this.nameTextField);
        nameLabel.setText(Constants.UI_TEXT.getProperty("opDetailsBasicName"));
        nameLabel.setToolTipText(Constants.TOOLTIP.getProperty("opNameTooltip", ""));
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                if (ConnectorUtils.validateRequiredField(OperationDetailsPanel.this.nameTextField, ArgumentsPanel.defaultBorderColor)) {
                    OperationDetailsPanel.this.operation.setName(OperationDetailsPanel.this.nameTextField.getText());
                }
                OperationDetailsPanel.this.operationDialog.isChanged = true;
            }
        });
        this.basicPanel.add((Component)nameLabel, new GridConstraints(1, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)this.nameTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createTitleField() {
        JLabel titleLabel = new JLabel();
        this.titleTextField = new JTextField(this.operation.getTitle());
        this.titleTextField.setName("titleTextField");
        FSRTheme.decorateInputField(this.titleTextField);
        titleLabel.setLabelFor(this.titleTextField);
        titleLabel.setText(Constants.UI_TEXT.getProperty("opDetailsBasicTitle"));
        titleLabel.setToolTipText(Constants.TOOLTIP.getProperty("opTitleTooltip", ""));
        this.titleTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                if (ConnectorUtils.validateRequiredField(OperationDetailsPanel.this.titleTextField, ArgumentsPanel.defaultBorderColor)) {
                    OperationDetailsPanel.this.operation.setTitle(OperationDetailsPanel.this.titleTextField.getText());
                    OperationDetailsPanel.this.operationDialog.isChanged = true;
                }
            }
        });
        this.basicPanel.add((Component)titleLabel, new GridConstraints(0, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)this.titleTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createAnnotationField() {
        JLabel annotationLabel = new JLabel();
        this.annotationTextField = new JTextField(this.operation.getAnnotation());
        this.annotationTextField.setName("annotationsTextField");
        this.annotationTextField.setBorder(LineBorder.createGrayLineBorder());
        annotationLabel.setLabelFor(this.nameTextField);
        annotationLabel.setText(Constants.UI_TEXT.getProperty("opDetailsBasicAnnotation"));
        this.annotationTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                OperationDetailsPanel.this.operation.setAnnotation(OperationDetailsPanel.this.annotationTextField.getText());
            }
        });
        this.basicPanel.add((Component)annotationLabel, new GridConstraints(2, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)this.annotationTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createCategoryField() {
        JLabel categoryLabel = new JLabel();
        categoryLabel.setLabelFor((Component)this.categoryField);
        categoryLabel.setText(Constants.UI_TEXT.getProperty("opDetailsBasicCategory"));
        categoryLabel.setToolTipText(Constants.TOOLTIP.getProperty("opCategoryTooltip", ""));
        this.categoryField = FSRTheme.createFSRComboBox(Constants.OPERATION_CATEGORY_OPTIONS);
        String currentType = this.operation.getCategory();
        if (currentType == null) {
            this.categoryField.setSelectedItem((Object)"Investigation");
            this.operation.setCategory("Investigation");
        } else if (!currentType.equals("Unknown")) {
            this.categoryField.setSelectedItem((Object)currentType);
        }
        this.basicPanel.add((Component)categoryLabel, new GridConstraints(3, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)this.categoryField, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 3, null, null, null));
        this.categoryField.addActionListener(e -> {
            ComboBox comboBox = (ComboBox)e.getSource();
            String selectedType = (String)comboBox.getSelectedItem();
            this.operation.setCategory(selectedType);
            this.operationDialog.isChanged = true;
        });
    }

    private void createDescriptionField() {
        JLabel descriptionLabel = new JLabel();
        this.descriptionTextField = FSRTheme.createFSRTextAreaField(this.operation.getDescription(), 1, 1);
        this.descriptionTextField.setLineWrap(true);
        this.descriptionTextField.setWrapStyleWord(true);
        this.descriptionTextField.setFont(descriptionLabel.getFont());
        JBScrollPane descriptionScrollPane = new JBScrollPane((Component)this.descriptionTextField);
        descriptionScrollPane.setPreferredSize(new Dimension(200, 100));
        descriptionLabel.setLabelFor(this.descriptionTextField);
        descriptionLabel.setText(Constants.UI_TEXT.getProperty("opDetailsBasicDescription"));
        descriptionLabel.setToolTipText(Constants.TOOLTIP.getProperty("opDescriptionTooltip", ""));
        this.descriptionTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                if (ConnectorUtils.validateRequiredField(OperationDetailsPanel.this.descriptionTextField, ArgumentsPanel.defaultBorderColor)) {
                    OperationDetailsPanel.this.operation.setDescription(OperationDetailsPanel.this.descriptionTextField.getText());
                    OperationDetailsPanel.this.operationDialog.isChanged = true;
                }
            }
        });
        this.basicPanel.add((Component)descriptionLabel, new GridConstraints(4, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)descriptionScrollPane, new GridConstraints(4, 1, 1, 1, 8, 3, 3, 3, new Dimension(100, 80), null, null));
    }

    private void createAttributesField() {
        JPanel checkBoxesWrapPanel = new JPanel();
        checkBoxesWrapPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        JLabel attributesLabel = new JLabel(Constants.UI_TEXT.getProperty("opDetailsBasicAttributes"));
        checkBoxesWrapPanel.add((Component)attributesLabel, new GridConstraints(0, 0, 1, 1, 3, 3, 0, 0, null, null, null));
        this.visibleField = FSRTheme.createFSRCheckBox("opDetailsBasicAttrVisible", "opVisibleTooltip", this.operation.getVisible());
        checkBoxesWrapPanel.add((Component)this.visibleField, new GridConstraints(0, 1, 1, 1, 8, 1, 1, 1, null, null, null));
        FSRTheme.decorateBackground(checkBoxesWrapPanel);
        this.visibleField.addActionListener(e -> {
            AbstractButton abstractButton = (AbstractButton)e.getSource();
            boolean selected = abstractButton.getModel().isSelected();
            this.operation.setVisible(selected);
            this.operationDialog.isChanged = true;
        });
        this.configRequiredField = FSRTheme.createFSRCheckBox("opDetailsBasicAttrConfigRequired", "opConfigRequired", this.operation.getIs_config_required());
        checkBoxesWrapPanel.add((Component)this.configRequiredField, new GridConstraints(0, 2, 1, 1, 8, 1, 1, 1, null, null, null));
        this.configRequiredField.addActionListener(e -> {
            AbstractButton abstractButton = (AbstractButton)e.getSource();
            boolean selected = abstractButton.getModel().isSelected();
            this.operation.setIs_config_required(selected);
            this.operationDialog.isChanged = true;
        });
        this.basicPanel.add((Component)attributesLabel, new GridConstraints(5, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)checkBoxesWrapPanel, new GridConstraints(5, 1, 1, 1, 8, 3, 3, 3, null, null, null));
    }

    private void createOutputPanel() {
        this.outputPanel = new JPanel();
        this.outputPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        Border outputTitledBorder = FSRTheme.createFSRTitleBorder("opDetailsOutputSchemaBorder");
        this.outputPanel.setBorder(BorderFactory.createCompoundBorder(outputTitledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.outputPanel.setToolTipText(Constants.TOOLTIP.getProperty("opOutputSchema", ""));
        JBScrollPane outputScrollPane = new JBScrollPane();
        this.outputSchemaField = new JTextArea(this.operation.getOutput_schema(), 1, 1);
        FSRTheme.decorateInputField(this.outputSchemaField);
        final JTextArea lines = new JTextArea();
        lines.setBackground(Color.LIGHT_GRAY);
        lines.setForeground(Color.BLACK);
        lines.setEditable(false);
        int caretPosition = this.outputSchemaField.getDocument().getLength();
        Element root = this.outputSchemaField.getDocument().getDefaultRootElement();
        StringBuilder text = new StringBuilder("1" + System.getProperty("line.separator"));
        for (int i = 2; i < root.getElementIndex(caretPosition) + 2; ++i) {
            text.append(i).append(System.getProperty("line.separator"));
        }
        lines.setText(text.toString());
        this.outputSchemaField.getDocument().addDocumentListener(new DocumentListener(){

            public String getText() {
                int caretPosition = OperationDetailsPanel.this.outputSchemaField.getDocument().getLength();
                Element root = OperationDetailsPanel.this.outputSchemaField.getDocument().getDefaultRootElement();
                String text = "1" + System.getProperty("line.separator");
                for (int i = 2; i < root.getElementIndex(caretPosition) + 2; ++i) {
                    text = text + i + System.getProperty("line.separator");
                }
                return text;
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                lines.setText(this.getText());
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                lines.setText(this.getText());
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                lines.setText(this.getText());
                this.updateLabel();
            }

            private void updateLabel() {
                OperationDetailsPanel.this.operation.setOutput_schema(OperationDetailsPanel.this.outputSchemaField.getText());
                OperationDetailsPanel.this.operationDialog.isChanged = true;
            }
        });
        outputScrollPane.getViewport().add(this.outputSchemaField);
        outputScrollPane.setRowHeaderView(lines);
        this.outputPanel.add((Component)outputScrollPane, new GridConstraints(0, 0, 1, 1, 3, 3, 3, 3, new Dimension(100, 400), null, null));
        FSRTheme.decorateBackground(this.outputPanel);
    }

    private void createActionsPanel() {
        this.actionsPanel = new JPanel();
        this.actionsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        Border buttonTitledBorder = FSRTheme.createFSRTitleBorder("operationsActionsBorder");
        this.actionsPanel.setBorder(BorderFactory.createCompoundBorder(buttonTitledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        FSRTheme.decorateBackground(this.actionsPanel);
        JXButton unitTestButton = FSRTheme.createFSRButton("operationActionsTest", "/icons/debug.png", "operationTestTooltip", this.getClass());
        this.actionsPanel.add((Component)unitTestButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        unitTestButton.addActionListener(e -> ConnectorUtils.testOperationAction(this.operationDialog.project, this.operation.infoFilePath, this.operation.getName(), this.operation.getConnectorName()));
        JXButton runButton = FSRTheme.createFSRButton("operationActionsRun", "/icons/run.png", "operationRunTooltip", this.getClass());
        this.actionsPanel.add((Component)runButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        runButton.addActionListener(e -> this.operationDialog.setSelectedIndex(2));
    }

    private void createSaveButtonPanel(OperationDialog operationDialog) {
        this.saveButtonPanel = new JPanel();
        this.saveButtonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        JXButton saveButton = FSRTheme.createFSRSaveButton("argsSave", "/icons/save.png", this.getClass());
        this.saveButtonPanel.add((Component)saveButton, new GridConstraints(0, 0, 1, 1, 6, 0, 3, 3, null, null, null));
        saveButton.addActionListener(e -> {
            if (this.validateRequiredFields()) {
                try {
                    if (!ConnectorUtils.isValidConnectorName(this.operation.getTitle(), false) || !ConnectorUtils.isValidConnectorName(this.operation.getAnnotation(), false)) {
                        CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("invalidConnectorNameMessage"));
                        return;
                    }
                    this.operation.save();
                    IOUtils.reloadFromDisk(operationDialog.project);
                    operationDialog.isChanged = false;
                }
                catch (Exception ex) {
                    ConnectorUtils.logger.error("Save operation details failed.", (Throwable)ex);
                }
            }
        });
        FSRTheme.decorateBackground(this.saveButtonPanel);
    }

    private boolean validateRequiredFields() {
        boolean flag = ConnectorUtils.validateRequiredField(this.nameTextField, ArgumentsPanel.defaultBorderColor);
        flag = ConnectorUtils.validateRequiredField(this.titleTextField, ArgumentsPanel.defaultBorderColor) && flag;
        flag = ConnectorUtils.validateRequiredField(this.descriptionTextField, ArgumentsPanel.defaultBorderColor) && flag;
        return flag;
    }
}

