/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.operation;

import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.connector.OperationsTabbedPane;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.jdesktop.swingx.JXButton;

public class OperationActionsPanel
extends JPanel {
    private final JPanel operationPanel;
    private final Operation operation;
    private final OperationsTabbedPane parent;
    private final Project project;

    public OperationActionsPanel(Project project, Operation operationDetail, OperationsTabbedPane parent) {
        this.operation = operationDetail;
        this.parent = parent;
        this.project = project;
        this.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        this.operationPanel = new JPanel();
        this.operationPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(operationDetail.getTitle());
        titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(14.0f));
        this.operationPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        FSRTheme.decorateBackground(this.operationPanel);
        this.createOperationLabel();
        this.createButtonsPanel();
        this.add((Component)this.operationPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        FSRTheme.decorateBackground(this);
    }

    private void createOperationLabel() {
        JLabel operationLabel = new JLabel();
        operationLabel.setText(this.operation.getDescription().strip());
        JTextArea operationDescriptionField = new JTextArea(this.operation.getDescription());
        operationDescriptionField.setName("operationDescriptionField");
        operationDescriptionField.setEditable(false);
        operationDescriptionField.setOpaque(false);
        operationDescriptionField.setFocusable(false);
        operationDescriptionField.setLineWrap(true);
        operationDescriptionField.setWrapStyleWord(true);
        this.operationPanel.add((Component)operationDescriptionField, new GridConstraints(0, 0, 1, 2, 0, 3, 2, 0, null, null, null));
    }

    private void createButtonsPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        TitledBorder buttonTitledBorder = BorderFactory.createTitledBorder(Constants.UI_TEXT.getProperty("operationsActionsBorder"));
        FSRTheme.decorateTitleBorder(buttonTitledBorder);
        buttonPanel.setBorder(buttonTitledBorder);
        FSRTheme.decorateBackground(buttonPanel);
        JXButton editButton = FSRTheme.createFSRButton("operationActionsEdit", "/icons/edit.png", "operationEditTooltip", this.getClass());
        buttonPanel.add((Component)editButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        editButton.addActionListener(e -> ConnectorUtils.openOperationFile(this.operation, this.parent, this.project, 0));
        JXButton deleteButton = FSRTheme.createFSRButton("operationActionsDelete", "/icons/delete.png", "operationDeleteTooltip", this.getClass());
        buttonPanel.add((Component)deleteButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        deleteButton.addActionListener(e -> {
            if (CommonUtils.askYesNoQuestion(String.format(Constants.POP_MESSAGE.getProperty("deleteOperationConfirmationMessage"), this.operation.getTitle()))) {
                this.parent.deleteOperation(this.operation);
            }
        });
        JXButton unitTestButton = FSRTheme.createFSRButton("operationActionsTest", "/icons/debug.png", "operationTestTooltip", this.getClass());
        buttonPanel.add((Component)unitTestButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        unitTestButton.addActionListener(e -> ConnectorUtils.testOperationAction(this.project, this.operation.infoFilePath, this.operation.getName(), this.parent.connector.getName()));
        JXButton runButton = FSRTheme.createFSRButton("operationActionsRun", "/icons/run.png", "operationRunTooltip", this.getClass());
        buttonPanel.add((Component)runButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        runButton.addActionListener(e -> ConnectorUtils.openOperationFile(this.operation, this.parent, this.project, 2));
        this.operationPanel.add((Component)buttonPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public void RunOperationAction() {
    }
}

