/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.operation;

import com.fortinet.fortisoar.init.PropReader;
import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.ui.CommonUIFields;
import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.operation.ArgumentsPanel;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.EncryptionDecryption;
import com.fortinet.fortisoar.utils.JsonUtils;
import com.fortinet.fortisoar.utils.OnChangeUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import org.jdesktop.swingx.JXButton;

public class ExecutionPanel
extends JPanel {
    private static final Logger logger = Logger.getInstance(ExecutionPanel.class);
    private final Operation operation;
    private final Project project;
    public HashMap<String, Object> allInputFields = new HashMap();
    private JPanel inputFieldPanel;
    private JBScrollPane inputFieldScrollPane;
    private JPanel buttonPanel;
    private JPanel outputSchemaScrollPane;
    private JBScrollPane outputSchemaScrollable;
    private JTextArea outputSchemaField;
    private JsonObject paramsData;
    private JsonElement outputSchemaData;
    private JsonObject localData;
    private String localDataFilePath;
    private ComboBox selectConfigField;
    private String[] allConfigOptions;
    private JPanel configPanel;
    private JPanel executePanel;
    private Map<String, String> fieldTypeSelectKeys = new HashMap<String, String>();
    private Set<String> fieldTypePasswordKeys;
    private int argumentPos;
    private List<Map<String, Object>> onChangeLabels;
    private List<Map<String, Object>> onChangeInputFields;
    public Set<String> requiredFields;
    private boolean isConfigurationArgumentExists;

    public ExecutionPanel(Project project, Operation operation) {
        assert (project != null);
        this.project = project;
        this.operation = operation;
        this.setLayout((LayoutManager)new GridLayoutManager(20, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        this.readLocalData();
        this.createExecutePanel();
        this.outputSchemaScrollPane = this.createOutputPanel();
        this.outputSchemaScrollable = new JBScrollPane((Component)this.outputSchemaScrollPane, 20, 30);
        FSRTheme.setEmptyBorder((JComponent)this.outputSchemaScrollable);
        this.add((Component)this.executePanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.add((Component)this.outputSchemaScrollable, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 10000)));
        FSRTheme.decorateBackground(this);
    }

    private void createExecutePanel() {
        this.createSelectConfigPanel();
        this.createInputFieldScrollPane();
        this.createButtonPanel();
        this.executePanel = new JPanel();
        this.executePanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.executePanel);
        this.executePanel.add((Component)this.configPanel, new GridConstraints(0, 0, 1, 1, 1, 3, 3, 3, null, null, new Dimension(500, 10000)));
        this.executePanel.add((Component)this.inputFieldScrollPane, new GridConstraints(1, 0, 1, 1, 1, 3, 3, 3, null, null, new Dimension(500, 10000)));
        this.executePanel.add((Component)this.buttonPanel, new GridConstraints(2, 0, 1, 1, 1, 3, 3, 3, null, null, new Dimension(500, 10000)));
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.buttonPanel);
        JXButton reloadButton = FSRTheme.createFSRButton("resetExecuteButton", "/icons/refresh.png", "operationResetTooltip", this.getClass());
        reloadButton.addActionListener(e -> this.reloadFields());
        JXButton saveButton = FSRTheme.createFSRSaveButton("saveExecuteButton", "/icons/save.png", this.getClass());
        saveButton.addActionListener(e -> this.saveParamsFields(true));
        JPanel emptyPanel1 = new JPanel();
        JPanel emptyPanel2 = new JPanel();
        FSRTheme.decorateBackground(emptyPanel1);
        FSRTheme.decorateBackground(emptyPanel2);
        this.buttonPanel.add((Component)saveButton, new GridConstraints(0, 3, 1, 1, 6, 0, 0, 0, null, null, null));
        this.buttonPanel.add((Component)reloadButton, new GridConstraints(0, 2, 1, 1, 6, 0, 0, 0, null, null, null));
        this.buttonPanel.add((Component)emptyPanel2, new GridConstraints(0, 1, 1, 1, 1, 3, 3, 3, null, null, null));
        this.buttonPanel.add((Component)emptyPanel1, new GridConstraints(0, 0, 1, 1, 1, 3, 3, 3, null, null, null));
    }

    private void createInputFieldScrollPane() {
        this.createInputFieldPanel();
        this.inputFieldScrollPane = new JBScrollPane((Component)this.inputFieldPanel, 20, 30);
        FSRTheme.setEmptyBorder((JComponent)this.inputFieldScrollPane);
    }

    private void createInputFieldPanel() {
        ArrayList<Argument> parameters = this.operation.getParameters();
        this.inputFieldPanel = new JPanel();
        Border titledBorder = FSRTheme.createFSRTitleBorder("executeInputFieldsBorder");
        this.inputFieldPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        FSRTheme.decorateBackground(this.inputFieldPanel);
        this.inputFieldPanel.setLayout((LayoutManager)new GridLayoutManager(parameters.size() + 1, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        this.argumentPos = 1;
        this.onChangeLabels = new ArrayList<Map<String, Object>>();
        this.onChangeInputFields = new ArrayList<Map<String, Object>>();
        this.requiredFields = new HashSet<String>();
        for (int i = 0; i < parameters.size(); ++i) {
            this.addInputField(parameters.get(i));
        }
    }

    private JPanel createOutputPanel() {
        JPanel outputPanel = new JPanel();
        outputPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        Border outputTitledBorder = FSRTheme.createFSRTitleBorder("executeCaptureOutputSchemaFieldsBorder");
        outputPanel.setBorder(BorderFactory.createCompoundBorder(outputTitledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        outputPanel.setToolTipText(Constants.TOOLTIP.getProperty("opOutputSchema", ""));
        FSRTheme.decorateBackground(outputPanel);
        JBScrollPane outputScrollPane = new JBScrollPane();
        this.outputSchemaField = new JTextArea(JsonUtils.convertToJsonPrettyString(this.outputSchemaData), 1, 1);
        FSRTheme.decorateInputField(this.outputSchemaField);
        final JTextArea lines = new JTextArea();
        lines.setBackground((Color)JBColor.LIGHT_GRAY);
        lines.setForeground((Color)JBColor.BLACK);
        lines.setEditable(false);
        int caretPosition = this.outputSchemaField.getDocument().getLength();
        Element root = this.outputSchemaField.getDocument().getDefaultRootElement();
        StringBuilder text = new StringBuilder("1" + System.getProperty("line.separator"));
        for (int i = 2; i < root.getElementIndex(caretPosition) + 2; ++i) {
            text.append(i).append(System.getProperty("line.separator"));
        }
        lines.setText(text.toString());
        this.outputSchemaField.getDocument().addDocumentListener(new DocumentListener(){

            public String getText() {
                int caretPosition = ExecutionPanel.this.outputSchemaField.getDocument().getLength();
                Element root = ExecutionPanel.this.outputSchemaField.getDocument().getDefaultRootElement();
                String text = "1" + System.getProperty("line.separator");
                for (int i = 2; i < root.getElementIndex(caretPosition) + 2; ++i) {
                    text = text + i + System.getProperty("line.separator");
                }
                return text;
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                lines.setText(this.getText());
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                lines.setText(this.getText());
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                lines.setText(this.getText());
                this.updateLabel();
            }

            private void updateLabel() {
                ExecutionPanel.this.operation.setOutput_schema(ExecutionPanel.this.outputSchemaData);
            }
        });
        outputScrollPane.getViewport().add(this.outputSchemaField);
        outputScrollPane.setRowHeaderView(lines);
        JPanel outputSchemaButtonPanel = this.createUpdateOutputSchemaButtonPanel();
        outputPanel.add((Component)outputScrollPane, new GridConstraints(0, 0, 1, 1, 3, 3, 3, 3, new Dimension(100, 300), null, null));
        outputPanel.add((Component)outputSchemaButtonPanel, new GridConstraints(1, 0, 1, 1, 3, 3, 3, 3, null, null, null));
        return outputPanel;
    }

    private JPanel createUpdateOutputSchemaButtonPanel() {
        JPanel outputSchemaButtonPanel = new JPanel();
        outputSchemaButtonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(outputSchemaButtonPanel);
        JXButton captureOutputSchemaButton = FSRTheme.createFSRButton("captureOutputSchemaButton", "/icons/capture.png", "opOutputSchema", this.getClass());
        captureOutputSchemaButton.addActionListener(e -> {
            if (this.validateRequiredFields()) {
                this.triggerCaptureOutputSchema();
            }
        });
        JXButton updateOutputSchemaButton = FSRTheme.createFSRSaveButton("updateOutputSchemaButton", "/icons/save.png", this.getClass());
        updateOutputSchemaButton.addActionListener(e -> this.triggerUpdateOutputSchema());
        JPanel emptyPanel1 = new JPanel();
        JPanel emptyPanel2 = new JPanel();
        FSRTheme.decorateBackground(emptyPanel1);
        FSRTheme.decorateBackground(emptyPanel2);
        outputSchemaButtonPanel.add((Component)updateOutputSchemaButton, new GridConstraints(0, 3, 1, 1, 6, 0, 0, 0, null, null, null));
        outputSchemaButtonPanel.add((Component)captureOutputSchemaButton, new GridConstraints(0, 2, 1, 1, 6, 0, 0, 0, null, null, null));
        outputSchemaButtonPanel.add((Component)emptyPanel2, new GridConstraints(0, 1, 1, 1, 1, 3, 3, 3, null, null, null));
        outputSchemaButtonPanel.add((Component)emptyPanel1, new GridConstraints(0, 0, 1, 1, 1, 3, 3, 3, null, null, null));
        return outputSchemaButtonPanel;
    }

    private void createSelectConfigPanel() {
        this.configPanel = new JPanel();
        this.configPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.configPanel);
        this.isConfigurationArgumentExists = ConnectorUtils.isConfigurationArgumentExists(this.operation.getInfoContentObj());
        if (!this.isConfigurationArgumentExists) {
            String noConfigurationMessage = Constants.UI_TEXT.getProperty("noConfigurationExistsMessage");
            JTextArea noConfigurationField = CommonUIFields.createMessageField(noConfigurationMessage);
            this.configPanel.add((Component)noConfigurationField, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
            return;
        }
        Border titledBorder = FSRTheme.createFSRTitleBorder("executeSelectConfigBorder");
        this.configPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.selectConfigField = CommonUIFields.createDropDownField("config", this.allConfigOptions, "", "Select a configuration", true);
        FSRTheme.decorateInputField((JComponent)this.selectConfigField);
        this.configPanel.add((Component)this.selectConfigField, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void addInputField(Argument arg) {
        if (arg.getRequired().booleanValue() && !arg.getIsOnChange().booleanValue()) {
            this.requiredFields.add(arg.getName());
        }
        if (!arg.getIsOnChange().booleanValue()) {
            JLabel label = CommonUIFields.createLabel(arg.getName(), arg.getType(), arg.getTooltip(), arg.getRequired());
            Component inputField = this.createArgumentField(label, arg);
            this.allInputFields.put(arg.getName(), inputField);
        }
    }

    public Component createArgumentField(JLabel onChangeLabel, Argument arg) {
        Component inputField;
        JsonArray multiSelectValue = new JsonArray();
        String argType = arg.getType();
        String argName = arg.getName();
        String argValue = arg.getValue();
        String argTooltip = arg.getTooltip();
        boolean argRequired = arg.getRequired();
        if (this.paramsData.has(argName)) {
            this.fieldTypePasswordKeys = ConnectorUtils.getConfigurationPasswordParameter(this.operation.getInfoFilePath());
            if (this.fieldTypePasswordKeys.contains(argName)) {
                argValue = EncryptionDecryption.decryptData(this.paramsData.get(argName).getAsString());
            } else if (!argType.equals("Multiselect")) {
                argValue = this.paramsData.get(argName).getAsString();
            } else if (this.paramsData.get(arg.getName()) instanceof JsonArray) {
                multiSelectValue = this.paramsData.get(argName).getAsJsonArray();
            } else {
                multiSelectValue.add((JsonElement)this.paramsData.get(arg.getName()).getAsJsonPrimitive());
            }
        }
        if (argType.equals("Text") || argType.equals("Integer") || argType.equals("Datetime")) {
            inputField = CommonUIFields.createTextField(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField(inputField);
        } else if (argType.equals("Password")) {
            inputField = CommonUIFields.createPasswordField(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JPasswordField)inputField);
        } else if (argType.equals("Textarea") || argType.equals("Json")) {
            inputField = CommonUIFields.createTextArea(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JTextArea)inputField);
        } else if (argType.equals("Select")) {
            inputField = this.createSelectArgumentField(arg);
            FSRTheme.decorateInputField((JComponent)((ComboBox)inputField));
        } else if (argType.equals("Multiselect")) {
            String[] onChangeArgOptions = ConnectorUtils.createDropDownValue(arg);
            this.fieldTypeSelectKeys.put(arg.getName(), "multiselect");
            inputField = CommonUIFields.createMultiSelectDropDownField(argName, onChangeArgOptions, multiSelectValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JComponent)((JBList)inputField));
        } else if (argType.equals("Checkbox")) {
            inputField = this.createCheckBoxInputField(arg);
            FSRTheme.decorateInputField((JCheckBox)inputField);
        } else if (argType.equals(PropReader.UIText.getProperty("argsTypeOperation"))) {
            inputField = CommonUIFields.createDropDownField(argName, this.operation.getOperationsList(), argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JComponent)((ComboBox)inputField));
        } else {
            inputField = CommonUIFields.createTextField(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField(inputField);
        }
        this.inputFieldPanel.add((Component)onChangeLabel, new GridConstraints(this.argumentPos, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.inputFieldPanel.add(inputField, new GridConstraints(this.argumentPos, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        ++this.argumentPos;
        return inputField;
    }

    private Component createCheckBoxInputField(Argument arg) {
        boolean isSelected = false;
        if (this.paramsData.has(arg.getName())) {
            isSelected = this.paramsData.get(arg.getName()).getAsBoolean();
        }
        boolean value = arg.getValue().equals("true");
        JCheckBox checkBoxInputField = CommonUIFields.createCheckBoxField(arg.getName(), value, arg.getTooltip());
        checkBoxInputField.setSelected(isSelected);
        this.allInputFields.put(arg.getName(), checkBoxInputField);
        if (arg.getOnchange() != null) {
            checkBoxInputField.addActionListener(e -> {
                Boolean checkBoxInputFieldSelected = checkBoxInputField.isSelected();
                JsonObject jsonObject = ConnectorUtils.convertArgumentToJson(arg).getAsJsonObject();
                JsonObject onChangeJsonObject = jsonObject.get("onchange").getAsJsonObject();
                OnChangeUtils.markOnChangeParamVisible(this.onChangeLabels, onChangeJsonObject, checkBoxInputFieldSelected, this.paramsData);
                OnChangeUtils.markOnChangeParamVisible(this.onChangeInputFields, onChangeJsonObject, checkBoxInputFieldSelected, this.paramsData);
            });
            for (Map.Entry entry : arg.getOnchange().getAsJsonObject().entrySet()) {
                for (JsonElement jsonElement : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    Argument onChangeArg = ConnectorUtils.convertJsonToArgument(jsonElement);
                    JLabel onChangeLabel = CommonUIFields.createLabel(onChangeArg.getName(), onChangeArg.getType(), onChangeArg.getTooltip(), onChangeArg.getRequired());
                    Component onChangeInputField = this.createArgumentField(onChangeLabel, onChangeArg);
                    HashMap<String, Object> argumentLabel = new HashMap<String, Object>();
                    argumentLabel.put("onChangeArgumentName", onChangeArg.getName());
                    argumentLabel.put("onChangeOption", onChangeArg.getOnChangeOption());
                    argumentLabel.put("onChangeLabel", onChangeLabel);
                    this.onChangeLabels.add(argumentLabel);
                    HashMap<String, Object> argumentTextField = new HashMap<String, Object>();
                    argumentTextField.put("onChangeArgumentName", onChangeArg.getName());
                    argumentTextField.put("onChangeOption", onChangeArg.getOnChangeOption());
                    argumentTextField.put("onChangeComponent", onChangeInputField);
                    this.onChangeInputFields.add(argumentTextField);
                    onChangeLabel.setVisible(false);
                    onChangeInputField.setVisible(false);
                    if (!checkBoxInputField.isSelected()) continue;
                    onChangeLabel.setVisible(true);
                    onChangeInputField.setVisible(true);
                }
            }
        }
        return checkBoxInputField;
    }

    private Component createSelectArgumentField(Argument arg) {
        String selectArgValue = arg.getValue();
        if (this.paramsData.has(arg.getName())) {
            selectArgValue = this.paramsData.get(arg.getName()) instanceof JsonPrimitive ? this.paramsData.get(arg.getName()).getAsJsonPrimitive().getAsString() : (this.paramsData.get(arg.getName()) instanceof JsonArray ? this.paramsData.get(arg.getName()).getAsJsonArray().get(0).getAsString() : this.paramsData.get(arg.getName()).getAsString());
        }
        String[] argOptions = ConnectorUtils.createDropDownValue(arg);
        this.fieldTypeSelectKeys.put(arg.getName(), "select");
        ComboBox selectInputField = CommonUIFields.createDropDownField(arg.getName(), argOptions, selectArgValue, arg.getTooltip(), arg.getRequired());
        FSRTheme.decorateInputField((JComponent)selectInputField);
        this.allInputFields.put(arg.getName(), selectInputField);
        if (arg.getOnchange() != null) {
            selectInputField.addActionListener(e -> {
                String selectedOperation = (String)selectInputField.getSelectedItem();
                JsonObject jsonObject = ConnectorUtils.convertArgumentToJson(arg).getAsJsonObject();
                JsonObject onChangeJsonObject = jsonObject.get("onchange").getAsJsonObject();
                OnChangeUtils.markOnChangeParamVisible(this.onChangeLabels, onChangeJsonObject, selectedOperation, this.paramsData);
                OnChangeUtils.markOnChangeParamVisible(this.onChangeInputFields, onChangeJsonObject, selectedOperation, this.paramsData);
            });
            for (Map.Entry entry : arg.getOnchange().getAsJsonObject().entrySet()) {
                for (JsonElement jsonElement : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    Argument onChangeArg = ConnectorUtils.convertJsonToArgument(jsonElement);
                    JLabel onChangeLabel = CommonUIFields.createLabel(onChangeArg.getName(), onChangeArg.getType(), onChangeArg.getTooltip(), onChangeArg.getRequired());
                    Component onChangeInputField = this.createArgumentField(onChangeLabel, onChangeArg);
                    HashMap<String, Object> argumentLabel = new HashMap<String, Object>();
                    argumentLabel.put("onChangeArgumentName", onChangeArg.getName());
                    argumentLabel.put("onChangeOption", onChangeArg.getOnChangeOption());
                    argumentLabel.put("onChangeLabel", onChangeLabel);
                    this.onChangeLabels.add(argumentLabel);
                    HashMap<String, Object> argumentTextField = new HashMap<String, Object>();
                    argumentTextField.put("onChangeArgumentName", onChangeArg.getName());
                    argumentTextField.put("onChangeOption", onChangeArg.getOnChangeOption());
                    argumentTextField.put("onChangeComponent", onChangeInputField);
                    this.onChangeInputFields.add(argumentTextField);
                    onChangeLabel.setVisible(false);
                    onChangeInputField.setVisible(false);
                    if (!selectInputField.getSelectedItem().equals(onChangeArg.getOnChangeOption())) continue;
                    onChangeLabel.setVisible(true);
                    onChangeInputField.setVisible(true);
                }
            }
        }
        return selectInputField;
    }

    private boolean validateRequiredFields() {
        boolean flag = true;
        for (String key : this.requiredFields) {
            Component obj = (Component)this.allInputFields.get(key);
            if (obj instanceof JTextField) {
                flag = ConnectorUtils.validateRequiredField((JTextField)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue;
            }
            if (obj instanceof JTextArea) {
                flag = ConnectorUtils.validateRequiredField((JTextArea)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue;
            }
            if (obj instanceof ComboBox) {
                flag = ConnectorUtils.validateRequiredField((ComboBox)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue;
            }
            if (!(obj instanceof JBList)) continue;
            flag = ConnectorUtils.validateRequiredField((JBList)obj, ArgumentsPanel.defaultBorderColor) && flag;
        }
        block1: for (int i = 0; i < this.onChangeInputFields.size(); ++i) {
            Map<String, Object> onChangeObject = this.onChangeInputFields.get(i);
            for (Argument arg : this.operation.getParameters()) {
                if (!arg.getIsOnChange().booleanValue() || !arg.getRequired().booleanValue() || !arg.getOnChangeOption().equals(onChangeObject.get("onChangeOption")) || !arg.getName().equals(onChangeObject.get("onChangeArgumentName"))) continue;
                Component obj = (Component)onChangeObject.get("onChangeComponent");
                if (obj instanceof JTextField) {
                    if (!obj.isVisible()) continue block1;
                    flag = ConnectorUtils.validateRequiredField((JTextField)obj, ArgumentsPanel.defaultBorderColor) && flag;
                    continue block1;
                }
                if (obj instanceof JTextArea) {
                    if (!obj.isVisible()) continue block1;
                    flag = ConnectorUtils.validateRequiredField((JTextArea)obj, ArgumentsPanel.defaultBorderColor) && flag;
                    continue block1;
                }
                if (obj instanceof ComboBox) {
                    if (!obj.isVisible()) continue block1;
                    flag = ConnectorUtils.validateRequiredField((ComboBox)obj, ArgumentsPanel.defaultBorderColor) && flag;
                    continue block1;
                }
                if (!(obj instanceof JBList) || !obj.isVisible()) continue block1;
                flag = ConnectorUtils.validateRequiredField((JBList)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue block1;
            }
        }
        return flag;
    }

    private void updateParamsFields() {
        this.allInputFields.forEach((key, obj) -> {
            if (obj instanceof JTextField) {
                this.paramsData.addProperty(key, ((JTextField)obj).getText());
            } else if (obj instanceof JTextArea) {
                this.paramsData.addProperty(key, ((JTextArea)obj).getText());
            } else if (obj instanceof ComboBox) {
                this.paramsData.addProperty(key, ((ComboBox)obj).getSelectedItem().toString());
            } else if (obj instanceof JCheckBox) {
                JCheckBox abstractButton = (JCheckBox)obj;
                boolean selected = abstractButton.getModel().isSelected();
                this.paramsData.addProperty(key, Boolean.valueOf(selected));
            } else if (obj instanceof JBList) {
                JsonArray jsonArray = new JsonArray();
                for (Object option : ((JBList)obj).getSelectedValuesList()) {
                    jsonArray.add((String)option);
                }
                this.paramsData.add(key, (JsonElement)jsonArray);
            }
        });
        for (int i = 0; i < this.onChangeInputFields.size(); ++i) {
            Map<String, Object> onChangeObject = this.onChangeInputFields.get(i);
            Component obj2 = (Component)onChangeObject.get("onChangeComponent");
            if (obj2 instanceof JTextField) {
                if (!obj2.isVisible()) continue;
                this.paramsData.addProperty((String)onChangeObject.get("onChangeArgumentName"), ((JTextField)obj2).getText());
                continue;
            }
            if (obj2 instanceof JTextArea) {
                if (!obj2.isVisible()) continue;
                this.paramsData.addProperty((String)onChangeObject.get("onChangeArgumentName"), ((JTextArea)obj2).getText());
                continue;
            }
            if (obj2 instanceof ComboBox) {
                if (!obj2.isVisible()) continue;
                this.paramsData.addProperty((String)onChangeObject.get("onChangeArgumentName"), ((ComboBox)obj2).getSelectedItem().toString());
                continue;
            }
            if (obj2 instanceof JCheckBox) {
                if (!obj2.isVisible()) continue;
                JCheckBox abstractButton = (JCheckBox)obj2;
                boolean selected = abstractButton.getModel().isSelected();
                this.paramsData.addProperty((String)onChangeObject.get("onChangeArgumentName"), Boolean.valueOf(selected));
                continue;
            }
            if (!(obj2 instanceof JBList) || !obj2.isVisible()) continue;
            JsonArray jsonArray = new JsonArray();
            for (Object option : ((JBList)obj2).getSelectedValuesList()) {
                jsonArray.add((String)option);
            }
            this.paramsData.add((String)onChangeObject.get("onChangeArgumentName"), (JsonElement)jsonArray);
        }
    }

    private boolean saveParamsFields(boolean showPopup) {
        if (this.validateRequiredFields()) {
            try {
                this.updateParamsFields();
                ConnectorUtils.setDropDownValueAsEmpty(this.fieldTypeSelectKeys, this.paramsData);
                this.writeLocalData();
                this.createOperationConfiguration();
                if (showPopup) {
                    CommonUtils.showInfoMessage(String.format(PropReader.popMessage.getProperty("saveConfigurationMessage"), this.operation.getTitle()));
                }
                return true;
            }
            catch (Exception ex) {
                logger.debug("Save operation params value failed.", (Throwable)ex);
                if (showPopup) {
                    CommonUtils.showErrorMessage(PropReader.popMessage.getProperty("saveFailedMessage"));
                }
                return false;
            }
        }
        return false;
    }

    public void createOperationConfiguration() {
        String config_name = null;
        if (this.isConfigurationArgumentExists) {
            config_name = (String)this.selectConfigField.getSelectedItem();
        }
        this.fieldTypePasswordKeys = ConnectorUtils.getConfigAndActionsPasswordParameter(this.operation.getInfoFilePath());
        HashMap<String, String> configParam = new HashMap<String, String>();
        configParam.put("config", config_name);
        configParam.put("params", this.operation.getName());
        ConnectorUtils.createConfiguration(this.project, this.operation.getInfoFilePath(), this.operation.getName(), this.fieldTypePasswordKeys, configParam, false);
    }

    private void triggerCaptureOutputSchema() {
        if (this.saveParamsFields(false) && ConnectorUtils.validateRequiredField(this.selectConfigField, ArgumentsPanel.defaultBorderColor)) {
            String config_name = "";
            if (this.isConfigurationArgumentExists) {
                config_name = (String)this.selectConfigField.getSelectedItem();
            }
            this.fieldTypePasswordKeys = ConnectorUtils.getConfigAndActionsPasswordParameter(this.operation.getInfoFilePath());
            ColoredProcessHandler process = ConnectorUtils.captureOutputSchema(this.project, this.operation.getInfoFilePath(), config_name, this.operation.getName(), this.fieldTypePasswordKeys);
            if (process != null) {
                CompletableFuture.runAsync(() -> {
                    process.waitFor();
                    this.reloadCaptureOutputPanel();
                    CommonUtils.showInfoMessage(PropReader.popMessage.getProperty("capturedOutputSchemaMsg"));
                });
            }
        }
    }

    private void reloadCaptureOutputPanel() {
        this.readLocalData();
        this.outputSchemaField.setText(JsonUtils.convertToJsonPrettyString(this.outputSchemaData));
        this.outputSchemaScrollPane.revalidate();
        this.outputSchemaScrollPane.repaint();
    }

    private void triggerUpdateOutputSchema() {
        try {
            this.operation.setOutput_schema(this.outputSchemaData);
            this.operation.save();
        }
        catch (Exception ex) {
            CommonUtils.showErrorMessage(PropReader.popMessage.getProperty("failedUpdatedOutputSchemaMsg"));
        }
    }

    public void reloadFields() {
        this.readLocalData();
        this.remove(this.executePanel);
        this.createExecutePanel();
        this.add((Component)this.executePanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.revalidate();
        this.repaint();
    }

    private void readLocalData() {
        JsonObject allParamsData;
        JsonObject connLocalData;
        this.localDataFilePath = Paths.get(Objects.requireNonNull(this.project.getBasePath()), "/.fortisoar/local_data.json").toString();
        JsonUtils.createLocalDataFileIfNotFound(this.localDataFilePath);
        this.localData = JsonUtils.readJsonFile(this.localDataFilePath);
        if (!this.localData.has(this.operation.getConnectorName())) {
            this.localData.add(this.operation.getConnectorName(), (JsonElement)new JsonObject());
        }
        if (!(connLocalData = this.localData.get(this.operation.getConnectorName()).getAsJsonObject()).has("config")) {
            connLocalData.add("config", (JsonElement)new JsonObject());
        }
        if (!connLocalData.has("params")) {
            connLocalData.add("params", (JsonElement)new JsonObject());
        }
        if (!connLocalData.has("output_schema")) {
            connLocalData.add("output_schema", (JsonElement)new JsonObject());
        }
        if (!(allParamsData = connLocalData.get("params").getAsJsonObject()).has(this.operation.getName())) {
            allParamsData.add(this.operation.getName(), (JsonElement)new JsonObject());
        }
        this.paramsData = allParamsData.get(this.operation.getName()).getAsJsonObject();
        JsonObject configData = connLocalData.get("config").getAsJsonObject();
        this.allConfigOptions = configData.keySet().toArray(new String[0]);
        JsonObject allOutputSchema = connLocalData.get("output_schema").getAsJsonObject();
        if (!allOutputSchema.has(this.operation.getName())) {
            allOutputSchema.add(this.operation.getName(), (JsonElement)new JsonObject());
        }
        try {
            this.outputSchemaData = allOutputSchema.get(this.operation.getName());
        }
        catch (Exception ex) {
            this.outputSchemaData = new JsonObject();
        }
    }

    private void writeLocalData() {
        JsonObject prevLocalData = JsonUtils.readJsonFile(this.localDataFilePath);
        this.fieldTypePasswordKeys = ConnectorUtils.getActionPasswordParameter(this.operation.getInfoFilePath());
        this.localData = EncryptionDecryption.encryptJsonData(this.fieldTypePasswordKeys, this.localData, this.operation.getConnectorName(), "params", this.operation.getOperation());
        JsonObject currentActionJson = this.localData.get(this.operation.getConnectorName()).getAsJsonObject().get("params").getAsJsonObject().get(this.operation.getOperation()).getAsJsonObject();
        ConnectorUtils.setDropDownValueAsEmpty(this.fieldTypeSelectKeys, currentActionJson);
        this.localData = JsonUtils.updateLocalDataJsonObject(prevLocalData, this.localData);
        JsonUtils.writeInfoJsonFile(this.localDataFilePath, this.localData);
    }
}

