/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.connector;

import com.fortinet.fortisoar.model.Connector;
import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.connector.ConnectorDialog;
import com.fortinet.fortisoar.ui.operation.NewOperationPanel;
import com.fortinet.fortisoar.ui.operation.OperationActionsPanel;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.IOUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jdesktop.swingx.JXButton;

public class OperationsTabbedPane
extends JTabbedPane {
    private static final Logger logger = Logger.getInstance(OperationsTabbedPane.class);
    public final Project project;
    public final Connector connector;
    private GridBagConstraints argumentsConstraints;
    private ConnectorDialog parent;
    Properties popMessage = Constants.POP_MESSAGE;

    public OperationsTabbedPane(Project project, Connector connector, ConnectorDialog parent) {
        this.project = project;
        this.connector = connector;
        JPanel allOperationsPanel = this.createOperationsScroll();
        this.addTab(String.format(Constants.UI_TEXT.getProperty("allOperationsTab"), connector.getOperationsList().length), allOperationsPanel);
    }

    private JPanel createOperationsScroll() {
        JPanel operationsPanel = this.createOperationsPanel();
        JBScrollPane scrollOperationsPanel = new JBScrollPane((Component)operationsPanel, 20, 30);
        FSRTheme.setEmptyBorder((JComponent)scrollOperationsPanel);
        JPanel finalOperationPanel = new JPanel();
        finalOperationPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.insets((int)5, (int)5), -1, -1));
        FSRTheme.decorateBackground(finalOperationPanel);
        JPanel newOperation = this.createNewOperationPanel();
        finalOperationPanel.add((Component)newOperation, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, new Dimension(500, 10000)));
        finalOperationPanel.add((Component)scrollOperationsPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 10000)));
        return finalOperationPanel;
    }

    private JPanel createOperationsPanel() {
        JPanel operationsPanel = new JPanel();
        Border titledBorder = FSRTheme.createFSRTitleBorder("operationsBorder");
        operationsPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.argumentsConstraints = new GridBagConstraints();
        this.argumentsConstraints.fill = 2;
        this.argumentsConstraints.weightx = 1.0;
        this.argumentsConstraints.weighty = 1.0;
        GridBagLayout operationsPanelLayout = new GridBagLayout();
        operationsPanel.setLayout(operationsPanelLayout);
        int i = 0;
        while (i < this.connector.getOperations().size()) {
            OperationActionsPanel operation = new OperationActionsPanel(this.project, this.connector.getOperations().get(i), this);
            operation.setName(this.connector.getOperations().get(i).getName());
            this.argumentsConstraints.gridy = i++;
            operationsPanelLayout.setConstraints(operation, this.argumentsConstraints);
            operationsPanel.add(operation);
        }
        FSRTheme.decorateBackground(operationsPanel);
        return operationsPanel;
    }

    private JPanel createNewOperationPanel() {
        JPanel operationsPanel = new JPanel();
        operationsPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        NewOperationPanel newOperationPanel = new NewOperationPanel(this);
        this.argumentsConstraints = new GridBagConstraints();
        this.argumentsConstraints.fill = 2;
        this.argumentsConstraints.weightx = 1.0;
        this.argumentsConstraints.weighty = 1.0;
        this.argumentsConstraints.anchor = 1;
        GridBagLayout operationsPanelLayout = new GridBagLayout();
        JXButton newOperationButton = FSRTheme.createFSRTealButton("operationAddNew", "/icons/add.png", this.getClass());
        newOperationButton.addActionListener(e -> newOperationPanel.setVisible(!newOperationPanel.isVisible()));
        operationsPanelLayout.setConstraints((Component)newOperationButton, this.argumentsConstraints);
        if (this.connector.getOperations().size() < 4) {
            newOperationPanel.setVisible(true);
        }
        operationsPanel.add((Component)newOperationButton, new GridConstraints(0, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        operationsPanel.add((Component)newOperationPanel, new GridConstraints(1, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        FSRTheme.decorateBackground(operationsPanel);
        return operationsPanel;
    }

    public boolean checkExistingOperation(JTextField nameTextField, JTextField titleTextField) {
        String operationName = nameTextField.getText();
        String operationLabel = titleTextField.getText();
        for (int i = 0; i < this.connector.getOperations().size(); ++i) {
            if (this.connector.getOperations().get(i).getTitle().toUpperCase().equals(operationLabel.toUpperCase())) {
                titleTextField.setBorder(BorderFactory.createLineBorder(Color.red));
                if (this.connector.getOperations().get(i).getOperation().toUpperCase().equals(operationName.toUpperCase()) || this.connector.getOperations().get(i).getAnnotation().toUpperCase().equals(operationName.toUpperCase())) {
                    nameTextField.setBorder(BorderFactory.createLineBorder(Color.red));
                    CommonUtils.showErrorMessage(String.format(this.popMessage.getProperty("duplicateOperationTitleAndName"), operationLabel, operationName));
                    return false;
                }
                CommonUtils.showErrorMessage(String.format(this.popMessage.getProperty("duplicateOperationTitle"), operationLabel));
                return false;
            }
            if (!this.connector.getOperations().get(i).getOperation().toUpperCase().equals(operationName.toUpperCase()) && !this.connector.getOperations().get(i).getAnnotation().toUpperCase().equals(operationName.toUpperCase())) continue;
            nameTextField.setBorder(BorderFactory.createLineBorder(Color.red));
            CommonUtils.showErrorMessage(String.format(this.popMessage.getProperty("duplicateOperationName"), operationName));
            return false;
        }
        return true;
    }

    public void deleteOperation(Operation operationObj) {
        this.connector.deleteOperation(operationObj);
        IOUtils.reloadFromDisk(this.project);
        this.repaintOperations(true);
        CommonUtils.showInfoMessage(String.format(Constants.POP_MESSAGE.getProperty("operationDeletedSuccess"), operationObj.getTitle()));
    }

    public void repaintOperations(boolean focus) {
        int operationsPanelIndex = 0;
        this.remove(operationsPanelIndex);
        JPanel operationsPanel = this.createOperationsScroll();
        this.insertTab(String.format(Constants.UI_TEXT.getProperty("allOperationsTab"), this.connector.getOperationsList().length), null, operationsPanel, "Operations panel", operationsPanelIndex);
        if (focus) {
            this.setSelectedIndex(operationsPanelIndex);
        }
    }

    public void newOperationAction(String operationName, String operationLabel, String operationDescription, String operationEndpoint, String operationMethod, boolean generateDefaultCode) {
        if (operationName != null) {
            if (CommonUtils.checkValidOperationName(operationName).booleanValue()) {
                try {
                    this.connector.addNewOperation(operationName, operationLabel, operationDescription);
                    if (generateDefaultCode) {
                        ConnectorUtils.createNewOperationFile(this.project, this.connector, operationName, operationLabel, operationDescription, operationEndpoint, operationMethod);
                        Path operationFile = Paths.get(Paths.get(this.connector.getInfoFilePath(), new String[0]).getParent().toString(), "operations.py");
                        ConnectorUtils.generateOperationPyFile(operationFile.toString(), this.connector.getOperationsList());
                    }
                }
                catch (Exception ex) {
                    CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("errorWhileCreatingNewOperation"), ex.getMessage()));
                    logger.error("Create new operation failed.", (Throwable)ex);
                }
            } else {
                logger.debug(String.format("New operation name is not valid. Operation Name: %s", operationName));
                CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("invalidOperationName"));
            }
        }
    }
}

