/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.connector;

import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.model.Connector;
import com.fortinet.fortisoar.ui.CustomTabbedPane;
import com.fortinet.fortisoar.ui.connector.ConfigurationTabbedPane;
import com.fortinet.fortisoar.ui.connector.ConnectorDetailsPanel;
import com.fortinet.fortisoar.ui.connector.OperationsTabbedPane;
import com.fortinet.fortisoar.ui.operation.ArgumentsPanel;
import com.fortinet.fortisoar.utils.Constants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.messages.MessageBus;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;

public class ConnectorDialog {
    private static final Logger logger = Logger.getInstance(ConnectorDialog.class);
    public Project project;
    public CustomTabbedPane parent;
    private Connector connectorDetail;
    private Argument operationArgument;
    private MessageBus msgBus;
    private GridBagConstraints generalPanelCons = new GridBagConstraints();
    private ArrayList<ArgumentsPanel> argPanelList = new ArrayList();

    public ConnectorDialog(Connector connectorDetail, Project project, CustomTabbedPane parent) {
        this.connectorDetail = connectorDetail;
        this.project = project;
        JBScrollPane finalDetailsPanel = this.createConnectorDetailsScroll();
        ConfigurationTabbedPane finalArgsTab = new ConfigurationTabbedPane(project, connectorDetail, parent);
        OperationsTabbedPane finalOperationsTab = new OperationsTabbedPane(project, connectorDetail, this);
        parent.addTab(Constants.UI_TEXT.getProperty("detailsTab"), IconLoader.getIcon((String)"/icons/details.png", this.getClass()), (Component)finalDetailsPanel);
        parent.addTab(Constants.UI_TEXT.getProperty("configurationTab"), IconLoader.getIcon((String)"/icons/configuration.png", this.getClass()), finalArgsTab);
        parent.addTab(Constants.UI_TEXT.getProperty("operationsTab"), IconLoader.getIcon((String)"/icons/operations.png", this.getClass()), finalOperationsTab);
    }

    private JBScrollPane createConnectorDetailsScroll() {
        ConnectorDetailsPanel operationDetailsPanel = new ConnectorDetailsPanel(this.connectorDetail, this.project);
        return new JBScrollPane((Component)operationDetailsPanel, 20, 30);
    }
}

