/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.connector;

import com.fortinet.fortisoar.init.PropReader;
import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.model.Connector;
import com.fortinet.fortisoar.ui.CommonUIFields;
import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.operation.ArgumentsPanel;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.EncryptionDecryption;
import com.fortinet.fortisoar.utils.JsonUtils;
import com.fortinet.fortisoar.utils.OnChangeUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXButton;

public class CheckHealthPanel
extends JPanel {
    public static final Logger logger = Logger.getInstance(CheckHealthPanel.class);
    private final Connector connector;
    private final Project project;
    public HashMap<String, Object> allInputFields = new HashMap();
    private JPanel inputFieldPanel;
    private JBScrollPane inputFieldScrollPane;
    private JPanel buttonPanel;
    private JsonObject allConfigData;
    private JsonObject localData;
    private String localDataFilePath;
    private ComboBox selectConfigField;
    private String[] allConfigOptions;
    private JPanel configPanel;
    private JPanel executePanel;
    private JPanel noConfigPanel;
    private JTextField addNewConfigField;
    private JPanel addNewConfigPanel;
    private JXButton newConfigButton;
    private String selectedConfigName = null;
    private JsonObject selectedConfigData = new JsonObject();
    private Map<String, String> fieldTypeSelectKeys = new HashMap<String, String>();
    private Set<String> fieldTypePasswordKeys;
    private int argumentPos;
    private List<Map<String, Object>> onChangeLabels;
    private List<Map<String, Object>> onChangeInputFields;
    public Set<String> requiredFields;

    public CheckHealthPanel(Project project, Connector connector) {
        assert (project != null);
        this.project = project;
        this.connector = connector;
        this.setLayout((LayoutManager)new GridLayoutManager(20, 1, (Insets)JBUI.insets((int)5, (int)5), -1, -1));
        this.readLocalData();
        this.createConfigurationExecutePanel();
        FSRTheme.decorateBackground(this);
    }

    private void createConfigurationExecutePanel() {
        logger.info("FortiSAOR Under createConfigurationExecutePanel");
        logger.info("ConnectorUtils.isConfigurationArgumentExists(connector.getInfoContentObj()): " + ConnectorUtils.isConfigurationArgumentExists(this.connector.getInfoContentObj()));
        if (!ConnectorUtils.isConfigurationArgumentExists(this.connector.getInfoContentObj()).booleanValue()) {
            this.createNoConfigPanel();
            this.add((Component)this.noConfigPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, new Dimension(400, 100)));
            return;
        }
        this.createConfigPanel();
        this.add((Component)this.executePanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, new Dimension(500, 10000)));
        this.add((Component)this.buttonPanel, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, new Dimension(500, 10000)));
    }

    private void createNoConfigPanel() {
        this.noConfigPanel = new JPanel();
        this.noConfigPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.noConfigPanel);
        String noConfigurationMessage = Constants.UI_TEXT.getProperty("noConfigurationExistsMessage");
        JTextArea noConfigurationField = CommonUIFields.createMessageField(noConfigurationMessage);
        this.noConfigPanel.add((Component)noConfigurationField, new GridConstraints(0, 0, 1, 1, 0, 1, 2, 0, null, null, null));
        if (this.buttonPanel != null) {
            this.buttonPanel.setVisible(false);
        }
        if (this.executePanel != null) {
            this.executePanel.setVisible(false);
        }
    }

    private void createConfigPanel() {
        this.executePanel = new JPanel();
        this.executePanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.executePanel);
        this.createExecutePanel();
        this.createButtonPanel();
        if (this.noConfigPanel != null) {
            this.noConfigPanel.setVisible(false);
        }
    }

    private void createExecutePanel() {
        this.createAddNewConfigButton();
        this.createAddNewConfigPanel();
        this.createSelectConfigPanel();
        this.createInputFieldScrollPane();
        this.executePanel.add((Component)this.newConfigButton, new GridConstraints(0, 0, 1, 1, 4, 0, 3, 3, null, null, null));
        this.executePanel.add((Component)this.configPanel, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.executePanel.add((Component)this.addNewConfigPanel, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.executePanel.add((Component)this.inputFieldScrollPane, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        if (this.allConfigOptions.length == 0) {
            this.addNewConfigPanel.setVisible(true);
            this.configPanel.setVisible(false);
            this.newConfigButton.setText(Constants.UI_TEXT.getProperty("allConfig"));
            this.newConfigButton.setIcon(null);
            this.selectedConfigName = "";
            this.selectedConfigData = new JsonObject();
        }
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.buttonPanel);
        JXButton reloadButton = FSRTheme.createFSRButton("resetConfigButton", "/icons/refresh.png", "configResetButtonTooltip", this.getClass());
        reloadButton.addActionListener(e -> this.reloadFields());
        JXButton saveButton = FSRTheme.createFSRSaveButton("saveConfigButton", "/icons/save.png", this.getClass());
        saveButton.addActionListener(e -> this.saveConfigFields(true));
        JPanel emptyPanel1 = new JPanel();
        JPanel emptyPanel2 = new JPanel();
        FSRTheme.decorateBackground(emptyPanel1);
        FSRTheme.decorateBackground(emptyPanel2);
        this.buttonPanel.add((Component)saveButton, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, null, null));
        this.buttonPanel.add((Component)reloadButton, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.buttonPanel.add((Component)emptyPanel2, new GridConstraints(0, 1, 1, 1, 1, 3, 3, 3, null, null, null));
        this.buttonPanel.add((Component)emptyPanel1, new GridConstraints(0, 0, 1, 1, 1, 3, 3, 3, null, null, null));
    }

    private void createInputFieldScrollPane() {
        this.createInputFieldPanel();
        this.inputFieldScrollPane = new JBScrollPane((Component)this.inputFieldPanel, 20, 30);
        FSRTheme.setEmptyBorder((JComponent)this.inputFieldScrollPane);
    }

    private void createInputFieldPanel() {
        ArrayList<Argument> parameters = this.connector.getConfiguration_fields();
        this.inputFieldPanel = new JPanel();
        Border titledBorder = FSRTheme.createFSRTitleBorder("configInputFieldsBorder");
        this.inputFieldPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        FSRTheme.decorateBackground(this.inputFieldPanel);
        this.inputFieldPanel.setLayout((LayoutManager)new GridLayoutManager(parameters.size() + 1, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        this.argumentPos = 1;
        this.onChangeLabels = new ArrayList<Map<String, Object>>();
        this.onChangeInputFields = new ArrayList<Map<String, Object>>();
        this.requiredFields = new HashSet<String>();
        for (int i = 0; i < parameters.size(); ++i) {
            this.addInputField(parameters.get(i));
        }
    }

    private void createSelectConfigPanel() {
        this.configPanel = new JPanel();
        Border titledBorder = FSRTheme.createFSRTitleBorder("selectConfigBorder");
        this.configPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.configPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.configPanel);
        this.selectConfigField = CommonUIFields.createDropDownField("config", this.allConfigOptions, "", "Select a configuration", true);
        FSRTheme.decorateInputField((JComponent)this.selectConfigField);
        this.selectConfigField.addActionListener(e -> {
            this.selectedConfigName = (String)this.selectConfigField.getSelectedItem();
            this.selectedConfigData = this.allConfigData.get(this.selectedConfigName).getAsJsonObject();
            this.reloadFields();
        });
        this.configPanel.add((Component)this.selectConfigField, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createAddNewConfigButton() {
        this.newConfigButton = FSRTheme.createFSRButton("addNewConfig", "/icons/add.png", "", this.getClass());
        this.newConfigButton.addActionListener(e -> {
            if (this.addNewConfigPanel.isVisible()) {
                this.addNewConfigPanel.setVisible(false);
                this.configPanel.setVisible(true);
                this.newConfigButton.setText(Constants.UI_TEXT.getProperty("addNewConfig"));
                this.newConfigButton.setIcon(IconLoader.getIcon((String)"/icons/add.png", this.getClass()));
                this.selectedConfigName = (String)this.selectConfigField.getSelectedItem();
                if (this.allConfigData.has(this.selectedConfigName)) {
                    this.selectedConfigData = this.allConfigData.get(this.selectedConfigName).getAsJsonObject();
                }
            } else {
                this.addNewConfigPanel.setVisible(true);
                this.configPanel.setVisible(false);
                this.newConfigButton.setText(Constants.UI_TEXT.getProperty("allConfig"));
                this.newConfigButton.setIcon(null);
                this.selectedConfigName = "";
                this.selectedConfigData = new JsonObject();
            }
            if (this.executePanel != null) {
                this.reloadFields();
            }
        });
    }

    private void createAddNewConfigPanel() {
        this.addNewConfigPanel = new JPanel();
        Border titledBorder = FSRTheme.createFSRTitleBorder("addNewConfigBorder");
        this.addNewConfigPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.addNewConfigPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.addNewConfigPanel);
        JLabel addNewConfigLabel = new JLabel(Constants.UI_TEXT.getProperty("addNewConfigName"));
        this.addNewConfigField = CommonUIFields.createTextField(Constants.UI_TEXT.getProperty("addNewConfigBorder"), "", "Specify new config name.", true);
        FSRTheme.decorateInputField(this.addNewConfigField);
        this.addNewConfigField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                CheckHealthPanel.this.selectedConfigName = CheckHealthPanel.this.addNewConfigField.getText();
            }
        });
        this.addNewConfigPanel.add((Component)addNewConfigLabel, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.addNewConfigPanel.add((Component)this.addNewConfigField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.addNewConfigPanel.setVisible(false);
    }

    private void addInputField(Argument arg) {
        if (arg.getRequired().booleanValue() && !arg.getIsOnChange().booleanValue()) {
            this.requiredFields.add(arg.getName());
        }
        if (!arg.getIsOnChange().booleanValue()) {
            JLabel label = CommonUIFields.createLabel(arg.getName(), arg.getType(), arg.getTooltip(), arg.getRequired());
            Component inputField = this.createArgumentField(label, arg);
            this.allInputFields.put(arg.getName(), inputField);
        }
    }

    public Component createArgumentField(JLabel label, Argument arg) {
        Component inputField;
        JsonArray multiSelectValue = new JsonArray();
        String argType = arg.getType();
        String argName = arg.getName();
        String argValue = arg.getValue();
        String argTooltip = arg.getTooltip();
        boolean argRequired = arg.getRequired();
        if (this.selectedConfigData.has(argName)) {
            this.fieldTypePasswordKeys = ConnectorUtils.getConfigurationPasswordParameter(this.connector.getInfoFilePath());
            if (this.fieldTypePasswordKeys.contains(argName)) {
                argValue = EncryptionDecryption.decryptData(this.selectedConfigData.get(argName).getAsString());
            } else if (!argType.equals("Multiselect")) {
                argValue = this.selectedConfigData.get(argName).getAsString();
            } else if (this.selectedConfigData.get(arg.getName()) instanceof JsonArray) {
                multiSelectValue = this.selectedConfigData.get(argName).getAsJsonArray();
            } else {
                multiSelectValue.add((JsonElement)this.selectedConfigData.get(arg.getName()).getAsJsonPrimitive());
            }
        }
        if (argType.equals("Text") || argType.equals("Integer") || argType.equals("Datetime")) {
            inputField = CommonUIFields.createTextField(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField(inputField);
        } else if (argType.equals("Password")) {
            inputField = CommonUIFields.createPasswordField(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JPasswordField)inputField);
        } else if (argType.equals("Textarea") || argType.equals("Json")) {
            inputField = CommonUIFields.createTextArea(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JTextArea)inputField);
        } else if (argType.equals("Select")) {
            inputField = this.createSelectInputField(arg);
            FSRTheme.decorateInputField((JComponent)((ComboBox)inputField));
        } else if (argType.equals("Multiselect")) {
            String[] onChangeArgOptions = ConnectorUtils.createDropDownValue(arg);
            this.fieldTypeSelectKeys.put(argName, "multiselect");
            inputField = CommonUIFields.createMultiSelectDropDownField(argName, onChangeArgOptions, multiSelectValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JComponent)((JBList)inputField));
        } else if (argType.equals("Checkbox")) {
            inputField = this.createCheckBoxInputField(arg);
            FSRTheme.decorateInputField((JCheckBox)inputField);
        } else if (argType.equals(PropReader.UIText.getProperty("argsTypeOperation"))) {
            inputField = CommonUIFields.createDropDownField(argName, this.connector.getOperationsList(), argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JComponent)((ComboBox)inputField));
        } else {
            inputField = CommonUIFields.createTextField(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField(inputField);
        }
        this.inputFieldPanel.add((Component)label, new GridConstraints(this.argumentPos, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.inputFieldPanel.add(inputField, new GridConstraints(this.argumentPos, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        ++this.argumentPos;
        return inputField;
    }

    private Component createCheckBoxInputField(Argument arg) {
        boolean isSelected = false;
        if (this.selectedConfigData.has(arg.getName())) {
            isSelected = this.selectedConfigData.get(arg.getName()).getAsBoolean();
        }
        boolean value = arg.getValue().equals("true");
        JCheckBox checkBoxInputField = CommonUIFields.createCheckBoxField(arg.getName(), value, arg.getTooltip());
        checkBoxInputField.setSelected(isSelected);
        this.allInputFields.put(arg.getName(), checkBoxInputField);
        if (arg.getOnchange() != null) {
            checkBoxInputField.addActionListener(e -> {
                Boolean checkBoxInputFieldSelected = checkBoxInputField.isSelected();
                JsonObject jsonObject = ConnectorUtils.convertArgumentToJson(arg).getAsJsonObject();
                JsonObject onChangeJsonObject = jsonObject.get("onchange").getAsJsonObject();
                OnChangeUtils.markOnChangeParamVisible(this.onChangeLabels, onChangeJsonObject, checkBoxInputFieldSelected, this.selectedConfigData);
                OnChangeUtils.markOnChangeParamVisible(this.onChangeInputFields, onChangeJsonObject, checkBoxInputFieldSelected, this.selectedConfigData);
            });
            for (Map.Entry entry : arg.getOnchange().getAsJsonObject().entrySet()) {
                for (JsonElement jsonElement : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    Argument onChangeArg = ConnectorUtils.convertJsonToArgument(jsonElement);
                    JLabel onChangeLabel = CommonUIFields.createLabel(onChangeArg.getName(), onChangeArg.getType(), onChangeArg.getTooltip(), onChangeArg.getRequired());
                    Component onChangeInputField = this.createArgumentField(onChangeLabel, onChangeArg);
                    HashMap<String, Object> argumentLabel = new HashMap<String, Object>();
                    argumentLabel.put("onChangeArgumentName", onChangeArg.getName());
                    argumentLabel.put("onChangeOption", onChangeArg.getOnChangeOption());
                    argumentLabel.put("onChangeLabel", onChangeLabel);
                    this.onChangeLabels.add(argumentLabel);
                    HashMap<String, Object> argumentTextField = new HashMap<String, Object>();
                    argumentTextField.put("onChangeArgumentName", onChangeArg.getName());
                    argumentTextField.put("onChangeOption", onChangeArg.getOnChangeOption());
                    argumentTextField.put("onChangeComponent", onChangeInputField);
                    this.onChangeInputFields.add(argumentTextField);
                    onChangeLabel.setVisible(false);
                    onChangeInputField.setVisible(false);
                    if (!checkBoxInputField.isSelected()) continue;
                    onChangeLabel.setVisible(true);
                    onChangeInputField.setVisible(true);
                }
            }
        }
        return checkBoxInputField;
    }

    private Component createSelectInputField(Argument arg) {
        String selectArgValue = arg.getValue();
        if (this.selectedConfigData.has(arg.getName())) {
            selectArgValue = this.selectedConfigData.get(arg.getName()) instanceof JsonPrimitive ? this.selectedConfigData.get(arg.getName()).getAsJsonPrimitive().getAsString() : (this.selectedConfigData.get(arg.getName()) instanceof JsonArray ? this.selectedConfigData.get(arg.getName()).getAsJsonArray().get(0).getAsString() : this.selectedConfigData.get(arg.getName()).getAsString());
        }
        String[] argOptions = ConnectorUtils.createDropDownValue(arg);
        this.fieldTypeSelectKeys.put(arg.getName(), "select");
        ComboBox selectInputField = CommonUIFields.createDropDownField(arg.getName(), argOptions, selectArgValue, arg.getTooltip(), arg.getRequired());
        FSRTheme.decorateInputField((JComponent)selectInputField);
        this.allInputFields.put(arg.getName(), selectInputField);
        if (arg.getOnchange() != null) {
            selectInputField.addActionListener(e -> {
                String selectedOperation = (String)selectInputField.getSelectedItem();
                JsonObject jsonObject = ConnectorUtils.convertArgumentToJson(arg).getAsJsonObject();
                JsonObject onChangeJsonObject = jsonObject.get("onchange").getAsJsonObject();
                OnChangeUtils.markOnChangeParamVisible(this.onChangeLabels, onChangeJsonObject, selectedOperation, this.selectedConfigData);
                OnChangeUtils.markOnChangeParamVisible(this.onChangeInputFields, onChangeJsonObject, selectedOperation, this.selectedConfigData);
            });
            for (Map.Entry entry : arg.getOnchange().getAsJsonObject().entrySet()) {
                for (JsonElement jsonElement : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    Argument onChangeArg = ConnectorUtils.convertJsonToArgument(jsonElement);
                    JLabel onChangeLabel = CommonUIFields.createLabel(onChangeArg.getName(), onChangeArg.getType(), onChangeArg.getTooltip(), onChangeArg.getRequired());
                    Component onChangeInputField = this.createArgumentField(onChangeLabel, onChangeArg);
                    HashMap<String, Object> argumentLabel = new HashMap<String, Object>();
                    argumentLabel.put("onChangeArgumentName", onChangeArg.getName());
                    argumentLabel.put("onChangeOption", onChangeArg.getOnChangeOption());
                    argumentLabel.put("onChangeLabel", onChangeLabel);
                    this.onChangeLabels.add(argumentLabel);
                    HashMap<String, Object> argumentTextField = new HashMap<String, Object>();
                    argumentTextField.put("onChangeArgumentName", onChangeArg.getName());
                    argumentTextField.put("onChangeOption", onChangeArg.getOnChangeOption());
                    argumentTextField.put("onChangeComponent", onChangeInputField);
                    this.onChangeInputFields.add(argumentTextField);
                    onChangeLabel.setVisible(false);
                    onChangeInputField.setVisible(false);
                    if (!selectInputField.getSelectedItem().equals(onChangeArg.getOnChangeOption())) continue;
                    onChangeLabel.setVisible(true);
                    onChangeInputField.setVisible(true);
                }
            }
        }
        return selectInputField;
    }

    private boolean validateRequiredFields() {
        boolean flag = true;
        if (this.addNewConfigPanel.isVisible()) {
            flag = ConnectorUtils.validateRequiredField(this.addNewConfigField, ArgumentsPanel.defaultBorderColor);
        }
        for (String key : this.requiredFields) {
            Component obj = (Component)this.allInputFields.get(key);
            if (obj instanceof JTextField) {
                flag = ConnectorUtils.validateRequiredField((JTextField)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue;
            }
            if (obj instanceof JTextArea) {
                flag = ConnectorUtils.validateRequiredField((JTextArea)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue;
            }
            if (obj instanceof ComboBox) {
                flag = ConnectorUtils.validateRequiredField((ComboBox)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue;
            }
            if (!(obj instanceof JBList)) continue;
            flag = ConnectorUtils.validateRequiredField((JBList)obj, ArgumentsPanel.defaultBorderColor) && flag;
        }
        block1: for (int i = 0; i < this.onChangeInputFields.size(); ++i) {
            Map<String, Object> onChangeObject = this.onChangeInputFields.get(i);
            for (Argument arg : this.connector.getConfiguration_fields()) {
                if (!arg.getIsOnChange().booleanValue() || !arg.getRequired().booleanValue() || !arg.getOnChangeOption().equals(onChangeObject.get("onChangeOption")) || !arg.getName().equals(onChangeObject.get("onChangeArgumentName"))) continue;
                Component obj = (Component)onChangeObject.get("onChangeComponent");
                if (obj instanceof JTextField) {
                    if (!obj.isVisible()) continue block1;
                    flag = ConnectorUtils.validateRequiredField((JTextField)obj, ArgumentsPanel.defaultBorderColor) && flag;
                    continue block1;
                }
                if (obj instanceof JTextArea) {
                    if (!obj.isVisible()) continue block1;
                    flag = ConnectorUtils.validateRequiredField((JTextArea)obj, ArgumentsPanel.defaultBorderColor) && flag;
                    continue block1;
                }
                if (obj instanceof ComboBox) {
                    if (!obj.isVisible()) continue block1;
                    flag = ConnectorUtils.validateRequiredField((ComboBox)obj, ArgumentsPanel.defaultBorderColor) && flag;
                    continue block1;
                }
                if (!(obj instanceof JBList) || !obj.isVisible()) continue block1;
                flag = ConnectorUtils.validateRequiredField((JBList)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue block1;
            }
        }
        return flag;
    }

    private void updateConfigFields() {
        this.allInputFields.forEach((key, obj) -> {
            if (obj instanceof JTextField) {
                this.selectedConfigData.addProperty(key, ((JTextField)obj).getText());
            } else if (obj instanceof JTextArea) {
                this.selectedConfigData.addProperty(key, ((JTextArea)obj).getText());
            } else if (obj instanceof ComboBox) {
                this.selectedConfigData.addProperty(key, ((ComboBox)obj).getSelectedItem().toString());
            } else if (obj instanceof JCheckBox) {
                JCheckBox abstractButton = (JCheckBox)obj;
                boolean selected = abstractButton.getModel().isSelected();
                this.selectedConfigData.addProperty(key, Boolean.valueOf(selected));
            } else if (obj instanceof JBList) {
                JsonArray jsonArray = new JsonArray();
                for (Object option : ((JBList)obj).getSelectedValuesList()) {
                    jsonArray.add((String)option);
                }
                this.selectedConfigData.add(key, (JsonElement)jsonArray);
            }
        });
        for (int i = 0; i < this.onChangeInputFields.size(); ++i) {
            Map<String, Object> onChangeObject = this.onChangeInputFields.get(i);
            Object obj2 = onChangeObject.get("onChangeComponent");
            if (obj2 instanceof JTextField) {
                if (!((JTextField)obj2).isVisible()) continue;
                this.selectedConfigData.addProperty((String)onChangeObject.get("onChangeArgumentName"), ((JTextField)obj2).getText());
                continue;
            }
            if (obj2 instanceof JTextArea) {
                if (!((JTextArea)obj2).isVisible()) continue;
                this.selectedConfigData.addProperty((String)onChangeObject.get("onChangeArgumentName"), ((JTextArea)obj2).getText());
                continue;
            }
            if (obj2 instanceof ComboBox) {
                if (!((ComboBox)obj2).isVisible()) continue;
                this.selectedConfigData.addProperty((String)onChangeObject.get("onChangeArgumentName"), ((ComboBox)obj2).getSelectedItem().toString());
                continue;
            }
            if (obj2 instanceof JCheckBox) {
                if (!((JCheckBox)obj2).isVisible()) continue;
                JCheckBox abstractButton = (JCheckBox)obj2;
                boolean selected = abstractButton.getModel().isSelected();
                this.selectedConfigData.addProperty((String)onChangeObject.get("onChangeArgumentName"), Boolean.valueOf(selected));
                continue;
            }
            if (!(obj2 instanceof JBList) || !((JBList)obj2).isVisible()) continue;
            JsonArray jsonArray = new JsonArray();
            for (Object option : ((JBList)obj2).getSelectedValuesList()) {
                jsonArray.add((String)option);
            }
            this.selectedConfigData.add((String)onChangeObject.get("onChangeArgumentName"), (JsonElement)jsonArray);
        }
        String config_id_field_name = "config_id";
        if (this.selectedConfigData.has(config_id_field_name)) {
            logger.info("Configuration Id already present");
        } else {
            UUID uuid = UUID.randomUUID();
            this.selectedConfigData.addProperty(config_id_field_name, uuid.toString());
        }
    }

    private boolean saveConfigFields(boolean showPopup) {
        if (this.validateRequiredFields() && CommonUtils.isValidPythonPath(ConnectorUtils.getPythonPath(this.project))) {
            try {
                this.updateConfigFields();
                ConnectorUtils.setDropDownValueAsEmpty(this.fieldTypeSelectKeys, this.selectedConfigData);
                this.allConfigData.add(this.selectedConfigName, (JsonElement)this.selectedConfigData);
                this.writeLocalData();
                if (this.addNewConfigPanel.isVisible()) {
                    String currConfigName = this.selectedConfigName;
                    this.reloadExecutePanel();
                    this.selectConfigField.setSelectedItem((Object)currConfigName);
                }
                this.createConfigConfiguration();
                if (showPopup) {
                    CommonUtils.showInfoMessage(String.format(PropReader.popMessage.getProperty("saveConfigurationMessage"), "Check Health"));
                }
                return true;
            }
            catch (Exception ex) {
                logger.error("Save configurations fields value failed.", (Throwable)ex);
                if (showPopup) {
                    CommonUtils.showErrorMessage(PropReader.popMessage.getProperty("saveFailedMessage"));
                }
                return false;
            }
        }
        return false;
    }

    private void createConfigConfiguration() {
        String config_name = (String)this.selectConfigField.getSelectedItem();
        this.fieldTypePasswordKeys = ConnectorUtils.getConfigurationPasswordParameter(this.connector.getInfoFilePath());
        HashMap<String, String> configParams = new HashMap<String, String>();
        configParams.put("config", config_name);
        ConnectorUtils.createConfiguration(this.project, this.connector.getInfoFilePath(), "check_health", this.fieldTypePasswordKeys, configParams, true);
    }

    private void reloadFields() {
        this.executePanel.remove((Component)this.inputFieldScrollPane);
        this.createInputFieldScrollPane();
        this.executePanel.add((Component)this.inputFieldScrollPane, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.executePanel.revalidate();
        this.executePanel.repaint();
    }

    private void reloadConfigPanel() {
        this.executePanel.remove(this.configPanel);
        this.createSelectConfigPanel();
        this.executePanel.add((Component)this.configPanel, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.executePanel.revalidate();
        this.executePanel.repaint();
        this.reloadFields();
    }

    public void reloadExecutePanel() {
        this.readLocalData();
        if (this.executePanel != null) {
            this.remove(this.executePanel);
        }
        this.createConfigurationExecutePanel();
        this.add((Component)this.executePanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.revalidate();
        this.repaint();
    }

    private void readLocalData() {
        JsonObject connLocalData;
        this.localDataFilePath = Paths.get(this.project.getBasePath(), "/.fortisoar/local_data.json").toString();
        JsonUtils.createLocalDataFileIfNotFound(this.localDataFilePath);
        this.localData = JsonUtils.readJsonFile(this.localDataFilePath);
        if (!this.localData.has(this.connector.getName())) {
            this.localData.add(this.connector.getName(), (JsonElement)new JsonObject());
        }
        if (!(connLocalData = this.localData.get(this.connector.getName()).getAsJsonObject()).has("config")) {
            connLocalData.add("config", (JsonElement)new JsonObject());
        }
        this.allConfigData = connLocalData.get("config").getAsJsonObject();
        this.allConfigOptions = this.allConfigData.keySet().toArray(new String[0]);
        if (this.allConfigOptions.length > 0) {
            this.selectedConfigName = this.allConfigOptions[0];
            this.selectedConfigData = this.allConfigData.get(this.selectedConfigName).getAsJsonObject();
        }
    }

    private void writeLocalData() {
        JsonObject prevLocalData = JsonUtils.readJsonFile(this.localDataFilePath);
        this.fieldTypePasswordKeys = ConnectorUtils.getConfigurationPasswordParameter(this.connector.getInfoFilePath());
        this.localData = EncryptionDecryption.encryptJsonData(this.fieldTypePasswordKeys, this.localData, this.connector.getName(), "config", this.selectedConfigName);
        this.localData = JsonUtils.updateLocalDataJsonObject(prevLocalData, this.localData);
        JsonUtils.writeInfoJsonFile(this.localDataFilePath, this.localData);
    }
}

