/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui;

import com.fortinet.fortisoar.utils.Constants;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.IconLoader;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;

public class FSRTheme {
    public static void decorateBackground(JComponent panel) {
        panel.setBackground(Color.decode("#0B1218"));
    }

    public static void decorateInputField(JComponent textField) {
        textField.setBackground(Color.decode("#1D232F"));
        textField.setBorder(new LineBorder(Color.decode("#1D232F")));
    }

    public static void decorateTitleBorder(TitledBorder titledBorder) {
        titledBorder.setTitleColor(Color.decode("#169CAD"));
    }

    public static void decorateLabel(JLabel label) {
        label.setForeground(Color.decode("#169CAD"));
    }

    public static JXButton createFSRButton(String buttonName, String buttonIcon, String toolTip, Class panelClass) {
        JXButton button = buttonIcon.isEmpty() ? new JXButton(Constants.UI_TEXT.getProperty(buttonName)) : new JXButton(Constants.UI_TEXT.getProperty(buttonName), IconLoader.getIcon((String)buttonIcon, (Class)panelClass));
        button.setName("button");
        button.setIconTextGap(6);
        button.setForeground(Color.decode("#FFFFFF"));
        button.setToolTipText(Constants.TOOLTIP.getProperty(toolTip, ""));
        button.setBackgroundPainter((Painter)new MattePainter((Paint)Color.decode("#323B47")));
        button.setBorderPainted(false);
        return button;
    }

    public static JXButton createFSRSaveButton(String buttonName, String buttonIcon, Class panelClass) {
        JXButton button = new JXButton(Constants.UI_TEXT.getProperty(buttonName), IconLoader.getIcon((String)buttonIcon, (Class)panelClass));
        button.setName("button");
        button.setIconTextGap(6);
        button.setForeground(Color.decode("#FFFFFF"));
        button.setBackgroundPainter((Painter)new MattePainter((Paint)Color.decode("#169CAD")));
        button.setBorderPainted(false);
        return button;
    }

    public static JXButton createFSRTealButton(String buttonName, String buttonIcon, Class panelClass) {
        JXButton button = new JXButton(Constants.UI_TEXT.getProperty(buttonName), IconLoader.getIcon((String)buttonIcon, (Class)panelClass));
        button.setName("button");
        button.setIconTextGap(6);
        button.setForeground(Color.decode("#FFFFFF"));
        button.setBackgroundPainter((Painter)new MattePainter((Paint)Color.decode("#323B47")));
        button.setBorderPainted(false);
        return button;
    }

    public static Border createFSRTitleBorder(String borderName) {
        LineBorder border = new LineBorder(Color.decode("#2C3E5D"), 1);
        TitledBorder titleBorder = new TitledBorder(border, Constants.UI_TEXT.getProperty(borderName));
        titleBorder.setTitleFont(titleBorder.getTitleFont().deriveFont(14.0f));
        FSRTheme.decorateTitleBorder(titleBorder);
        return titleBorder;
    }

    public static JTextField createFSRTextField(String fieldValue) {
        JTextField textField = new JTextField(fieldValue);
        textField.setName("textField");
        textField.setBorder(BorderFactory.createCompoundBorder(new LineBorder(Color.decode("#1D232F")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        textField.setBackground(Color.decode("#1D232F"));
        return textField;
    }

    public static JTextArea createFSRTextAreaField(String fieldValue, int rows, int columns) {
        JTextArea labelTextField = rows == 0 && columns == 0 ? new JTextArea(fieldValue) : new JTextArea(fieldValue, rows, columns);
        labelTextField.setName("labelTextField");
        labelTextField.setBorder(BorderFactory.createCompoundBorder(new LineBorder(Color.decode("#1D232F")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        labelTextField.setBackground(Color.decode("#1D232F"));
        return labelTextField;
    }

    public static ComboBox createFSRComboBox(String[] fieldValue) {
        ComboBox comboBoxField = new ComboBox((Object[])fieldValue);
        comboBoxField.setName("comboBoxField");
        comboBoxField.setBorder((Border)BorderFactory.createCompoundBorder(new LineBorder(Color.decode("#1D232F")), BorderFactory.createEmptyBorder()));
        comboBoxField.setBackground(Color.decode("#1D232F"));
        return comboBoxField;
    }

    public static JCheckBox createFSRCheckBox(String checkBoxName, String checkBoxTooltip, Boolean checked) {
        JCheckBox csApprovedField = new JCheckBox(Constants.UI_TEXT.getProperty(checkBoxName), null, checked);
        csApprovedField.setName("csApprovedField");
        csApprovedField.setToolTipText(Constants.TOOLTIP.getProperty(checkBoxTooltip, ""));
        csApprovedField.setBackground(Color.decode("#0B1218"));
        return csApprovedField;
    }

    public static void setEmptyBorder(JComponent panel) {
        Border emptyBorder = BorderFactory.createEmptyBorder();
        panel.setBorder(emptyBorder);
    }
}

