/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui;

import com.fortinet.fortisoar.ui.operation.ArgumentsPanel;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBList;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CommonUIFields {
    public static Border GRAY_LINE_BORDER = LineBorder.createGrayLineBorder();

    public static JLabel createLabel(String name, String type, String tooltip, boolean isRequired) {
        name = String.format("%s(%s)", name, type);
        if (isRequired) {
            name = (String)name + "*";
        }
        JLabel label = new JLabel((String)name);
        label.setToolTipText(tooltip);
        return label;
    }

    public static JTextField createTextField(String name, String value, String tooltip, boolean isRequired) {
        final JTextField textField = new JTextField(value);
        textField.setToolTipText(tooltip);
        textField.setName(name);
        textField.setBorder(GRAY_LINE_BORDER);
        textField.setMinimumSize(new Dimension(100, 20));
        if (isRequired) {
            textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateLabel(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateLabel(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateLabel(e);
                }

                private void updateLabel(DocumentEvent e) {
                    ConnectorUtils.validateRequiredField(textField, ArgumentsPanel.defaultBorderColor);
                }
            });
        }
        return textField;
    }

    public static JPasswordField createPasswordField(String name, String value, String tooltip, boolean isRequired) {
        final JPasswordField textField = new JPasswordField(value);
        textField.setToolTipText(tooltip);
        textField.setName(name);
        textField.setBorder(GRAY_LINE_BORDER);
        textField.setMinimumSize(new Dimension(100, 20));
        if (isRequired) {
            textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateLabel(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateLabel(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateLabel(e);
                }

                private void updateLabel(DocumentEvent e) {
                    ConnectorUtils.validateRequiredField(textField, ArgumentsPanel.defaultBorderColor);
                }
            });
        }
        return textField;
    }

    public static JTextArea createTextArea(String name, String value, String tooltip, boolean isRequired) {
        final JTextArea textArea = new JTextArea(value);
        textArea.setToolTipText(tooltip);
        textArea.setName(name);
        textArea.setBorder(GRAY_LINE_BORDER);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setMinimumSize(new Dimension(100, 80));
        if (isRequired) {
            textArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateLabel(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateLabel(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateLabel(e);
                }

                private void updateLabel(DocumentEvent e) {
                    ConnectorUtils.validateRequiredField(textArea, ArgumentsPanel.defaultBorderColor);
                }
            });
        }
        return textArea;
    }

    public static ComboBox createDropDownField(String name, String[] options, String value, String tooltip, boolean isRequired) {
        ComboBox dropdownField = new ComboBox((Object[])options);
        dropdownField.setName(name);
        dropdownField.setBorder(LineBorder.createGrayLineBorder());
        dropdownField.setSelectedItem((Object)value);
        dropdownField.setToolTipText(tooltip);
        dropdownField.setMinimumSize(new Dimension(100, 20));
        return dropdownField;
    }

    public static JBList createMultiSelectDropDownField(String name, String[] options, JsonArray value, String tooltip, boolean isRequired) {
        JBList multiSelectField = new JBList((Object[])options);
        multiSelectField.setName(name);
        multiSelectField.setBorder(LineBorder.createGrayLineBorder());
        int[] indices = new int[value.size()];
        int count = 0;
        for (int i = 0; i < options.length; ++i) {
            for (JsonElement jsonElement : value) {
                if (!jsonElement.getAsString().equals(options[i])) continue;
                indices[count++] = i;
            }
        }
        multiSelectField.setSelectedIndices(indices);
        multiSelectField.setToolTipText(tooltip);
        multiSelectField.setMinimumSize(new Dimension(100, 20));
        return multiSelectField;
    }

    public static JCheckBox createCheckBoxField(String name, boolean value, String tooltip) {
        JCheckBox checkboxField = new JCheckBox("", null, value);
        checkboxField.setName("visibleField");
        checkboxField.setToolTipText(tooltip);
        return checkboxField;
    }

    public static JTextArea createMessageField(String text) {
        JTextArea messageField = new JTextArea(text);
        messageField.setName("messageField");
        messageField.setEditable(false);
        messageField.setOpaque(false);
        messageField.setFocusable(false);
        messageField.setLineWrap(true);
        messageField.setWrapStyleWord(true);
        return messageField;
    }
}

