/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.model;

import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

public class Operation {
    public String operation;
    public String title;
    public String annotation;
    public String description;
    public String category;
    public Boolean is_config_required;
    public Boolean visible;
    public Boolean enabled;
    public String output_schema;
    public String infoFilePath;
    private ArrayList<Argument> parameters;
    private JsonObject infoContentObj;

    public Operation(String name, String label, String description, String infoFilePath, JsonObject infoContentObj, Boolean newOperation) {
        this.infoFilePath = infoFilePath;
        this.infoContentObj = infoContentObj;
        this.setOperation(name);
        this.setTitle(label);
        this.setAnnotation(name);
        this.setDescription(description);
        this.setCategory("investigation");
        this.setEnabled(true);
        this.setVisible(true);
        this.setIs_config_required(true);
        this.setOutput_schema((JsonElement)new JsonObject());
        ArrayList<Argument> argumentsList = new ArrayList<Argument>();
        this.setParameters(argumentsList);
    }

    public Operation(String operationName, String infoFilePath, JsonObject infoContentObj) {
        this.infoFilePath = infoFilePath;
        this.infoContentObj = infoContentObj;
        JsonObject operationObj = this.findOperation(operationName);
        this.setName(operationObj.get("operation"));
        this.setTitle(operationObj.get("title"));
        this.setAnnotation(operationObj.get("annotation"));
        this.setDescription(operationObj.get("description"));
        this.setCategory(operationObj.get("category"));
        this.setEnabled(operationObj.get("enabled"));
        this.setVisible(operationObj.get("visible"));
        this.setIs_config_required(operationObj.get("is_config_required"));
        JsonElement outputObj = operationObj.get("output_schema");
        this.setOutput_schema(outputObj);
        JsonArray parameters = operationObj.getAsJsonArray("parameters");
        ArrayList<Argument> argumentsList = this.createArgumentsList(parameters);
        this.setParameters(argumentsList);
    }

    public ArrayList<Argument> createArgumentsList(JsonArray parametersObj) {
        ArrayList<Argument> argumentsList = new ArrayList<Argument>();
        for (int i = 0; i < parametersObj.size(); ++i) {
            JsonObject paramObj = parametersObj.get(i).getAsJsonObject();
            argumentsList.add(this.createParamObj(paramObj));
        }
        return argumentsList;
    }

    public Argument createParamObj(JsonObject paramObj) {
        Gson gson = new Gson();
        Argument arg = (Argument)gson.fromJson((JsonElement)paramObj, Argument.class);
        return arg;
    }

    public JsonObject findOperation(String operationName) {
        JsonArray operationsObj = this.infoContentObj.getAsJsonArray("operations");
        JsonObject operationObj = operationsObj.get(this.findIndexOfOperation(operationsObj, operationName)).getAsJsonObject();
        return operationObj;
    }

    public int findIndexOfOperation(JsonArray operationsObj, String operationName) {
        int index = 0;
        for (int i = 0; i < operationsObj.size(); ++i) {
            JsonObject curr_obj = (JsonObject)operationsObj.get(i);
            if (!curr_obj.get("operation").getAsString().equals(operationName)) continue;
            index = i;
            break;
        }
        return index;
    }

    public String getInfoFilePath() {
        return this.infoFilePath;
    }

    public void setInfoFilePath(String infoFilePath) {
        this.infoFilePath = infoFilePath;
    }

    public JsonObject getInfoContentObj() {
        return this.infoContentObj;
    }

    public void setInfoContentObj(JsonObject infoContentObj) {
        this.infoContentObj = infoContentObj;
    }

    public String getName() {
        return this.operation;
    }

    public void setName(String name) {
        this.operation = CommonUtils.stringIsNotEmptyOrNull(name) != false ? name : "";
    }

    public void setName(JsonElement name) {
        this.operation = name != null ? name.getAsString() : "";
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = CommonUtils.stringIsNotEmptyOrNull(operation) != false ? operation : "";
    }

    public void setOperation(JsonElement operation) {
        this.operation = operation != null ? operation.getAsString() : "";
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = CommonUtils.stringIsNotEmptyOrNull(title) != false ? title : "";
    }

    public void setTitle(JsonElement title) {
        this.title = title != null ? title.getAsString() : "";
    }

    public String getAnnotation() {
        return Objects.requireNonNullElse(this.annotation, "");
    }

    public void setAnnotation(String annotation) {
        this.annotation = CommonUtils.stringIsNotEmptyOrNull(annotation) != false ? annotation : this.getOperation();
    }

    public void setAnnotation(JsonElement annotation) {
        this.annotation = annotation != null ? annotation.getAsString() : this.getOperation();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = CommonUtils.stringIsNotEmptyOrNull(description) != false ? description : "";
    }

    public void setDescription(JsonElement description) {
        this.description = description != null ? description.getAsString() : "";
    }

    public String getCategory() {
        if (this.category == null) {
            return null;
        }
        return CommonUtils.revertLowerCamelCase(this.category);
    }

    public void setCategory(String category) {
        this.category = CommonUtils.stringIsNotEmptyOrNull(category) != false ? CommonUtils.convertLowerCamelCase(category) : "investigation";
    }

    public void setCategory(JsonElement category) {
        this.category = category != null ? category.getAsString() : "investigation";
    }

    public Boolean getIs_config_required() {
        return Objects.requireNonNullElse(this.is_config_required, true);
    }

    public void setIs_config_required(Boolean is_config_required) {
        this.is_config_required = CommonUtils.booleanIsNotEmptyOrNull(is_config_required) != false ? is_config_required : Boolean.valueOf(true);
    }

    public void setIs_config_required(JsonElement is_config_required) {
        this.is_config_required = is_config_required != null ? Boolean.valueOf(is_config_required.getAsBoolean()) : Boolean.valueOf(true);
    }

    public Boolean getVisible() {
        return Objects.requireNonNullElse(this.visible, true);
    }

    public void setVisible(Boolean visible) {
        this.visible = CommonUtils.booleanIsNotEmptyOrNull(visible) != false ? visible : Boolean.valueOf(true);
    }

    public void setVisible(JsonElement visible) {
        this.visible = visible != null ? Boolean.valueOf(visible.getAsBoolean()) : Boolean.valueOf(true);
    }

    public Boolean getEnabled() {
        return Objects.requireNonNullElse(this.enabled, true);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = CommonUtils.booleanIsNotEmptyOrNull(enabled) != false ? enabled : Boolean.valueOf(true);
    }

    public void setEnabled(JsonElement enabled) {
        this.enabled = enabled != null ? Boolean.valueOf(enabled.getAsBoolean()) : Boolean.valueOf(true);
    }

    public ArrayList<Argument> getParameters() {
        return this.parameters;
    }

    public void setParameters(ArrayList<Argument> parameters) {
        this.parameters = parameters;
    }

    public String getOutput_schema() {
        if (this.output_schema != null) {
            return this.output_schema;
        }
        return "";
    }

    public void setOutput_schema(String output_schema) {
        this.output_schema = CommonUtils.stringIsNotEmptyOrNull(output_schema) != false ? output_schema : "";
    }

    public void setOutput_schema(JsonElement output_schema) {
        if (output_schema != null) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                this.output_schema = gson.toJson((JsonElement)output_schema.getAsJsonObject());
            }
            catch (Exception ex) {
                try {
                    this.output_schema = gson.toJson((JsonElement)output_schema.getAsJsonArray());
                }
                catch (Exception ex1) {
                    try {
                        this.output_schema = gson.toJson((Object)output_schema.getAsString());
                    }
                    catch (Exception ex2) {
                        this.output_schema = String.valueOf(output_schema);
                    }
                }
            }
        } else {
            this.output_schema = "";
        }
    }

    public Argument addEmptyArg() {
        Argument arg = new Argument();
        this.parameters.add(arg);
        return arg;
    }

    public void save() throws Exception {
        try {
            if (!this.validateOperationsFields()) {
                throw new Exception("");
            }
            JsonArray operationsObj = this.infoContentObj.get("operations").getAsJsonArray();
            int operationIndex = this.findIndexOfOperation(operationsObj, this.operation);
            JsonObject prevOperationJsonObj = operationsObj.get(operationIndex).getAsJsonObject();
            JsonObject newOperationJsonObj = JsonUtils.createOperationJsonObject(this);
            if (newOperationJsonObj != null) {
                JsonUtils.updateOperationJsonObject(prevOperationJsonObj, newOperationJsonObj);
                JsonUtils.writeInfoJsonFile(this.infoFilePath, this.infoContentObj);
                CommonUtils.showInfoMessage(Constants.POP_MESSAGE.getProperty("saveSuccessMessage"));
            }
        }
        catch (Exception e) {
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("saveFailedMessage"));
            throw new Exception(e);
        }
    }

    public void saveParamsField(ArrayList<Argument> operationFields) throws Exception {
        try {
            if (!this.validateParamsFields()) {
                throw new Exception("");
            }
            JsonArray operationsObj = this.infoContentObj.get("operations").getAsJsonArray();
            int operationIndex = this.findIndexOfOperation(operationsObj, this.operation);
            JsonObject prevOperationJsonObj = operationsObj.get(operationIndex).getAsJsonObject();
            JsonArray prevParamsArray = prevOperationJsonObj.get("parameters").getAsJsonArray();
            Gson gson = new GsonBuilder().create();
            JsonElement fieldsArray = gson.toJsonTree(operationFields);
            JsonArray newParamsArray = fieldsArray.getAsJsonArray();
            if (newParamsArray != null) {
                JsonUtils.updateAllFields(prevParamsArray, newParamsArray);
                JsonUtils.writeInfoJsonFile(this.infoFilePath, this.infoContentObj);
                CommonUtils.showInfoMessage(Constants.POP_MESSAGE.getProperty("saveSuccessMessage"));
            }
        }
        catch (Exception e) {
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("saveFailedMessage"));
            throw new Exception(e);
        }
    }

    public boolean validate() {
        return this.validateOperationsFields() && this.validateParamsFields();
    }

    public boolean validateOperationsFields() {
        Object errorMsg = "";
        if (this.getName().strip().length() == 0) {
            errorMsg = (String)errorMsg + Constants.POP_MESSAGE.getProperty("operationNameRequiredFieldsMsg");
        }
        if (this.getTitle().strip().length() == 0) {
            errorMsg = (String)errorMsg + Constants.POP_MESSAGE.getProperty("operationTitleRequiredFieldsMsg");
        }
        if (this.getDescription().strip().length() == 0) {
            errorMsg = (String)errorMsg + Constants.POP_MESSAGE.getProperty("operationDescriptionRequiredFieldsMsg");
        }
        if (((String)errorMsg).length() > 0) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("invalidOperationDetailsFields"), errorMsg));
            return false;
        }
        return true;
    }

    public boolean validateParamsFields() {
        Argument arg;
        String error_msg = "";
        Iterator<Argument> iterator = this.parameters.iterator();
        while (iterator.hasNext() && (error_msg = (arg = iterator.next()).checkRequiredFields()).length() <= 0) {
            arg.removeEmptyFields();
        }
        if (error_msg.length() > 0) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("operationArgsValidationFailed"), error_msg));
            return false;
        }
        return true;
    }

    public void deleteParameter(String name) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!this.parameters.get(i).getName().equals(name)) continue;
            this.parameters.remove(i);
            break;
        }
    }

    public void deleteParameter(Argument arg) {
        this.parameters.remove(arg);
    }

    public String[] getOperationsList() {
        ArrayList<String> operationList = new ArrayList<String>();
        try {
            JsonArray operationsObj = this.infoContentObj.getAsJsonArray("operations");
            for (int i = 0; i < operationsObj.size(); ++i) {
                String temp = operationsObj.get(i).getAsJsonObject().get("operation").getAsString();
                operationList.add(temp);
            }
        }
        catch (Exception e) {
            return operationList.toArray(new String[0]);
        }
        return operationList.toArray(new String[0]);
    }

    public String getConnectorName() {
        return this.infoContentObj.get("name").getAsString();
    }
}

