/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.execution;

import com.fortinet.fortisoar.actions.NewConnector;
import com.fortinet.fortisoar.init.ConfigReader;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.JsonUtils;
import com.google.gson.JsonObject;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class FortiRunDebugConfiguration {
    private static final Logger logger = Logger.getInstance(NewConnector.class);
    static PsiDirectory projectConfigDirectoryPath;
    static PsiDirectory projectIdeaDirectoryPath;
    static PsiFile runDebugConfigFile;
    static VirtualFile virtualFile;
    static String runDebugConfigFileName;

    public static void createRunDebugConfiguration(Project project, String infoFilePath, String executeOperationScriptPath, String inLineCommands, Boolean isConfigValue) {
        String configAPIName;
        String configName;
        Map configYml = ConfigReader.configYML;
        JsonObject connectorInfoJsonData = JsonUtils.readJsonFile(infoFilePath);
        String connectorName = connectorInfoJsonData.get("label").getAsString();
        if (isConfigValue.booleanValue()) {
            configName = "Check Health";
            configAPIName = "check_health";
        } else {
            configName = "Operations";
            configAPIName = "operations";
        }
        String runDebugConfigName = String.format("%s > %s", connectorName, configName);
        runDebugConfigFileName = String.format("%s_%s.xml", CommonUtils.convertToAPIName(connectorName), configAPIName);
        logger.info(String.format("Creating Configuration with name: %s", runDebugConfigName));
        String runDebugXmlFile = configYml.get("run_debug_xml_file").toString();
        String runDebugXmlFileContent = String.format(runDebugXmlFile, runDebugConfigName, connectorName, project.getName(), ConnectorUtils.getPythonPath(project), executeOperationScriptPath, inLineCommands);
        try {
            String runDebugConfigFilePath;
            if (FortiRunDebugConfiguration.isConfigurationFileExists(project)) {
                runDebugConfigFilePath = FortiRunDebugConfiguration.updateOperationXML(project, inLineCommands);
            } else {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    runDebugConfigFile = projectConfigDirectoryPath.createFile(runDebugConfigFileName);
                });
                runDebugConfigFilePath = runDebugConfigFile.getVirtualFile().getPath();
                FortiRunDebugConfiguration.formatAndSaveXml(project, runDebugXmlFileContent, runDebugConfigFilePath);
            }
            logger.info(String.format("Successfully created %s file", runDebugConfigFilePath));
        }
        catch (Exception ex) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("failedToCreateRunDebugConfiguration"), ex.getMessage()));
            logger.error("Failed to create Run & Debug Configuration.", (Throwable)ex);
        }
    }

    private static boolean isConfigurationFileExists(Project project) throws Exception {
        String errorMessage = "";
        @Nullable VirtualFile projectPath = LocalFileSystem.getInstance().findFileByPath(Objects.requireNonNull(project.getBasePath()));
        assert (projectPath != null);
        @Nullable PsiDirectory projectDirectory = PsiManager.getInstance((Project)project).findDirectory(projectPath);
        if (projectDirectory == null) {
            errorMessage = String.format(Constants.POP_MESSAGE.getProperty("directoryNotFoundMessage"), String.format("Project %s", project.getName()));
            throw new Exception(errorMessage);
        }
        @Nullable PsiDirectory projectIdeaDirectory = projectDirectory.findSubdirectory(".idea");
        if (projectIdeaDirectory == null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                projectIdeaDirectoryPath = projectDirectory.createSubdirectory(".idea");
            });
        } else {
            projectIdeaDirectoryPath = projectIdeaDirectory;
        }
        @Nullable PsiDirectory projectConfigDirectory = projectIdeaDirectoryPath.findSubdirectory("runConfigurations");
        if (projectConfigDirectory == null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                projectConfigDirectoryPath = projectIdeaDirectoryPath.createSubdirectory("runConfigurations");
            });
        } else {
            projectConfigDirectoryPath = projectConfigDirectory;
        }
        for (PsiElement psiElement : projectConfigDirectoryPath.getChildren()) {
            virtualFile = psiElement.getContainingFile().getVirtualFile();
            if (virtualFile == null || !runDebugConfigFileName.toLowerCase().equals(virtualFile.getName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static String updateOperationXML(Project project, String inLineCommands) throws Exception {
        XmlTag[] configurationTags;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (!virtualFile.getFileType().getName().equals("XML")) {
            logger.error(String.format("File \"%s\" is not of an XML file", virtualFile.getFileType().getName()));
            throw new Exception(String.format("File \"%s\" is not of an XML file", virtualFile.getFileType().getName()));
        }
        XmlFile xmlFile = (XmlFile)psiManager.findFile(virtualFile);
        if (xmlFile == null) {
            logger.error("Failed to load XML file");
            throw new Exception("Failed to load XML file");
        }
        block0: for (XmlTag configurationTag : configurationTags = xmlFile.getRootTag().findSubTags("configuration")) {
            XmlTag[] optionTags;
            for (XmlTag optionTag : optionTags = configurationTag.findSubTags("option")) {
                if (!"PARAMETERS".equals(optionTag.getAttributeValue("name"))) continue;
                XmlAttribute valueAttribute = optionTag.getAttribute("value");
                if (valueAttribute == null) continue block0;
                String newValue = inLineCommands;
                ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)project, () -> valueAttribute.setValue(newValue)));
                continue block0;
            }
        }
        logger.info(String.format("Successfully updated XML %s file.", virtualFile.getFileType().getName()));
        return virtualFile.getPath();
    }

    private static void formatAndSaveXml(Project project, String xmlString, String filePath) {
        XmlFileType fileType = XmlFileType.INSTANCE;
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("temp.xml", (FileType)fileType, (CharSequence)xmlString);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiElement formattedPsiElement = codeStyleManager.reformat((PsiElement)psiFile);
        PsiDocumentManager.getInstance((Project)project).commitDocument(psiFile.getViewProvider().getDocument());
        String formattedXml = formattedPsiElement.getText();
        try (FileWriter fileWriter = new FileWriter(new File(filePath));){
            fileWriter.write(formattedXml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

