/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.utils;

import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class JsonUtils {
    public static final Logger logger = Logger.getInstance(JsonUtils.class);

    public static JsonObject readJsonFile(String infoFilePath) {
        JsonObject obj = null;
        String normalized_path = Paths.get(infoFilePath, new String[0]).normalize().toString();
        try (FileReader reader = new FileReader(FilenameUtils.normalize((String)normalized_path));){
            obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (IOException e) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("readJsonFileFailedIO"), e.getMessage()));
            logger.error("Unable to read info.json.", (Throwable)e);
        }
        catch (JsonParseException e) {
            String errorMsg = JsonUtils.findJsonError((Exception)((Object)e));
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("readJsonFileFailedParse"), errorMsg));
            logger.error("Unable to parse info.json.", (Throwable)e);
        }
        return obj;
    }

    public static JsonObject readEncodedJsonFile(String filePath) {
        JsonObject obj = null;
        String normalized_path = Paths.get(filePath, new String[0]).normalize().toString();
        try (FileReader reader = new FileReader(FilenameUtils.normalize((String)normalized_path));){
            int content;
            StringBuilder data = new StringBuilder();
            while ((content = reader.read()) != -1) {
                data.append((char)content);
            }
            String jsonContent = String.valueOf(data);
            obj = JsonParser.parseString((String)jsonContent).getAsJsonObject();
        }
        catch (IOException e) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("readLocalDataJsonFileFailedIO"), e.getMessage()));
            logger.error("Unable to read local_data.json.", (Throwable)e);
        }
        catch (JsonParseException e) {
            String errorMsg = JsonUtils.findJsonError((Exception)((Object)e));
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("readLocalDataJsonFileFailedParse"), errorMsg));
            logger.error("Unable to parse local_data.json.", (Throwable)e);
        }
        return obj;
    }

    public static void writeInfoJsonFile(String infoFilePath, JsonObject content) {
        try {
            FileWriter writer = new FileWriter(infoFilePath);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String contentStr = gson.toJson((JsonElement)content);
            writer.write(contentStr);
            writer.close();
        }
        catch (IOException e) {
            logger.error("Write info.json file failed.", (Throwable)e);
        }
    }

    public static JsonObject createOperationJsonObject(Operation operationDetail) throws Exception {
        JsonObject operationJsonObj;
        block2: {
            Gson gson = new GsonBuilder().create();
            operationJsonObj = (JsonObject)gson.toJsonTree((Object)operationDetail);
            JsonArray paramsFields = operationJsonObj.get("parameters").getAsJsonArray();
            JsonUtils.convertParamsFields(paramsFields);
            operationJsonObj.remove("infoFilePath");
            operationJsonObj.remove("infoContentObj");
            try {
                JsonElement formattedOutputSchema = ConnectorUtils.createOutputSchema(operationDetail.getOutput_schema());
                operationJsonObj.add("output_schema", formattedOutputSchema);
            }
            catch (JsonParseException e) {
                String errorMsg = String.format(Constants.POP_MESSAGE.getProperty("errorInOutputSchemaSaveConfirmationMessage"), JsonUtils.findJsonError((Exception)((Object)e)));
                boolean messageDialog = CommonUtils.askYesNoQuestion(errorMsg);
                if (messageDialog) break block2;
                return null;
            }
        }
        return operationJsonObj;
    }

    public static String findJsonError(Exception e) {
        String error = e.getMessage();
        String[] errorSplit = error.split("accept");
        String errorMsg = errorSplit[errorSplit.length - 1];
        errorMsg = errorMsg.replace("path $", "");
        return errorMsg.strip();
    }

    public static void convertParamsFields(JsonArray paramsFields) {
        for (int i = 0; i < paramsFields.size(); ++i) {
            JsonUtils.convertJsonValueObjectIntoTheirRespectiveType(paramsFields.get(i).getAsJsonObject());
        }
    }

    public static void convertJsonValueObjectIntoTheirRespectiveType(JsonObject fields) {
        if (fields.get("type").getAsString().equals("checkbox")) {
            JsonElement value = fields.get("value");
            if (value != null) {
                fields.addProperty("value", Boolean.valueOf(fields.get("value").getAsBoolean()));
            } else {
                fields.addProperty("value", Boolean.valueOf(false));
            }
        } else if (fields.get("type").getAsString().equals("integer")) {
            JsonElement value = fields.get("value");
            if (value != null) {
                fields.addProperty("value", (Number)fields.get("value").getAsInt());
            }
        } else if (fields.get("type").getAsString().equals("json")) {
            JsonElement value = fields.get("value");
            Object valueObj = null;
            if (value != null) {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                try {
                    fields.add("value", (JsonElement)fields.get("value").getAsJsonObject());
                }
                catch (Exception ex) {
                    try {
                        fields.add("value", (JsonElement)fields.get("value").getAsJsonArray());
                    }
                    catch (Exception ex1) {
                        fields.addProperty("value", fields.get("value").getAsString());
                    }
                }
            }
        }
    }

    public static void updateAllFields(JsonArray prevFields, JsonArray updatedFields) {
        int curr;
        int prevSize = prevFields.size();
        int updatedSize = updatedFields.size();
        for (curr = 0; curr < prevSize; ++curr) {
            prevFields.remove(0);
        }
        for (curr = 0; curr < updatedSize; ++curr) {
            prevFields.add((JsonElement)updatedFields.get(curr).getAsJsonObject());
        }
    }

    public static void updateOperationJsonObject(JsonObject prevOperation, JsonObject newOperation) {
        Set keys = newOperation.keySet();
        for (String key : keys) {
            if (key.equals("parameters")) continue;
            prevOperation.add(key, newOperation.get(key));
        }
    }

    public static JsonObject updateLocalDataJsonObject(JsonObject prevLocalData, JsonObject newLocalData) {
        Set keys = newLocalData.keySet();
        for (String key : keys) {
            prevLocalData.add(key, newLocalData.get(key));
        }
        return prevLocalData;
    }

    public static void createLocalDataFileIfNotFound(String localDataFilePath) {
        File file;
        String localDataDirPath = Paths.get(localDataFilePath, new String[0]).getParent().toString();
        File localDataDir = new File(localDataDirPath);
        if (!localDataDir.exists()) {
            localDataDir.mkdirs();
        }
        if (!(file = new File(localDataFilePath)).exists()) {
            try {
                boolean f = file.createNewFile();
                if (f) {
                    JsonUtils.writeInfoJsonFile(file.getPath(), new JsonObject());
                }
            }
            catch (IOException ex) {
                logger.error("Failed to create \"local_data.json\".", (Throwable)ex);
            }
        }
    }

    public static String convertToJsonPrettyString(JsonElement jsonObject) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson(jsonObject);
        }
        catch (Exception ex) {
            return jsonObject.toString();
        }
    }
}

