/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.utils;

import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

public class IOUtils {
    public static final Logger logger = Logger.getInstance(IOUtils.class);

    public static void createTarGzipFolder(String sourceName, String exportPath) throws IOException {
        logger.info(String.format("Create tgz triggered for folder: %S", sourceName));
        Path connectorExportPath = Paths.get(exportPath, new String[0]);
        final Path source = Paths.get(sourceName, new String[0]);
        if (!Files.isDirectory(connectorExportPath, new LinkOption[0])) {
            String errorMsg = Constants.POP_MESSAGE.getProperty("errorMessageConnectorFolderDoesNotExist");
            logger.error(String.format("Create tgz folder failed. Export path [%s] does not exist.", connectorExportPath));
            throw new IOException(String.format(errorMsg, connectorExportPath));
        }
        String tarFileName = connectorExportPath + "/" + source.getFileName().toString() + ".tgz";
        try (OutputStream fOut = Files.newOutputStream(Paths.get(tarFileName, new String[0]), new OpenOption[0]);
             BufferedOutputStream buffOut = new BufferedOutputStream(fOut);
             GzipCompressorOutputStream gzOut = new GzipCompressorOutputStream((OutputStream)buffOut);
             final TarArchiveOutputStream tOut = new TarArchiveOutputStream((OutputStream)gzOut);){
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    if (attributes.isSymbolicLink()) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path targetFile = source.getParent().relativize(file);
                    try {
                        TarArchiveEntry tarEntry = new TarArchiveEntry(file.toFile(), targetFile.toString());
                        tOut.putArchiveEntry((ArchiveEntry)tarEntry);
                        Files.copy(file, (OutputStream)tOut);
                        tOut.closeArchiveEntry();
                    }
                    catch (IOException ioException) {
                        logger.error(String.format("Unable to put in tgz. File: %s", file), (Throwable)ioException);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException ioException) {
                    logger.error(String.format("Create tgz failed. File: %s", file.toString()), (Throwable)ioException);
                    return FileVisitResult.CONTINUE;
                }
            });
            tOut.finish();
            CommonUtils.showInfoMessage(String.format(Constants.POP_MESSAGE.getProperty("exportedSuccessMessage"), exportPath));
            logger.info(String.format("Connector export successful at: %s", exportPath));
        }
    }

    public static void decompressTarGzipFile(Path source, Path target) throws Exception {
        block27: {
            if (Files.exists(source, new LinkOption[0])) {
                try (InputStream fi = Files.newInputStream(source, new OpenOption[0]);
                     BufferedInputStream bi = new BufferedInputStream(fi);
                     GzipCompressorInputStream gzi = new GzipCompressorInputStream((InputStream)bi);
                     TarArchiveInputStream ti = new TarArchiveInputStream((InputStream)gzi);){
                    ArchiveEntry entry;
                    while ((entry = ti.getNextEntry()) != null) {
                        Path newPath = IOUtils.zipSlipProtect(entry, target);
                        if (entry.isDirectory()) {
                            Files.createDirectories(newPath, new FileAttribute[0]);
                            continue;
                        }
                        Path parent = newPath.getParent();
                        if (parent != null && Files.notExists(parent, new LinkOption[0])) {
                            Files.createDirectories(parent, new FileAttribute[0]);
                        }
                        Files.copy((InputStream)ti, newPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    break block27;
                }
                catch (Exception ex) {
                    throw new Exception(String.format("Decompress tgz file failed. Source: %s; Error: %s", source, ex.getMessage()));
                }
            }
            throw new Exception(String.format("Decompress tgz failed. Selected tgz does not exist. Source: %S", source));
        }
    }

    private static Path zipSlipProtect(ArchiveEntry entry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(entry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad entry: " + entry.getName());
        }
        return normalizePath;
    }

    public static void reloadFromDisk(@NotNull Project project) {
        if (project == null) {
            IOUtils.$$$reportNull$$$0(0);
        }
        VirtualFile currentFilePath = LocalFileSystem.getInstance().findFileByPath(project.getBasePath());
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{currentFilePath});
        logger.info("All files reloaded from disk.");
    }

    public static Boolean writeStringToFile(String path, String stringToWrite) {
        String normalized_path = Paths.get(path, new String[0]).normalize().toString();
        File file = new File(normalized_path);
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.write(stringToWrite);
            writer.close();
        }
        catch (IOException e) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("failedWriteIntoFileMessage"), path, e.getMessage()));
            logger.error(String.format("Write string to file failed. File: %s; Content: %s", path, stringToWrite), (Throwable)e);
            return false;
        }
        return true;
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        boolean deleted = file.delete();
        if (!deleted) {
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("deleteFileFailedMessage") + path);
            logger.debug(String.format("File deletion failed. File: %s", path));
        }
    }

    public static String getConnectorExportPath(Component parentComponent) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        int result = fileChooser.showOpenDialog(parentComponent);
        if (result == 0) {
            String selectedDirectory = fileChooser.getSelectedFile().getAbsolutePath();
            return selectedDirectory;
        }
        return null;
    }

    public static void importTgzAction(Project project, Component parentComponent) {
        try {
            String tgzFile = IOUtils.selectTgzFile(parentComponent);
            if (tgzFile == null) {
                return;
            }
            Path tgzFilePath = Paths.get(tgzFile, new String[0]);
            Path targetPath = Paths.get(Objects.requireNonNull(project.getBasePath()), new String[0]);
            IOUtils.decompressTarGzipFile(tgzFilePath, targetPath);
            IOUtils.reloadFromDisk(project);
            CommonUtils.showInfoMessage(String.format(Constants.POP_MESSAGE.getProperty("importSuccessMessage", "Imported successfully!!!"), tgzFilePath.getFileName()));
        }
        catch (Exception ex) {
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("importFailedMessage", "Import failed!!!"));
            logger.error("Import tgz failed.", (Throwable)ex);
        }
    }

    public static String selectTgzFile(Component parent) {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("tgz or tar.gz files", "tgz", "tar.gz");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(parent);
        if (returnVal == 0) {
            return chooser.getSelectedFile().getPath();
        }
        return null;
    }

    public static void copyFile(String sourceFile, String infoFilePath) {
        Path sourcePath = Paths.get(sourceFile, new String[0]);
        String destination = Paths.get(infoFilePath, new String[0]).getParent().toString() + "/images/" + sourcePath.getFileName();
        Path destinationPath = Paths.get(destination, new String[0]);
        try {
            Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception ex) {
            logger.debug(String.format("Copy file(image) failed. Error: %s", ex.getMessage()));
        }
    }

    public static void copyResources(Project project, Class parent) {
        try {
            String projectPath = project.getBasePath();
            Path destPath = Paths.get(projectPath, Constants.FORTISOAR_CONNECTOR_ENGINE_LIBRARY_PATH);
            InputStream src = parent.getResourceAsStream(Constants.FORTISOAR_CONNECTOR_ENGINE_LIBRARY_PATH);
            assert (src != null);
            Files.copy(src, destPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception ioException) {
            logger.debug("Copy resources(FortiSOAR Connector Engine Library) failed.", (Throwable)ioException);
        }
    }

    public static void deleteResources(Project project) {
        try {
            String projectPath = project.getBasePath();
            Path destPath = Paths.get(projectPath, Constants.FORTISOAR_CONNECTOR_ENGINE_LIBRARY_PATH);
            IOUtils.deleteFile(destPath.toString());
        }
        catch (Exception ioException) {
            logger.debug("Delete resources(FortiSOAR Connector Engine Library) failed.", (Throwable)ioException);
        }
    }

    public static Properties readPropertiesFile(String fileName, Class parent) {
        InputStream src = null;
        Properties prop = null;
        try {
            src = parent.getResourceAsStream(fileName);
            prop = new Properties();
            prop.load(src);
            src.close();
        }
        catch (IOException fnfe) {
            logger.error(String.format("Failed to read properties file. File: %s", fileName), (Throwable)fnfe);
        }
        return prop;
    }

    public static Properties getPopMessageProperties(Class parent) {
        return IOUtils.readPropertiesFile("/properties/en-us/PopMessage.properties", parent);
    }

    public static Properties getErrorMessageProperties(Class parent) {
        return IOUtils.readPropertiesFile("/properties/en-us/ErrorMessage.properties", parent);
    }

    public static Properties getUITextProperties(Class parent) {
        return IOUtils.readPropertiesFile("/properties/en-us/UIText.properties", parent);
    }

    public static Properties getTooltipProperties(Class parent) {
        return IOUtils.readPropertiesFile("/properties/en-us/Tooltip.properties", parent);
    }

    public static Properties getFileNameProperties(Class parent) {
        return IOUtils.readPropertiesFile("/properties/en-us/FileNames.properties", parent);
    }

    public static Map readConfigurationFile(Class parent) {
        InputStream src = parent.getResourceAsStream("/META-INF/configuration.yml");
        String config = null;
        try {
            assert (src != null);
            config = new String(src.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            logger.debug("Read configuration file failed.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        Yaml configYaml = new Yaml();
        return (Map)configYaml.load(config);
    }

    public static void exportConnector(String infoFilePath, String exportPath) {
        String srcFile = Paths.get(infoFilePath, new String[0]).getParent().toString();
        try {
            IOUtils.createTarGzipFolder(srcFile, exportPath);
        }
        catch (Exception ex) {
            logger.error(String.format("Export connector [%s] failed. Error: %s", srcFile, ex.getMessage()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/fortinet/fortisoar/utils/IOUtils", "reloadFromDisk"));
    }
}

