/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.operation;

import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.connector.OperationsTabbedPane;
import com.fortinet.fortisoar.ui.operation.ArgumentsPanel;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.IOUtils;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXButton;

public class NewOperationPanel
extends JPanel {
    public JTextField nameTextField;
    public JTextField titleTextField;
    public JTextArea endpointTextField;
    public ComboBox methodField;
    public JTextArea descriptionTextField;
    public String operationMethod = "GET";
    public String operationEndpoint = "";
    public JCheckBox generateDefaultOperationCodeCheckBox;
    private JPanel buttonPanel;

    public NewOperationPanel(OperationsTabbedPane parent) {
        this.setLayout((LayoutManager)new GridLayoutManager(8, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        TitledBorder titledBorder = FSRTheme.createFSRTitleBorder("operationAddNewBorder");
        this.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.setVisible(false);
        FSRTheme.decorateBackground(this);
        this.createTitleField();
        this.createNameField();
        this.createEndpointField();
        this.createMethodField();
        this.createDescriptionField();
        this.createGenerateDefaultCodeCheckBox();
        this.createButtonPanel(parent);
    }

    private void createNameField() {
        JLabel nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.nameTextField.setName("nameTextField");
        FSRTheme.decorateInputField(this.nameTextField);
        nameLabel.setLabelFor(this.nameTextField);
        nameLabel.setText(Constants.UI_TEXT.getProperty("opDetailsBasicName"));
        nameLabel.setToolTipText(Constants.TOOLTIP.getProperty("opNameTooltip", ""));
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                ConnectorUtils.validateRequiredField(NewOperationPanel.this.nameTextField, ArgumentsPanel.defaultBorderColor);
            }
        });
        this.add((Component)nameLabel, new GridConstraints(1, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.add((Component)this.nameTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createTitleField() {
        JLabel titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.titleTextField.setName("titleTextField");
        FSRTheme.decorateInputField(this.titleTextField);
        titleLabel.setText(Constants.UI_TEXT.getProperty("opDetailsBasicTitle"));
        titleLabel.setToolTipText(Constants.TOOLTIP.getProperty("opTitleTooltip", ""));
        this.titleTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                ConnectorUtils.validateRequiredField(NewOperationPanel.this.titleTextField, ArgumentsPanel.defaultBorderColor);
                if (NewOperationPanel.this.nameTextField != null) {
                    NewOperationPanel.this.nameTextField.setText(CommonUtils.convertToAPIName(NewOperationPanel.this.titleTextField.getText()));
                }
            }
        });
        this.add((Component)titleLabel, new GridConstraints(0, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.add((Component)this.titleTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createEndpointField() {
        JLabel endpointLabel = new JLabel();
        this.endpointTextField = FSRTheme.createFSRTextAreaField("endpointTextField", 1, 1);
        this.endpointTextField.setFont(endpointLabel.getFont());
        this.endpointTextField.setLineWrap(true);
        this.endpointTextField.setWrapStyleWord(true);
        endpointLabel.setLabelFor(this.endpointTextField);
        endpointLabel.setText(Constants.UI_TEXT.getProperty("opDetailsBasicEndpoint"));
        endpointLabel.setToolTipText(Constants.TOOLTIP.getProperty("opEndpointTooltip", ""));
        this.endpointTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                NewOperationPanel.this.operationEndpoint = NewOperationPanel.this.endpointTextField.getText();
            }
        });
        this.add((Component)endpointLabel, new GridConstraints(2, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.add((Component)this.endpointTextField, new GridConstraints(2, 1, 1, 1, 8, 3, 3, 3, null, null, null));
    }

    private void createMethodField() {
        JLabel methodLabel = new JLabel();
        methodLabel.setLabelFor((Component)this.methodField);
        methodLabel.setText(Constants.UI_TEXT.getProperty("opDetailsBasicMethod"));
        methodLabel.setToolTipText(Constants.TOOLTIP.getProperty("opMethodTooltip", ""));
        this.methodField = FSRTheme.createFSRComboBox(Constants.OPERATION_METHOD_TYPE);
        this.methodField.setSelectedItem((Object)this.operationMethod);
        this.add((Component)methodLabel, new GridConstraints(3, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.add((Component)this.methodField, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 3, null, null, null));
        this.methodField.addActionListener(e -> {
            ComboBox comboBox = (ComboBox)e.getSource();
            this.operationMethod = (String)comboBox.getSelectedItem();
        });
    }

    private void createDescriptionField() {
        JLabel descriptionLabel = new JLabel();
        this.descriptionTextField = FSRTheme.createFSRTextAreaField("descriptionTextField", 1, 1);
        this.descriptionTextField.setLineWrap(true);
        this.descriptionTextField.setWrapStyleWord(true);
        this.descriptionTextField.setFont(descriptionLabel.getFont());
        descriptionLabel.setLabelFor(this.descriptionTextField);
        descriptionLabel.setText(Constants.UI_TEXT.getProperty("opDetailsBasicDescription"));
        descriptionLabel.setToolTipText(Constants.TOOLTIP.getProperty("opDescriptionTooltip", ""));
        this.descriptionTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                ConnectorUtils.validateRequiredField(NewOperationPanel.this.descriptionTextField, ArgumentsPanel.defaultBorderColor);
            }
        });
        this.add((Component)descriptionLabel, new GridConstraints(4, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.add((Component)this.descriptionTextField, new GridConstraints(4, 1, 1, 1, 8, 3, 3, 3, new Dimension(100, 80), null, null));
    }

    private void createGenerateDefaultCodeCheckBox() {
        this.generateDefaultOperationCodeCheckBox = new JCheckBox("Generate Default Operation Code");
        this.generateDefaultOperationCodeCheckBox.setHorizontalTextPosition(10);
        this.generateDefaultOperationCodeCheckBox.setSelected(true);
        FSRTheme.decorateBackground(this.generateDefaultOperationCodeCheckBox);
        this.add((Component)this.generateDefaultOperationCodeCheckBox, new GridConstraints(5, 0, 1, 2, 8, 3, 3, 3, null, null, null));
    }

    private void createButtonPanel(OperationsTabbedPane parent) {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        JXButton createButton = FSRTheme.createFSRSaveButton("operationAddNewCreateButton", "/icons/create.png", this.getClass());
        createButton.addActionListener(e -> {
            if (this.validateRequiredField()) {
                if (!ConnectorUtils.isValidConnectorName(this.nameTextField.getText(), false) || !ConnectorUtils.isValidConnectorName(this.titleTextField.getText(), false)) {
                    CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("invalidConnectorNameMessage"));
                    return;
                }
                if (parent.checkExistingOperation(this.nameTextField, this.titleTextField)) {
                    boolean generateDefaultOperationCodeSelected = this.generateDefaultOperationCodeCheckBox.isSelected();
                    parent.newOperationAction(this.nameTextField.getText(), this.titleTextField.getText(), this.descriptionTextField.getText(), this.operationEndpoint, this.operationMethod, generateDefaultOperationCodeSelected);
                    parent.repaintOperations(!generateDefaultOperationCodeSelected);
                    IOUtils.reloadFromDisk(parent.project);
                    this.setVisible(false);
                }
            }
        });
        JXButton cancelButton = FSRTheme.createFSRButton("operationAddNewCancelButton", "/icons/cancel.png", "", this.getClass());
        cancelButton.addActionListener(e -> this.setVisible(false));
        this.buttonPanel.add((Component)createButton, new GridConstraints(0, 0, 1, 1, 6, 0, 3, 3, null, null, null));
        this.buttonPanel.add((Component)cancelButton, new GridConstraints(0, 1, 1, 1, 6, 0, 3, 3, null, null, null));
        FSRTheme.decorateBackground(this.buttonPanel);
        this.add((Component)this.buttonPanel, new GridConstraints(7, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private boolean validateRequiredField() {
        boolean flag = ConnectorUtils.validateRequiredField(this.nameTextField, ArgumentsPanel.defaultBorderColor);
        flag = ConnectorUtils.validateRequiredField(this.titleTextField, ArgumentsPanel.defaultBorderColor) && flag;
        flag = ConnectorUtils.validateRequiredField(this.descriptionTextField, ArgumentsPanel.defaultBorderColor) && flag;
        return flag;
    }
}

