/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.operation;

import com.fortinet.fortisoar.init.PropReader;
import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.model.Connector;
import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.connector.ConfigurationTabbedPane;
import com.fortinet.fortisoar.ui.operation.OperationDialog;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXButton;

public class ArgumentsPanel
extends JPanel {
    public static Color defaultBorderColor = Color.gray;
    public MessageBus msgBus;
    public JLabel argsTitleLabel;
    public JTextField argsTitleText;
    public JLabel nameLabel;
    public JTextField nameText;
    public JLabel descriptionLabel;
    public JTextArea descriptionText;
    public JLabel placeholderLabel;
    public JTextArea placeholderText;
    public JLabel valueLabel;
    public JTextArea valueText;
    public JLabel optionsLabel;
    public JTextArea optionsText;
    public JLabel apiOperationsLabel;
    public ComboBox apiOperationOptions;
    public JLabel typeLabel;
    public ComboBox typeOptions;
    public JLabel attributesLabel;
    public JCheckBox isRequired;
    public JCheckBox isVisible;
    public JCheckBox isEditable;
    private Project project;
    private JXButton deleteArgumentButton;
    private boolean isConfigArgs = false;
    private Argument arg;
    private Operation operation;
    private Connector connector;
    private JPanel argDescWrapPanel;
    private JPanel checkBoxesWrapPanel;
    private JPanel deleteButtonPanel;
    private OperationDialog operationParent;
    private ConfigurationTabbedPane connectorParent;

    public ArgumentsPanel(Project project, Argument arg, Operation operationDetail, OperationDialog parentPane) {
        this.project = project;
        this.arg = arg;
        this.operation = operationDetail;
        this.operationParent = parentPane;
        this.createArgsPanel();
    }

    public ArgumentsPanel(Project project, Argument arg, Connector connectorDetail, ConfigurationTabbedPane parentPane) {
        this.project = project;
        this.isConfigArgs = true;
        this.arg = arg;
        this.connector = connectorDetail;
        this.connectorParent = parentPane;
        this.createArgsPanel();
    }

    private void createArgsPanel() {
        this.setLayout((LayoutManager)new GridLayoutManager(4, 3, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        this.argDescWrapPanel = new JPanel();
        this.argDescWrapPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.argDescWrapPanel);
        this.createTitleField();
        this.createNameField();
        this.createOptionsField();
        this.createAPIOperationField();
        this.createTypeField();
        this.createPlaceholderField();
        this.createValueField();
        this.createDescriptionField();
        this.createTooltipField();
        this.createAttributeField();
        this.createDeleteButtonPanel();
        this.add((Component)this.argDescWrapPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.add((Component)this.checkBoxesWrapPanel, new GridConstraints(1, 0, 1, 1, 1, 3, 4, 4, null, null, null));
        this.add((Component)this.deleteButtonPanel, new GridConstraints(3, 0, 1, 1, 4, 1, 4, 4, null, null, null));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray), BorderFactory.createEmptyBorder(10, 0, 10, 0)));
        FSRTheme.decorateBackground(this);
    }

    private void createNameField() {
        this.nameLabel = new JLabel();
        this.nameLabel.setLabelFor(this.nameText);
        this.nameLabel.setText(Constants.UI_TEXT.getProperty("argsName"));
        this.nameLabel.setToolTipText(Constants.TOOLTIP.getProperty("argsNameTooltip", ""));
        this.nameText = FSRTheme.createFSRTextField(this.arg.getName());
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            private void updateLabel(DocumentEvent e) {
                ConnectorUtils.validateRequiredField(ArgumentsPanel.this.nameText, defaultBorderColor);
                ArgumentsPanel.this.arg.setName(ArgumentsPanel.this.nameText.getText());
                if (!ArgumentsPanel.this.isConfigArgs) {
                    ArgumentsPanel.this.operationParent.isChanged = true;
                }
            }
        });
        this.argDescWrapPanel.add((Component)this.nameLabel, new GridConstraints(1, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.argDescWrapPanel.add((Component)this.nameText, new GridConstraints(1, 1, 1, 1, 8, 3, 2, 0, null, null, null));
    }

    private void createTitleField() {
        this.argsTitleLabel = new JLabel();
        this.argsTitleLabel.setLabelFor(this.argsTitleText);
        this.argsTitleLabel.setText(Constants.UI_TEXT.getProperty("argsTitle"));
        this.argsTitleLabel.setToolTipText(Constants.TOOLTIP.getProperty("argsTitleTooltip", ""));
        this.argsTitleText = FSRTheme.createFSRTextField(this.arg.getTitle());
        this.argsTitleText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            private void updateLabel(DocumentEvent e) {
                ConnectorUtils.validateRequiredField(ArgumentsPanel.this.argsTitleText, defaultBorderColor);
                ArgumentsPanel.this.arg.setTitle(ArgumentsPanel.this.argsTitleText.getText());
                if (ArgumentsPanel.this.nameText != null) {
                    ArgumentsPanel.this.nameText.setText(CommonUtils.convertToAPIName(ArgumentsPanel.this.argsTitleText.getText()));
                    if (!ArgumentsPanel.this.isConfigArgs) {
                        ArgumentsPanel.this.operationParent.isChanged = true;
                    }
                }
            }
        });
        this.argDescWrapPanel.add((Component)this.argsTitleLabel, new GridConstraints(0, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.argDescWrapPanel.add((Component)this.argsTitleText, new GridConstraints(0, 1, 1, 1, 8, 3, 2, 0, null, null, null));
    }

    private void createTypeField() {
        this.typeLabel = new JLabel();
        this.typeLabel.setLabelFor((Component)this.typeOptions);
        this.typeLabel.setText(Constants.UI_TEXT.getProperty("argsType"));
        this.typeLabel.setToolTipText(Constants.TOOLTIP.getProperty("argsTypeTooltip", ""));
        this.typeOptions = FSRTheme.createFSRComboBox(Constants.ARGS_TYPE_OPTIONS);
        this.typeOptions.setFont(this.nameText.getFont());
        this.typeOptions.setSelectedItem((Object)this.arg.getType());
        this.argDescWrapPanel.add((Component)this.typeLabel, new GridConstraints(2, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.argDescWrapPanel.add((Component)this.typeOptions, new GridConstraints(2, 1, 1, 1, 8, 3, 2, 0, null, null, null));
        this.typeOptions.addActionListener(e -> {
            ComboBox comboBox = (ComboBox)e.getSource();
            String selectedType = (String)comboBox.getSelectedItem();
            if (selectedType.equals("Select") | selectedType.equals("Multiselect")) {
                this.optionsLabel.setVisible(true);
                this.optionsText.setVisible(true);
            } else {
                this.optionsLabel.setVisible(false);
                this.optionsText.setVisible(false);
            }
            if (selectedType.equals(Constants.UI_TEXT.getProperty("argsTypeOperation"))) {
                this.apiOperationsLabel.setVisible(true);
                this.apiOperationOptions.setVisible(true);
            } else {
                this.apiOperationOptions.setVisible(false);
                this.apiOperationsLabel.setVisible(false);
            }
            this.arg.setType(selectedType);
            if (!this.isConfigArgs) {
                this.operationParent.isChanged = true;
            }
        });
    }

    private void createValueField() {
        this.valueLabel = new JLabel();
        this.valueLabel.setLabelFor(this.valueText);
        this.valueLabel.setText(Constants.UI_TEXT.getProperty("argsValue"));
        this.valueLabel.setToolTipText(Constants.TOOLTIP.getProperty("argsValueTooltip", ""));
        this.valueText = FSRTheme.createFSRTextAreaField(this.arg.getValue(), 0, 0);
        this.valueText.setLineWrap(true);
        this.valueText.setWrapStyleWord(true);
        this.valueText.setFont(this.nameText.getFont());
        this.valueText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            private void updateLabel(DocumentEvent e) {
                ArgumentsPanel.this.arg.setValue(ArgumentsPanel.this.valueText.getText());
                if (!ArgumentsPanel.this.isConfigArgs) {
                    ArgumentsPanel.this.operationParent.isChanged = true;
                }
            }
        });
        this.argDescWrapPanel.add((Component)this.valueLabel, new GridConstraints(3, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.argDescWrapPanel.add((Component)this.valueText, new GridConstraints(3, 1, 1, 1, 8, 3, 2, 0, null, null, null));
    }

    private void createOptionsField() {
        this.optionsLabel = new JLabel();
        this.optionsLabel.setLabelFor(this.optionsText);
        this.optionsLabel.setText(Constants.UI_TEXT.getProperty("argsOptions"));
        this.optionsLabel.setToolTipText(Constants.TOOLTIP.getProperty("argsOptionsTooltip", ""));
        this.optionsText = FSRTheme.createFSRTextAreaField(this.arg.getOptions(), 0, 0);
        this.optionsText.setFont(this.nameText.getFont());
        this.optionsText.setLineWrap(true);
        this.optionsText.setWrapStyleWord(true);
        this.optionsText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            private void updateLabel(DocumentEvent e) {
                ConnectorUtils.validateRequiredField(ArgumentsPanel.this.optionsText, defaultBorderColor);
                ArgumentsPanel.this.arg.setOptions(ArgumentsPanel.this.optionsText.getText());
                if (!ArgumentsPanel.this.isConfigArgs) {
                    ArgumentsPanel.this.operationParent.isChanged = true;
                }
            }
        });
        this.argDescWrapPanel.add((Component)this.optionsLabel, new GridConstraints(4, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.argDescWrapPanel.add((Component)this.optionsText, new GridConstraints(4, 1, 1, 1, 8, 3, 2, 0, null, null, null));
        if (this.arg.getType().equals("Select") | this.arg.getType().equals("Multiselect")) {
            this.optionsText.setVisible(true);
            this.optionsLabel.setVisible(true);
        } else {
            this.optionsText.setVisible(false);
            this.optionsLabel.setVisible(false);
        }
    }

    private void createAPIOperationField() {
        String[] apiOperationList = this.isConfigArgs ? this.connector.getOperationsList() : this.operation.getOperationsList();
        this.apiOperationsLabel = new JLabel();
        this.apiOperationsLabel.setLabelFor((Component)this.apiOperationOptions);
        this.apiOperationsLabel.setText(Constants.UI_TEXT.getProperty("argsAPIOperation"));
        this.apiOperationsLabel.setToolTipText(Constants.TOOLTIP.getProperty("argsAPIOperationTooltip", ""));
        this.apiOperationOptions = FSRTheme.createFSRComboBox(apiOperationList);
        this.apiOperationOptions.setFont(this.nameText.getFont());
        this.apiOperationOptions.setSelectedItem((Object)this.arg.getAPIOperations());
        this.apiOperationOptions.addActionListener(e -> {
            ComboBox comboBox = (ComboBox)e.getSource();
            String selectedOperation = (String)comboBox.getSelectedItem();
            this.arg.setAPIOperations(selectedOperation);
            if (!this.isConfigArgs) {
                this.operationParent.isChanged = true;
            }
        });
        this.argDescWrapPanel.add((Component)this.apiOperationsLabel, new GridConstraints(4, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.argDescWrapPanel.add((Component)this.apiOperationOptions, new GridConstraints(4, 1, 1, 1, 8, 3, 2, 0, null, null, null));
        if (this.arg.getType().equals(PropReader.UIText.getProperty("argsTypeOperation"))) {
            this.apiOperationOptions.setVisible(true);
            this.apiOperationsLabel.setVisible(true);
        } else {
            this.apiOperationOptions.setVisible(false);
            this.apiOperationsLabel.setVisible(false);
        }
    }

    private void createPlaceholderField() {
        this.placeholderLabel = new JLabel();
        this.placeholderLabel.setLabelFor(this.placeholderText);
        this.placeholderLabel.setText(Constants.UI_TEXT.getProperty("argsPlaceholder"));
        this.placeholderLabel.setToolTipText(Constants.TOOLTIP.getProperty("argsPlaceholderTooltip", ""));
        this.placeholderText = FSRTheme.createFSRTextAreaField(this.arg.getPlaceholder(), 0, 0);
        this.placeholderText.setFont(this.nameText.getFont());
        this.placeholderText.setLineWrap(true);
        this.placeholderText.setWrapStyleWord(true);
        this.placeholderText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            private void updateLabel(DocumentEvent e) {
                ArgumentsPanel.this.arg.setPlaceholder(ArgumentsPanel.this.placeholderText.getText());
                if (!ArgumentsPanel.this.isConfigArgs) {
                    ArgumentsPanel.this.operationParent.isChanged = true;
                }
            }
        });
        this.argDescWrapPanel.add((Component)this.placeholderLabel, new GridConstraints(5, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.argDescWrapPanel.add((Component)this.placeholderText, new GridConstraints(5, 1, 1, 1, 8, 3, 2, 0, null, null, null));
    }

    private void createTooltipField() {
        JLabel toolTipLabel = new JLabel();
        toolTipLabel.setLabelFor(this.descriptionText);
        toolTipLabel.setText(Constants.UI_TEXT.getProperty("argsTooltip"));
        toolTipLabel.setToolTipText(Constants.TOOLTIP.getProperty("argsTooltipTooltip", ""));
        final JTextArea toolTipText = FSRTheme.createFSRTextAreaField(this.arg.getTooltip(), 0, 0);
        toolTipText.setFont(this.nameText.getFont());
        toolTipText.setLineWrap(true);
        toolTipText.setWrapStyleWord(true);
        toolTipText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            private void updateLabel(DocumentEvent e) {
                ArgumentsPanel.this.arg.setTooltip(toolTipText.getText());
                if (!ArgumentsPanel.this.isConfigArgs) {
                    ArgumentsPanel.this.operationParent.isChanged = true;
                }
            }
        });
        this.argDescWrapPanel.add((Component)toolTipLabel, new GridConstraints(6, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.argDescWrapPanel.add((Component)toolTipText, new GridConstraints(6, 1, 1, 1, 8, 3, 2, 0, null, null, null));
    }

    private void createDescriptionField() {
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setLabelFor(this.descriptionText);
        this.descriptionLabel.setText(Constants.UI_TEXT.getProperty("argsDesc"));
        this.descriptionLabel.setToolTipText(Constants.TOOLTIP.getProperty("argsDescriptionTooltip", ""));
        this.descriptionText = FSRTheme.createFSRTextAreaField(this.arg.getDescription(), 0, 0);
        this.descriptionText.setFont(this.nameText.getFont());
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setWrapStyleWord(true);
        this.descriptionText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            private void updateLabel(DocumentEvent e) {
                ConnectorUtils.validateRequiredField(ArgumentsPanel.this.descriptionText, defaultBorderColor);
                ArgumentsPanel.this.arg.setDescription(ArgumentsPanel.this.descriptionText.getText());
                if (!ArgumentsPanel.this.isConfigArgs) {
                    ArgumentsPanel.this.operationParent.isChanged = true;
                }
            }
        });
        this.argDescWrapPanel.add((Component)this.descriptionLabel, new GridConstraints(7, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.argDescWrapPanel.add((Component)this.descriptionText, new GridConstraints(7, 1, 1, 1, 8, 3, 2, 0, new Dimension(100, 80), null, null));
    }

    private void createAttributeField() {
        this.checkBoxesWrapPanel = new JPanel();
        this.checkBoxesWrapPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.checkBoxesWrapPanel);
        this.attributesLabel = new JLabel(Constants.UI_TEXT.getProperty("argsAttributes"));
        this.checkBoxesWrapPanel.add((Component)this.attributesLabel, new GridConstraints(0, 0, 2, 1, 3, 3, 0, 0, null, null, null));
        this.isRequired = FSRTheme.createFSRCheckBox("argsAttributeRequired", "argsAttriRequiredTooltip", this.arg.getRequired());
        this.checkBoxesWrapPanel.add((Component)this.isRequired, new GridConstraints(0, 1, 1, 1, 8, 1, 1, 1, null, null, null));
        this.isRequired.addActionListener(e -> {
            AbstractButton abstractButton = (AbstractButton)e.getSource();
            boolean selected = abstractButton.getModel().isSelected();
            this.arg.setRequired(selected);
            if (!this.isConfigArgs) {
                this.operationParent.isChanged = true;
            }
        });
        this.isVisible = FSRTheme.createFSRCheckBox("argsAttributeVisible", "argsAttriVisibleTooltip", this.arg.getVisible());
        this.checkBoxesWrapPanel.add((Component)this.isVisible, new GridConstraints(0, 2, 1, 1, 8, 1, 1, 1, null, null, null));
        this.isVisible.addActionListener(e -> {
            AbstractButton abstractButton = (AbstractButton)e.getSource();
            boolean selected = abstractButton.getModel().isSelected();
            this.arg.setVisible(selected);
            if (!this.isConfigArgs) {
                this.operationParent.isChanged = true;
            }
        });
    }

    private void createDeleteButtonPanel() {
        this.deleteButtonPanel = new JPanel();
        this.deleteButtonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.deleteButtonPanel);
        this.deleteArgumentButton = FSRTheme.createFSRButton("argsDelete", "/icons/delete.png", "", this.getClass());
        this.deleteArgumentButton.addActionListener(e -> {
            if (this.isConfigArgs) {
                this.deleteConfigArgs();
            } else {
                this.deleteOperationArgs();
            }
            if (!this.isConfigArgs) {
                this.operationParent.isChanged = true;
            }
        });
        this.deleteButtonPanel.add((Component)this.deleteArgumentButton, new GridConstraints(0, 1, 1, 1, 4, 0, 1, 1, null, null, null));
    }

    private void deleteOperationArgs() {
        if (CommonUtils.askYesNoQuestion(String.format(Constants.POP_MESSAGE.getProperty("deleteArgsOperationConfirmationMessage"), this.arg.getTitle(), this.operation.getTitle()))) {
            this.operation.deleteParameter(this.arg);
            this.operationParent.repaintArguments();
            CommonUtils.showInfoMessage(String.format(Constants.POP_MESSAGE.getProperty("argsDeletedSuccess"), this.arg.getTitle()));
        }
    }

    private void deleteConfigArgs() {
        if (CommonUtils.askYesNoQuestion(String.format(Constants.POP_MESSAGE.getProperty("deleteConfigFieldsConnectorsConfirmationMessage"), this.arg.getTitle(), this.connector.getLabel()))) {
            this.connector.deleteParameter(this.arg);
            this.connectorParent.repaintArguments();
            this.connectorParent.scrollDownPanel();
            CommonUtils.showInfoMessage(String.format(Constants.POP_MESSAGE.getProperty("argsDeletedSuccess"), this.arg.getTitle()));
        }
    }

    public boolean validateRequiredField() {
        boolean flag = ConnectorUtils.validateRequiredField(this.nameText, defaultBorderColor);
        flag = ConnectorUtils.validateRequiredField(this.argsTitleText, defaultBorderColor) && flag;
        boolean bl = flag = ConnectorUtils.validateRequiredField(this.descriptionText, defaultBorderColor) && flag;
        if (this.arg.getType().equals("Select") || this.arg.getType().equals("Multiselect")) {
            flag = ConnectorUtils.validateRequiredField(this.optionsText, defaultBorderColor) && flag;
        }
        return flag;
    }
}

