/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui;

import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonPathInputDialog
extends DialogWrapper {
    public JTextField pythonPath;
    @NotNull
    private JPanel centerPanel;
    @NotNull
    private Project project;
    TextFieldWithBrowseButton pythonPathFileButton;

    public PythonPathInputDialog(@Nullable Project project, boolean canBeParent) {
        super(project, canBeParent);
        this.project = project;
        this.pythonPath = new JTextField(ConnectorUtils.getPythonPath(project));
        this.pythonPath.setBorder(LineBorder.createGrayLineBorder());
        this.centerPanel = new JPanel(new GridBagLayout());
        this.init();
        String pythonPathInputDialogTitle = "updatePythonPathTitle";
        if (ConnectorUtils.getPythonPath(project).isEmpty()) {
            pythonPathInputDialogTitle = "pythonPathTitle";
        }
        this.setTitle(Constants.POP_MESSAGE.getProperty(pythonPathInputDialogTitle));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.pythonPathFileButton = new TextFieldWithBrowseButton(this.pythonPath);
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        this.pythonPathFileButton.addBrowseFolderListener("Select Python File", "Select python file", this.project, fileChooserDescriptor);
        GridBag gridbag = new GridBag().setDefaultWeightX(1.0).setDefaultFill(2).setDefaultInsets(new Insets(0, 0, 5, 10));
        this.centerPanel.setMinimumSize(new Dimension(400, 100));
        this.centerPanel.add((Component)this.getLabel(Constants.UI_TEXT.getProperty("homePythonPathLabel")), gridbag.nextLine().next().weightx(0.2));
        this.centerPanel.add((Component)this.pythonPathFileButton, gridbag.next().weightx(0.8));
        return this.centerPanel;
    }

    private JComponent getLabel(String text) {
        JBLabel label = new JBLabel(text);
        label.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        label.setFontColor(UIUtil.FontColor.NORMAL);
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)2, (int)0));
        return label;
    }

    protected void doOKAction() {
        super.doOKAction();
    }
}

