/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui;

import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.IOUtils;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.InputEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.jdesktop.swingx.JXButton;

public class HomePanel
extends JPanel {
    private String newPythonPath;
    private final Project project;

    public HomePanel(Project project) {
        this.project = project;
        this.newPythonPath = ConnectorUtils.getPythonPath(project);
        this.setLayout((LayoutManager)new GridLayoutManager(10, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        JPanel emptyBlock = new JPanel();
        JPanel detailPanel = this.createDetailPanel();
        JPanel actionButtonPanel = this.createActionsPanel(project);
        FSRTheme.decorateBackground(this);
        FSRTheme.decorateBackground(detailPanel);
        FSRTheme.decorateBackground(actionButtonPanel);
        FSRTheme.decorateBackground(emptyBlock);
        this.add((Component)detailPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 500)));
        this.add((Component)actionButtonPanel, new GridConstraints(1, 0, 1, 1, 1, 3, 3, 3, null, null, new Dimension(500, 150)));
        this.add((Component)emptyBlock, new GridConstraints(3, 0, 1, 1, 1, 3, 3, 3, null, null, null));
    }

    private JPanel createDetailPanel() {
        JPanel detailPanel = new JPanel();
        detailPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("");
        titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(14.0f));
        detailPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        JLabel nameLabel = new JLabel(Constants.UI_TEXT.getProperty("homeBasicHeading"));
        nameLabel.setFont(titledBorder.getTitleFont().deriveFont(24.0f));
        FSRTheme.decorateLabel(nameLabel);
        String descriptionText = Constants.UI_TEXT.getProperty("homeBasicDesc");
        JTextArea descriptionField = new JTextArea(descriptionText);
        descriptionField.setName("descriptionField");
        descriptionField.setEditable(false);
        descriptionField.setOpaque(false);
        descriptionField.setFocusable(false);
        descriptionField.setLineWrap(true);
        descriptionField.setWrapStyleWord(true);
        detailPanel.add((Component)nameLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 2, 0, null, null, null));
        detailPanel.add((Component)descriptionField, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 0, null, null, null));
        return detailPanel;
    }

    private JPanel createActionsPanel(Project project) {
        JPanel actionButtonPanel = new JPanel();
        actionButtonPanel.setLayout((LayoutManager)new GridLayoutManager(8, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        TitledBorder actionTitledBorder = FSRTheme.createFSRTitleBorder("homeActionBorder");
        actionButtonPanel.setBorder(BorderFactory.createCompoundBorder(actionTitledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        JXButton newConnectorButton = FSRTheme.createFSRButton("homeBasicCreateNewConnectorAction", "/icons/add.png", "", this.getClass());
        newConnectorButton.addActionListener(e -> this.triggerNewConnectorAction());
        actionButtonPanel.add((Component)newConnectorButton, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JXButton importConnectorButton = FSRTheme.createFSRButton("homeBasicImportConnectorAction", "/icons/import.png", "", this.getClass());
        importConnectorButton.addActionListener(e -> IOUtils.importTgzAction(project, this));
        actionButtonPanel.add((Component)importConnectorButton, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        String pythonPathButtonName = "homeBasicUpdatePythonPath";
        if (ConnectorUtils.getPythonPath(project).isEmpty()) {
            pythonPathButtonName = "homeBasicConfigurePythonPath";
        }
        JXButton configurePythonPathButton = FSRTheme.createFSRButton(pythonPathButtonName, "/icons/python_configure.png", "", this.getClass());
        configurePythonPathButton.addActionListener(e -> {
            this.triggerPythonPathAction();
            if (!ConnectorUtils.getPythonPath(project).isEmpty()) {
                configurePythonPathButton.setText(Constants.UI_TEXT.getProperty("homeBasicUpdatePythonPath"));
            } else {
                configurePythonPathButton.setText(Constants.UI_TEXT.getProperty("homeBasicConfigurePythonPath"));
            }
        });
        actionButtonPanel.add((Component)configurePythonPathButton, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        return actionButtonPanel;
    }

    public void triggerNewConnectorAction() {
        AnAction newConnectorAction = ActionManager.getInstance().getAction("NewConnectorAction");
        if (newConnectorAction != null) {
            InputEvent inputEvent = ActionCommand.getInputEvent((String)"NewConnectorAction");
            ActionCallback actionCallback = ActionManager.getInstance().tryToExecute(newConnectorAction, inputEvent, null, null, true);
        }
    }

    public void triggerPythonPathAction() {
        AnAction pythonPathAction = ActionManager.getInstance().getAction("PythonPathAction");
        if (pythonPathAction != null) {
            InputEvent inputEvent = ActionCommand.getInputEvent((String)"PythonPathAction");
            ActionCallback actionCallback = ActionManager.getInstance().tryToExecute(pythonPathAction, inputEvent, null, null, true);
        }
    }
}

