/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui;

import com.fortinet.fortisoar.init.Initialize;
import com.fortinet.fortisoar.model.Connector;
import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.ui.CustomTabbedPane;
import com.fortinet.fortisoar.ui.HomePanel;
import com.fortinet.fortisoar.ui.connector.ConnectorDialog;
import com.fortinet.fortisoar.ui.connector.OperationsTabbedPane;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class FortiSOARToolWindow
implements ToolWindowFactory {
    private static Logger logger = Logger.getInstance(FortiSOARToolWindow.class);
    public CustomTabbedPane mainTabbedPane;
    public Project project;
    public String infoFilePath;
    private ToolWindow toolWindow;
    private boolean isChanged;
    private Connector connector;
    private String displayName;

    public void createToolWindowContent(@NotNull Project project, final @NotNull ToolWindow toolWindow) {
        if (project == null) {
            FortiSOARToolWindow.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            FortiSOARToolWindow.$$$reportNull$$$0(1);
        }
        logger.info("Create FortiSOAR tool window initialized.");
        this.project = project;
        Initialize.getInstance(project);
        this.toolWindow = toolWindow;
        this.createMainTabbed();
        MessageBusConnection msgBus = project.getMessageBus().connect((Disposable)project);
        msgBus.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(FileEditorManagerEvent event) {
                try {
                    if (toolWindow.isVisible()) {
                        FortiSOARToolWindow.this.reloadToolWindow(false);
                    }
                }
                catch (Exception e) {
                    logger.error("Reloading tool window failed.", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void reloadToolWindow(boolean force_reload) {
        Editor currEditor;
        if (force_reload) {
            this.infoFilePath = null;
            logger.info("Tool window force reload triggered.");
            this.resetToolWindow();
        }
        if ((currEditor = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor()) != null) {
            Document currentDoc = currEditor.getDocument();
            VirtualFile currentFile = FileDocumentManager.getInstance().getFile(currentDoc);
            String currentFileName = currentFile.getName();
            String operationName = FilenameUtils.removeExtension((String)currentFileName);
            File file = ConnectorUtils.findInfoFile(currentFile);
            if (file.exists()) {
                if (!file.getPath().equals(this.infoFilePath)) {
                    if (this.infoFilePath != null) {
                        if (CommonUtils.askYesNoQuestion(Constants.POP_MESSAGE.getProperty("changeConnectorConfirmationMsg"))) {
                            this.updateConnectorPanel(file);
                        }
                    } else {
                        this.updateConnectorPanel(file);
                    }
                }
                if (this.infoFilePath != null && this.connector != null && currentFile.getExtension().equals("py") && this.connector.checkOperation(operationName)) {
                    Operation operation = new Operation(operationName, this.infoFilePath, this.connector.infoContentObj);
                    ConnectorUtils.reloadOperationPanel(operation, (OperationsTabbedPane)this.mainTabbedPane.getComponentAt(3), this.project, 0);
                }
            } else if (force_reload) {
                this.resetToolWindow();
            }
        } else if (force_reload) {
            this.resetToolWindow();
        }
        if (this.isChanged) {
            this.updateToolWindow(this.toolWindow, this.mainTabbedPane, this.displayName);
            this.isChanged = false;
        }
    }

    public void updateConnectorPanel(File file) {
        try {
            this.infoFilePath = file.getPath();
            this.connector = new Connector(this.infoFilePath);
            this.reloadConnectorPanel();
            this.isChanged = true;
            this.displayName = this.connector.getName();
            logger.info(String.format("Connector panel updated. New Connector Name: %s", this.displayName));
        }
        catch (Exception ex) {
            logger.debug("Update connector panel failed.", (Throwable)ex);
        }
    }

    public void reloadConnectorPanel() {
        while (this.mainTabbedPane.getTabCount() > 1) {
            this.mainTabbedPane.remove(1);
        }
        ConnectorDialog connectorDialog = new ConnectorDialog(this.connector, this.project, this.mainTabbedPane);
        this.mainTabbedPane.setSelectedIndex(1);
    }

    public void updateToolWindow(ToolWindow toolWindow, JTabbedPane mainTabbedPane, String displayName) {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        toolWindow.getContentManager().removeAllContents(true);
        Content content = contentFactory.createContent((JComponent)mainTabbedPane, displayName, false);
        toolWindow.getContentManager().addContent(content);
        toolWindow.setTitleActions(this.reloadToolWindowAction());
    }

    public void createMainTabbed() {
        JBScrollPane home = this.createHomePanelScroll();
        this.mainTabbedPane = new CustomTabbedPane();
        this.mainTabbedPane.addTab("", IconLoader.getIcon((String)"/icons/home_teal.png", this.getClass()), (Component)home);
        this.isChanged = true;
        this.reloadToolWindow(false);
    }

    public List<AnAction> reloadToolWindowAction() {
        ArrayList<AnAction> actionList = new ArrayList<AnAction>();
        AnAction reload = new AnAction(IconLoader.getIcon((String)"/icons/refresh.png", this.getClass())){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (CommonUtils.askYesNoQuestion(Constants.POP_MESSAGE.getProperty("reloadConnectorConfirmationMsg"))) {
                    FortiSOARToolWindow.this.isChanged = true;
                    int currTab = FortiSOARToolWindow.this.mainTabbedPane.getSelectedIndex();
                    FortiSOARToolWindow.this.reloadToolWindow(true);
                    if (currTab <= FortiSOARToolWindow.this.mainTabbedPane.getTabCount()) {
                        FortiSOARToolWindow.this.mainTabbedPane.setSelectedIndex(currTab);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/fortinet/fortisoar/ui/FortiSOARToolWindow$2", "actionPerformed"));
            }
        };
        actionList.add(reload);
        return actionList;
    }

    private void resetToolWindow() {
        this.displayName = null;
        this.isChanged = true;
        while (this.mainTabbedPane.getTabCount() > 1) {
            this.mainTabbedPane.remove(1);
        }
        this.infoFilePath = null;
    }

    private JBScrollPane createHomePanelScroll() {
        HomePanel homePanel = new HomePanel(this.project);
        return new JBScrollPane((Component)homePanel, 20, 30);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "toolWindow";
                break;
            }
        }
        objectArray[1] = "com/fortinet/fortisoar/ui/FortiSOARToolWindow";
        objectArray[2] = "createToolWindowContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

