/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.model;

import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.IOUtils;
import com.fortinet.fortisoar.utils.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;

public class Connector {
    public String label;
    public String version;
    public String category;
    public Boolean cs_compatible;
    public Boolean cs_approved;
    public String publisher;
    public String description;
    public String help_online;
    public String icon_small_name;
    public String icon_large_name;
    public ArrayList<Argument> configuration_fields;
    public ArrayList<Operation> operations;
    public String infoFilePath;
    public JsonObject infoContentObj;
    private String name;

    public Connector(String infoFilePath) throws Exception {
        this.infoFilePath = infoFilePath;
        try {
            this.infoContentObj = JsonUtils.readJsonFile(infoFilePath);
            this.setName(this.infoContentObj.get("name"));
            this.setLabel(this.infoContentObj.get("label"));
            this.setVersion(this.infoContentObj.get("version"));
            this.setPublisher(this.infoContentObj.get("publisher"));
            this.setCategory(this.infoContentObj.get("category"));
            this.setDescription(this.infoContentObj.get("description"));
            this.setHelp_online(this.infoContentObj.get("help_online"));
            this.setCs_approved(this.infoContentObj.get("cs_approved"));
            this.setCs_compatible(this.infoContentObj.get("cs_compatible"));
            this.setIcon_small_name(this.infoContentObj.get("icon_small_name"));
            this.setIcon_large_name(this.infoContentObj.get("icon_large_name"));
            JsonObject configuration = new JsonObject();
            if (!this.infoContentObj.has("configuration")) {
                this.infoContentObj.add("configuration", (JsonElement)new JsonObject());
            }
            if (!(configuration = this.infoContentObj.getAsJsonObject("configuration")).has("fields")) {
                configuration.add("fields", (JsonElement)new JsonArray());
            }
            JsonArray fields = configuration.get("fields").getAsJsonArray();
            ArrayList<Argument> conf_fields = this.createArgumentsList(fields);
            this.setConfiguration_fields(conf_fields);
            JsonArray operationsArray = this.infoContentObj.getAsJsonArray("operations");
            ArrayList<Operation> operationsList = this.createOperationsList(operationsArray);
            this.setOperations(operationsList);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public ArrayList<Operation> createOperationsList(JsonArray operationsArray) {
        ArrayList<Operation> operationsList = new ArrayList<Operation>();
        for (int i = 0; i < operationsArray.size(); ++i) {
            JsonObject operationObj = operationsArray.get(i).getAsJsonObject();
            operationsList.add(this.createOperationObj(operationObj));
        }
        return operationsList;
    }

    public Operation createOperationObj(JsonObject operationObj) {
        JsonElement output_schema = operationObj.remove("output_schema");
        Gson gson = new Gson();
        Operation operation = (Operation)gson.fromJson((JsonElement)operationObj, Operation.class);
        operation.setInfoFilePath(this.infoFilePath);
        operation.setInfoContentObj(this.infoContentObj);
        operation.setOutput_schema(output_schema);
        operationObj.add("output_schema", output_schema);
        return operation;
    }

    public ArrayList<Argument> createArgumentsList(JsonArray parametersObj) {
        ArrayList<Argument> argumentsList = new ArrayList<Argument>();
        for (int i = 0; i < parametersObj.size(); ++i) {
            JsonObject paramObj = parametersObj.get(i).getAsJsonObject();
            argumentsList.add(this.createParamObj(paramObj));
        }
        return argumentsList;
    }

    public Argument createParamObj(JsonObject paramObj) {
        Gson gson = new Gson();
        Argument arg = (Argument)gson.fromJson((JsonElement)paramObj, Argument.class);
        return arg;
    }

    public ArrayList<Argument> getConfiguration_fields() {
        return this.configuration_fields;
    }

    public void setConfiguration_fields(ArrayList<Argument> configuration_fields) {
        this.configuration_fields = configuration_fields;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = CommonUtils.stringIsNotEmptyOrNull(name) != false ? name : "";
    }

    public void setName(JsonElement name) {
        this.name = name != null ? name.getAsString() : "";
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = CommonUtils.stringIsNotEmptyOrNull(label) != false ? label : "";
    }

    public void setLabel(JsonElement label) {
        this.label = label != null ? label.getAsString() : "";
    }

    public Boolean getCs_compatible() {
        return this.cs_compatible;
    }

    public void setCs_compatible(Boolean cs_compatible) {
        this.cs_compatible = CommonUtils.booleanIsNotEmptyOrNull(cs_compatible) != false ? cs_compatible : Boolean.valueOf(true);
    }

    public void setCs_compatible(JsonElement cs_compatible) {
        this.cs_compatible = cs_compatible != null && !Objects.equals(cs_compatible.getAsString(), "") ? Boolean.valueOf(cs_compatible.getAsBoolean()) : Boolean.valueOf(true);
    }

    public Boolean getCs_approved() {
        return this.cs_approved;
    }

    public void setCs_approved(Boolean cs_approved) {
        this.cs_approved = CommonUtils.booleanIsNotEmptyOrNull(cs_approved) != false ? cs_approved : Boolean.valueOf(false);
    }

    public void setCs_approved(JsonElement cs_approved) {
        this.cs_approved = cs_approved != null ? Boolean.valueOf(cs_approved.getAsBoolean()) : Boolean.valueOf(false);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = CommonUtils.stringIsNotEmptyOrNull(version) != false ? version : "1.0.0";
    }

    public void setVersion(JsonElement version) {
        this.version = version != null ? version.getAsString() : "1.0.0";
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = CommonUtils.stringIsNotEmptyOrNull(publisher) != false ? publisher : "Community";
    }

    public void setPublisher(JsonElement publisher) {
        this.publisher = publisher != null ? publisher.getAsString() : "Community";
    }

    public String getHelp_online() {
        return this.help_online;
    }

    public void setHelp_online(String help_online) {
        this.help_online = CommonUtils.stringIsNotEmptyOrNull(help_online) != false ? help_online : "";
    }

    public void setHelp_online(JsonElement help_online) {
        this.help_online = help_online != null ? help_online.getAsString() : "";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = CommonUtils.stringIsNotEmptyOrNull(description) != false ? description : "";
    }

    public void setDescription(JsonElement description) {
        this.description = description != null ? description.getAsString().strip() : "";
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = CommonUtils.stringIsNotEmptyOrNull(category) != false ? category : "";
    }

    public void setCategory(JsonElement category) {
        this.category = category != null ? category.getAsString() : "";
    }

    public String getIcon_small_name(Boolean absolutePath) {
        if (!absolutePath.booleanValue()) {
            try {
                Path path = Paths.get(this.icon_small_name, new String[0]);
                return path.getFileName().toString();
            }
            catch (Exception ex) {
                return this.icon_small_name;
            }
        }
        return this.icon_small_name;
    }

    public String getIcon_small_name() {
        return this.icon_small_name;
    }

    public void setIcon_small_name(String small_icon_name) {
        this.icon_small_name = CommonUtils.stringIsNotEmptyOrNull(small_icon_name) != false ? small_icon_name : "";
    }

    public void setIcon_small_name(JsonElement small_icon) {
        this.icon_small_name = small_icon != null ? small_icon.getAsString() : "";
    }

    public String getIcon_large_name() {
        return this.icon_large_name;
    }

    public void setIcon_large_name(String large_icon_name) {
        this.icon_large_name = CommonUtils.stringIsNotEmptyOrNull(large_icon_name) != false ? large_icon_name : "";
    }

    public void setIcon_large_name(JsonElement large_icon) {
        this.icon_large_name = large_icon != null ? large_icon.getAsString() : "";
    }

    public String getIcon_large_name(Boolean absolutePath) {
        if (!absolutePath.booleanValue()) {
            try {
                Path path = Paths.get(this.icon_large_name, new String[0]);
                return path.getFileName().toString();
            }
            catch (Exception ex) {
                return this.icon_large_name;
            }
        }
        return this.icon_large_name;
    }

    public String getInfoFilePath() {
        return this.infoFilePath;
    }

    public void save() throws Exception {
        Properties popMessage = Constants.POP_MESSAGE;
        try {
            if (!this.validateConnectorFields()) {
                throw new Exception("");
            }
            IOUtils.copyFile(this.getIcon_large_name(), this.infoFilePath);
            this.infoContentObj.addProperty("name", this.getName());
            this.infoContentObj.addProperty("label", this.getLabel());
            this.infoContentObj.addProperty("version", this.getVersion());
            this.infoContentObj.addProperty("description", this.getDescription());
            this.infoContentObj.addProperty("publisher", this.getPublisher());
            this.infoContentObj.addProperty("cs_approved", this.getCs_approved());
            this.infoContentObj.addProperty("cs_compatible", this.getCs_compatible());
            this.infoContentObj.addProperty("category", this.getCategory());
            this.infoContentObj.addProperty("help_online", this.getHelp_online());
            this.infoContentObj.addProperty("icon_small_name", this.getIcon_small_name(false));
            this.infoContentObj.addProperty("icon_large_name", this.getIcon_large_name(false));
            if (this.configuration_fields.size() == 0) {
                this.infoContentObj.add("configuration", (JsonElement)new JsonObject());
            }
            JsonUtils.writeInfoJsonFile(this.infoFilePath, this.infoContentObj);
            CommonUtils.showInfoMessage(popMessage.getProperty("saveSuccessMessage", "Saved Successfully!!!"));
        }
        catch (Exception ex) {
            CommonUtils.showErrorMessage(popMessage.getProperty("saveFailedMessage", "Saving Failed!!!\n") + ex.getMessage());
            throw new Exception(ex);
        }
    }

    public void saveConfig() throws Exception {
        Properties popMessage = Constants.POP_MESSAGE;
        try {
            if (!this.validateConfigurationFields()) {
                throw new Exception("");
            }
            JsonObject configObj = this.infoContentObj.get("configuration").getAsJsonObject();
            if (!configObj.has("fields")) {
                configObj.add("fields", (JsonElement)new JsonArray());
            }
            JsonArray prevFieldsArray = configObj.get("fields").getAsJsonArray();
            Gson gson = new GsonBuilder().create();
            JsonElement fieldsArray = gson.toJsonTree(this.configuration_fields);
            this.convertValues(fieldsArray.getAsJsonArray());
            JsonUtils.updateAllFields(prevFieldsArray, fieldsArray.getAsJsonArray());
            JsonUtils.writeInfoJsonFile(this.infoFilePath, this.infoContentObj);
            CommonUtils.showInfoMessage(popMessage.getProperty("saveSuccessMessage", "Saved Successfully!!!"));
        }
        catch (Exception ex) {
            CommonUtils.showErrorMessage(popMessage.getProperty("saveFailedMessage", "Saving Failed!!!\n") + ex.getMessage());
            throw new Exception(ex);
        }
    }

    public void deleteParameter(Argument arg) {
        this.configuration_fields.remove(arg);
    }

    public Argument addEmptyArg() {
        Argument arg = new Argument();
        this.configuration_fields.add(arg);
        return arg;
    }

    public String[] getOperationsList() {
        ArrayList<String> operationList = new ArrayList<String>();
        ArrayList<Operation> op = this.getOperations();
        for (Operation operation : op) {
            operationList.add(operation.getOperation());
        }
        return operationList.toArray(new String[0]);
    }

    public ArrayList<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(ArrayList<Operation> operations) {
        this.operations = operations;
    }

    public boolean checkOperation(String operationName) {
        for (Operation operation : this.operations) {
            String opName = operation.getName();
            if (!operationName.equals(opName)) continue;
            return true;
        }
        return false;
    }

    public void addNewOperation(String operationName, String operationLabel, String operationDescription) throws Exception {
        Operation newOperation = new Operation(operationName, operationLabel, operationDescription, this.infoFilePath, this.infoContentObj, true);
        this.operations.add(newOperation);
        this.saveNewOperation(newOperation);
    }

    private void saveNewOperation(Operation newOperation) throws Exception {
        try {
            JsonArray operationsObj = this.infoContentObj.get("operations").getAsJsonArray();
            JsonObject newOperationObj = JsonUtils.createOperationJsonObject(newOperation);
            operationsObj.add((JsonElement)newOperationObj);
            JsonUtils.writeInfoJsonFile(this.infoFilePath, this.infoContentObj);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public void deleteOperation(Operation operationDetail) {
        try {
            JsonArray operationsObj = this.infoContentObj.get("operations").getAsJsonArray();
            int index = this.findOperation(operationsObj, operationDetail.getOperation());
            if (index != -1) {
                operationsObj.remove(index);
            }
            JsonUtils.writeInfoJsonFile(this.infoFilePath, this.infoContentObj);
            String operationFileName = this.infoFilePath.replace("info.json", operationDetail.getOperation() + ".py");
            IOUtils.deleteFile(operationFileName);
        }
        catch (Exception e) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("errorWhileDeletingOperation"), e.getMessage()));
        }
        this.operations.remove(operationDetail);
    }

    public int findOperation(JsonArray operationsObj, String operationName) {
        int index = -1;
        for (int i = 0; i < operationsObj.size(); ++i) {
            if (!operationName.equals(operationsObj.get(i).getAsJsonObject().get("operation").getAsString())) continue;
            index = i;
            break;
        }
        return index;
    }

    public boolean validate() {
        return this.validateConnectorFields() && this.validateConfigurationFields();
    }

    public boolean validateConfigurationFields() {
        boolean flag = true;
        String errorMsg = "";
        for (Argument arg : this.configuration_fields) {
            String msg = arg.checkRequiredFields();
            if (msg.length() > 0) {
                flag = false;
                errorMsg = msg;
                break;
            }
            arg.removeEmptyFields();
        }
        if (errorMsg.length() > 0) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("invalidConfigurationFields"), errorMsg));
        }
        return flag;
    }

    public boolean validateConnectorFields() {
        Object errorMsg = "";
        if (this.getName().strip().length() == 0) {
            errorMsg = (String)errorMsg + Constants.POP_MESSAGE.getProperty("connectorNameRequiredFieldsMsg");
        }
        if (this.getLabel().strip().length() == 0) {
            errorMsg = (String)errorMsg + Constants.POP_MESSAGE.getProperty("connectorLabelRequiredFieldsMsg");
        }
        if (this.getVersion().strip().length() == 0) {
            errorMsg = (String)errorMsg + Constants.POP_MESSAGE.getProperty("connectorVersionRequiredFieldsMsg");
        } else if (!Constants.VERSION_REGEX.matcher(this.getVersion().strip()).find()) {
            errorMsg = (String)errorMsg + Constants.POP_MESSAGE.getProperty("connectorVersionInvalidMsg");
        }
        if (this.getDescription().strip().length() == 0) {
            errorMsg = (String)errorMsg + Constants.POP_MESSAGE.getProperty("connectorDescriptionRequiredFieldsMsg");
        }
        if (((String)errorMsg).length() > 0) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("invalidConnectorDetailsFields"), errorMsg));
            return false;
        }
        return true;
    }

    public void convertValues(JsonArray fieldsArray) {
        for (int i = 0; i < fieldsArray.size(); ++i) {
            JsonObject fields = fieldsArray.get(i).getAsJsonObject();
            JsonUtils.convertJsonValueObjectIntoTheirRespectiveType(fields);
        }
    }
}

