/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.utils;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.Nullable;

public class FortiSOARTerminalUtil {
    public static final String CUSTOM_CONSOLE = "FortiSOAR Terminal";
    public static String DISPLAY_NAME = "";

    @Nullable
    public static Content getConsoleViewContent(Project project) {
        if (project == null) {
            return null;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(CUSTOM_CONSOLE);
        if (toolWindow == null) {
            return null;
        }
        Content consoleViewContent = FortiSOARTerminalUtil.getExistingConsoleViewContent(toolWindow);
        if (consoleViewContent != null) {
            consoleViewContent.setDisplayName(DISPLAY_NAME);
            return consoleViewContent;
        }
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        Content newContent = toolWindow.getContentManager().getFactory().createContent(consoleView.getComponent(), DISPLAY_NAME, true);
        toolWindow.getContentManager().addContent(newContent);
        return newContent;
    }

    @Nullable
    static Content getExistingConsoleViewContent(ToolWindow toolWindow) {
        ContentManager contentManager = toolWindow.getContentManager();
        return contentManager.findContent(DISPLAY_NAME);
    }

    public static void activateConsoleView(Project project, String displayName) {
        DISPLAY_NAME = displayName;
        Content content = FortiSOARTerminalUtil.getConsoleViewContent(project);
        ToolWindow toolWindow = FortiSOARTerminalUtil.getToolWindow(project);
        if (content != null && toolWindow != null) {
            toolWindow.show();
            toolWindow.getContentManager().setSelectedContent(content);
        }
    }

    @Nullable
    static ToolWindow getToolWindow(Project project) {
        if (project == null || project.isDisposed()) {
            return null;
        }
        return ToolWindowManager.getInstance((Project)project).getToolWindow(CUSTOM_CONSOLE);
    }
}

