/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.utils;

import com.fortinet.fortisoar.execution.FortiRunConfiguration;
import com.fortinet.fortisoar.execution.FortiRunConfigurationType;
import com.fortinet.fortisoar.init.ConfigReader;
import com.fortinet.fortisoar.model.Connector;
import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.ui.FortiSOARToolWindow;
import com.fortinet.fortisoar.ui.connector.OperationsTabbedPane;
import com.fortinet.fortisoar.ui.operation.CloseButtonPanel;
import com.fortinet.fortisoar.ui.operation.OperationDialog;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.FortiSOARTerminalUtil;
import com.fortinet.fortisoar.utils.IOUtils;
import com.fortinet.fortisoar.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectorUtils {
    public static final Logger logger = Logger.getInstance(ConnectorUtils.class);

    public static void createNewOperationFile(Project project, Connector connectorDetail, String operationName, String operationLabel, String operationDescription, String operationEndpoint, String operationMethod) {
        String operationFileName = Paths.get(connectorDetail.getInfoFilePath(), new String[0]).getParent().toString() + "/" + operationName + ".py";
        logger.info(String.format("Create new operation file triggered. Info File Path: %s; Connector Name: %s; Operation Name: %s; Operation File Path: %s", connectorDetail.getInfoFilePath(), connectorDetail.getName(), operationName, operationFileName));
        File file = new File(FilenameUtils.normalize((String)operationFileName));
        if (!file.exists()) {
            try {
                file.createNewFile();
                Map configYml = ConfigReader.configYML;
                Map fileContents = (Map)configYml.get("file_contents");
                String content = fileContents.get("new_operation_template").toString();
                IOUtils.writeStringToFile(file.getPath(), String.format(content, operationName, operationEndpoint, operationMethod));
            }
            catch (Exception ex) {
                logger.error("Unable to complete create new operation file action. Error: " + ex.getMessage());
            }
        }
        ConnectorUtils.createOperationUnitTestFile(connectorDetail.getInfoFilePath(), connectorDetail.getName(), operationName);
        IOUtils.reloadFromDisk(project);
        ConnectorUtils.openFile(project, operationFileName);
    }

    public static void createOperationUnitTestFile(String infoFilePath, String connectorName, String operationName) {
        Path connectorParent = Paths.get(infoFilePath, new String[0]).getParent().getParent();
        String operationTestFileName = Paths.get(connectorParent.toString(), String.format("tests/test_%s.py", operationName)).toString();
        logger.info(String.format("Create new operation test file triggered. File: %s", operationTestFileName));
        File testFile = new File(FilenameUtils.normalize((String)operationTestFileName));
        if (!testFile.exists()) {
            try {
                testFile.createNewFile();
                Map configYml = ConfigReader.configYML;
                Map fileContents = (Map)configYml.get("file_contents");
                String content = fileContents.get("unit_test_template").toString();
                IOUtils.writeStringToFile(testFile.getPath(), String.format(content, connectorName, operationName));
            }
            catch (Exception ioException) {
                logger.error(String.format("Create new operation test file failed. Error: %s", ioException.getMessage()));
            }
        }
    }

    public static JsonElement createOutputSchema(String output_schema) {
        return JsonParser.parseString((String)output_schema);
    }

    public static void generateOperationPyFile(String operationFile, String[] operationList) {
        logger.info("Regenerate \"operations.py\" triggered.");
        StringBuilder content = new StringBuilder("\"\"\"\nThis file will be auto-generated on each \"new operation action\", so avoid editing in this file.\n\"\"\"\n\n\n");
        for (String s : operationList) {
            content.append(String.format("from .%s import %s\n", s, s));
        }
        content.append("\n\n\n");
        content.append("operations = {\n");
        for (String s : operationList) {
            content.append(String.format("    \"%s\": %s,\n", s, s));
        }
        content.append("}\n");
        IOUtils.writeStringToFile(operationFile.replace("file:", ""), content.toString());
    }

    public static boolean validateRequiredField(JTextField inputField, Color defaultColor) {
        if (inputField.getText().strip().length() == 0) {
            inputField.setBorder(BorderFactory.createLineBorder(Color.red));
            return false;
        }
        inputField.setBorder(BorderFactory.createLineBorder(defaultColor));
        return true;
    }

    public static boolean validateRequiredField(JTextArea inputField, Color defaultColor) {
        if (inputField.getText().strip().length() == 0) {
            inputField.setBorder(BorderFactory.createLineBorder(Color.red));
            return false;
        }
        inputField.setBorder(BorderFactory.createLineBorder(defaultColor));
        return true;
    }

    public static boolean validateRequiredField(ComboBox inputField, Color defaultColor) {
        if (inputField.getSelectedItem() == null || Objects.requireNonNull(inputField.getSelectedItem()).toString().strip().length() == 0) {
            inputField.setBorder(BorderFactory.createLineBorder(Color.red));
            return false;
        }
        inputField.setBorder(BorderFactory.createLineBorder(defaultColor));
        return true;
    }

    public static boolean validateVersionTextField(JTextField version, Color defaultColor) {
        if (version.getText().strip().length() == 0 || !Constants.VERSION_REGEX.matcher(version.getText().strip()).find()) {
            version.setBorder(BorderFactory.createLineBorder(Color.red));
            return false;
        }
        version.setBorder(BorderFactory.createLineBorder(defaultColor));
        return true;
    }

    public static void runPlaybookGenerationScript(Project project, String infoFilePath) {
        logger.info(String.format("Generate sample playbooks action triggered. Info File Path: %s", infoFilePath));
        Properties popMessage = Constants.POP_MESSAGE;
        String pythonPath = ConnectorUtils.getPythonPath(project);
        try {
            if (!CommonUtils.isValidPythonPath(pythonPath)) {
                return;
            }
            String[] commands = new String[]{pythonPath, "-m", "connectors.scripts.generate_sample_playbook", "--connector-info", infoFilePath};
            String output = ConnectorUtils.invokePythonScript(List.of(commands));
            if (output.strip().length() == 0) {
                CommonUtils.showInfoMessage(popMessage.getProperty("playbookGeneratedSuccess"));
            } else {
                logger.debug(String.format("Generate sample playbook Python script failed with following error: %s", output));
                CommonUtils.showErrorMessage(String.format(popMessage.getProperty("playbookGeneratedFailed"), output));
            }
        }
        catch (Exception ex) {
            logger.error("Generate sample playbook action failed.", (Throwable)ex);
            CommonUtils.showErrorMessage(String.format(popMessage.getProperty("playbookGeneratedFailed"), ex.getMessage()));
        }
    }

    public static void runDocsGenerationScript(Project project, String infoFilePath) {
        logger.info(String.format("Generate document action triggered. Info File Path: %s", infoFilePath));
        Properties popMessage = Constants.POP_MESSAGE;
        String pythonPath = ConnectorUtils.getPythonPath(project);
        try {
            if (!CommonUtils.isValidPythonPath(pythonPath) || !CommonUtils.askYesNoQuestion("Make sure you have successfully generated the sample playbook.\nDo you want to continue?")) {
                return;
            }
            String outputPath = Paths.get(Paths.get(infoFilePath, new String[0]).getParent().getParent().toString(), "docs").toString();
            String[] commands = new String[]{pythonPath, "-m", "connectors.scripts.generate_document", "--connector-info", infoFilePath, "--output-path", outputPath};
            String output = ConnectorUtils.invokePythonScript(List.of(commands));
            if (output.strip().length() == 0) {
                CommonUtils.showInfoMessage(String.format(popMessage.getProperty("docsGeneratedSuccess"), outputPath));
            } else {
                logger.debug("Generate docs python script failed with following error: %s", new Object[]{output});
                CommonUtils.showErrorMessage(String.format(popMessage.getProperty("docsGeneratedFailed"), output));
            }
            IOUtils.reloadFromDisk(project);
        }
        catch (Exception ex) {
            logger.error("Generate document action failed.", (Throwable)ex);
            CommonUtils.showErrorMessage(String.format(popMessage.getProperty("docsGeneratedFailed"), ex.getMessage()));
        }
    }

    public static void runConnectorInspectScript(Project project, String infoFilePath) {
        logger.info(String.format("Generate connector inspect action triggered. Info File Path: %s", infoFilePath));
        Properties popMessage = Constants.POP_MESSAGE;
        String pythonPath = ConnectorUtils.getPythonPath(project);
        try {
            if (!CommonUtils.isValidPythonPath(pythonPath)) {
                return;
            }
            String outputPath = Paths.get(Paths.get(infoFilePath, new String[0]).getParent().getParent().toString(), "connector-inspect").toString();
            String[] commands = new String[]{pythonPath, "-m", "connectors.scripts.generate_connector_inspect", "--connector-info", infoFilePath, "--output-path", outputPath};
            String output = ConnectorUtils.invokePythonScript(List.of(commands));
            if (output.strip().length() == 0) {
                CommonUtils.showInfoMessage(String.format(popMessage.getProperty("connectorInspectGeneratedSuccess"), outputPath));
            } else {
                logger.debug("Generate connector inspect python script failed with following error: %s", new Object[]{output});
                CommonUtils.showErrorMessage(String.format(popMessage.getProperty("connectorInspectGeneratedFailed"), output));
            }
            IOUtils.reloadFromDisk(project);
        }
        catch (Exception ex) {
            logger.error("Generate connector inspect action failed.", (Throwable)ex);
            CommonUtils.showErrorMessage(String.format(popMessage.getProperty("connectorInspectGeneratedFailed"), ex.getMessage()));
        }
    }

    public static String invokePythonScript(List<String> commands) {
        logger.info(String.format("Invoke python script triggered. Commands: %s", commands));
        StringBuilder output = new StringBuilder();
        try {
            ProcessBuilder pb = new ProcessBuilder(commands);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String s = null;
            while ((s = stdInput.readLine()) != null) {
                output.append(s);
            }
        }
        catch (IOException ioException) {
            logger.error("Invoke python script failed.", (Throwable)ioException);
        }
        return output.toString();
    }

    public static ColoredProcessHandler createFortiSOARTerminal(Project project, List<String> commands, String displayName, String initialText, boolean showInTerminal) {
        logger.info(String.format("Create FortiSOAR Terminal triggered with following commands: %S", commands));
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(commands);
        generalCommandLine.setCharset(StandardCharsets.UTF_8);
        generalCommandLine.setWorkDirectory(project.getBasePath());
        ColoredProcessHandler processHandler = null;
        try {
            processHandler = new ColoredProcessHandler(generalCommandLine);
        }
        catch (ExecutionException ex) {
            logger.error("Process Handler creation failed.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        processHandler.startNotify();
        if (showInTerminal) {
            FortiSOARTerminalUtil.activateConsoleView(project, displayName);
            Content content = FortiSOARTerminalUtil.getConsoleViewContent(project);
            assert (content != null);
            ConsoleView console = (ConsoleView)content.getComponent();
            console.print(String.format("Commands: %s\n", commands), ConsoleViewContentType.SYSTEM_OUTPUT);
            console.print(initialText, ConsoleViewContentType.LOG_INFO_OUTPUT);
            console.attachToProcess((ProcessHandler)processHandler);
            console.requestScrollingToEnd();
        }
        return processHandler;
    }

    public static void openConnectorFile(PsiDirectory connectorDir, Project project) {
        try {
            @Nullable PsiFile infoFile = connectorDir.findFile("info.json");
            @NonNls @NotNull String infoFilePath = infoFile.getVirtualFile().getPath();
            ConnectorUtils.openFile(project, infoFilePath);
        }
        catch (Exception ex) {
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("fileNotFound"));
            logger.debug(String.format("Open connector info.json failed. Error: %s", ex.getMessage()));
        }
    }

    public static void openOperationFile(Operation operationDetail, OperationsTabbedPane mainTabbedPane, Project project, int defaultTabIndex) {
        try {
            String operationFileName = Paths.get(operationDetail.getInfoFilePath(), new String[0]).getParent().toString() + "/" + operationDetail.getOperation() + ".py";
            ConnectorUtils.openFile(project, operationFileName);
            ConnectorUtils.reloadOperationPanel(operationDetail, mainTabbedPane, project, defaultTabIndex);
        }
        catch (Exception ex) {
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("operationFileNotFound") + ex.getMessage());
            logger.debug(String.format("Open operation file failed. Error: %s", ex.getMessage()));
        }
    }

    private static void openFile(Project project, String filePath) {
        try {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
            if (file != null) {
                FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file, 0), true);
            }
        }
        catch (Exception ex) {
            logger.debug(String.format("Open file in editor failed. Error: %s", ex.getMessage()));
        }
    }

    public static File findInfoFile(VirtualFile currentFile) {
        VirtualFile currDir = currentFile.getParent();
        String currDirName = currDir.getPath();
        String infoFilePath = currDirName.concat("/info.json");
        File file = new File(infoFilePath);
        if (!file.exists()) {
            String parentDirName = currDir.getParent().getPath();
            infoFilePath = parentDirName.concat("/info.json");
            file = new File(infoFilePath);
        }
        return file;
    }

    public static void reloadOperationPanel(Operation operation, OperationsTabbedPane operationsTabbedPane, Project project, int defaultTabIndex) {
        String operationName = operation.getOperation();
        int tabIndex = ConnectorUtils.findIndexOfOperationTab(operationsTabbedPane, operationName);
        if (tabIndex == -1) {
            tabIndex = operationsTabbedPane.getTabCount();
            CloseButtonPanel closeButtonPanel = new CloseButtonPanel(operationsTabbedPane, operationName);
            OperationDialog operationDialog = new OperationDialog(operation, project);
            operationDialog.setSelectedIndex(defaultTabIndex);
            operationsTabbedPane.addTab(operationName, (Component)((Object)operationDialog));
            operationsTabbedPane.setTabComponentAt(tabIndex, closeButtonPanel);
        } else {
            OperationDialog operationDialog = (OperationDialog)((Object)operationsTabbedPane.getComponentAt(tabIndex));
            operationDialog.setSelectedIndex(defaultTabIndex);
        }
        operationsTabbedPane.setSelectedIndex(tabIndex);
    }

    private static int findIndexOfOperationTab(JTabbedPane operationTabbedPane, String name) {
        int index = -1;
        for (int i = 0; i < operationTabbedPane.getTabCount(); ++i) {
            if (!operationTabbedPane.getTitleAt(i).equals(name)) continue;
            index = i;
            break;
        }
        return index;
    }

    public static void setupPythonEnv(Project project, String pythonPath, boolean showOutput) {
        IOUtils.copyResources(project, FortiSOARToolWindow.class);
        String library_path = project.getBasePath() + Constants.FORTISOAR_CONNECTOR_ENGINE_LIBRARY_PATH;
        Object[] commands = new String[]{pythonPath, "-m", "pip", "install", library_path, "--force-reinstall"};
        logger.info(String.format("Setup python environment triggered with following commands: %s", Arrays.toString(commands)));
        ColoredProcessHandler process = ConnectorUtils.createFortiSOARTerminal(project, List.of(commands), "Setup", "", showOutput);
        CompletableFuture.runAsync(() -> {
            process.waitFor();
            IOUtils.deleteResources(project);
        });
    }

    public static void testConnectorAllActions(Project project, String infoFilePath, String connectorName) {
        String pythonPath = ConnectorUtils.getPythonPath(project);
        if (CommonUtils.isValidPythonPath(pythonPath)) {
            String initialText = String.format("Connector: %s\nOperation: All\n", connectorName);
            String testScope = Paths.get(Paths.get(infoFilePath, new String[0]).getParent().getParent().toString(), "tests").toString();
            String[] commands = new String[]{pythonPath, "-m", "pytest", "--no-header", "--color=yes", "-v", testScope};
            String tabName = connectorName + " > test_all";
            ConnectorUtils.createFortiSOARTerminal(project, List.of(commands), tabName, initialText, true);
        }
    }

    public static void testOperationAction(Project project, String infoFilePath, String operationName, String connectorName) {
        String pythonPath = ConnectorUtils.getPythonPath(project);
        if (CommonUtils.isValidPythonPath(pythonPath)) {
            String initialText = String.format("Connector: %s\nOperation: %s\n", connectorName, operationName);
            String testScope = Paths.get(Paths.get(infoFilePath, new String[0]).getParent().getParent().toString(), String.format("tests/test_%s.py", operationName)).toString();
            String[] commands = new String[]{pythonPath, "-m", "pytest", "--no-header", "--color=yes", "-v", testScope};
            String tabName = String.format("%s > test_%s.py", connectorName, operationName);
            ConnectorUtils.openFile(project, testScope);
            ConnectorUtils.createFortiSOARTerminal(project, List.of(commands), tabName, initialText, true);
        }
    }

    public static void runOperationAction(Project project, String infoFilePath, String configName, String operationName) {
        String pythonPath = ConnectorUtils.getPythonPath(project);
        if (CommonUtils.isValidPythonPath(pythonPath)) {
            Path infoFile = Paths.get(infoFilePath, new String[0]);
            Path connectorPath = infoFile.getParent();
            String connectorName = String.valueOf(connectorPath.getFileName());
            String localDataPath = Paths.get(project.getBasePath(), "/.fortisoar/local_data.json").toString();
            String inLineCommands = "-m %s --connector-path %s --connector-name %s --operation-name %s --config-name %s --local-data-path %s";
            inLineCommands = String.format(inLineCommands, "connectors.scripts.execute_operation", connectorPath, connectorName, operationName, configName, localDataPath);
            ConnectorUtils.executeFortiRunConfig(project, connectorName, operationName, inLineCommands);
            String[] commands = new String[]{pythonPath, "-m", "connectors.scripts.execute_operation", "--connector-path", connectorPath.toString(), "--connector-name", connectorName, "--config-name", configName, "--operation-name", operationName, "--local-data-path", localDataPath};
            ConnectorUtils.createFortiSOARTerminal(project, List.of(commands), operationName, "", true);
        }
    }

    public static void setPythonPath(Project project, String pythonPath, boolean showOutput) {
        File file = new File(pythonPath);
        if (file.exists() && file.canExecute()) {
            ConnectorUtils.setupPythonEnv(project, pythonPath, showOutput);
            ConnectorUtils.savePythonPath(project, pythonPath);
            logger.info(String.format("PYTHON_PATH updated to: %s", pythonPath));
        } else if (showOutput) {
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("pythonPathIsNotValid"));
        }
    }

    public static void installConnectorRequirements(Project project, String infoFilePath) {
        String pythonPath = ConnectorUtils.getPythonPath(project);
        if (CommonUtils.isValidPythonPath(pythonPath)) {
            String requirementsPath = infoFilePath.replace("info.json", "requirements.txt");
            String[] commands = new String[]{pythonPath, "-m", "pip", "install", "-r", requirementsPath};
            String initialText = String.format("Requirements Path: %s\n", requirementsPath);
            ConnectorUtils.createFortiSOARTerminal(project, List.of(commands), "Requirements", initialText, true);
        }
    }

    public static void executeFortiRunConfig(Project project, String connectorName, String operationName, String commands) {
        RunManager runManager = RunManager.getInstance((Project)project);
        List runnerAndConfigList = runManager.getConfigurationSettingsList(FortiRunConfigurationType.class);
        RunnerAndConfigurationSettings runnerAndConfig = runnerAndConfigList.size() < 1 ? ConnectorUtils.createNewRunnerAndConfigSettings(project) : (RunnerAndConfigurationSettings)runnerAndConfigList.get(0);
        runManager.addConfiguration(runnerAndConfig);
        runManager.setSelectedConfiguration(runnerAndConfig);
        ConnectorUtils.updateRunnerAndConfigSettings(project, runnerAndConfig, connectorName, operationName, commands);
    }

    public static RunnerAndConfigurationSettings createNewRunnerAndConfigSettings(Project project) {
        ConfigurationType type = ConfigurationTypeUtil.findConfigurationType((String)"FortiRunConfiguration");
        ConfigurationFactory[] factories = type.getConfigurationFactories();
        RunnerAndConfigurationSettings racs = RunManager.getInstance((Project)project).createConfiguration("testConfig", factories[0]);
        RunManager.getInstance((Project)project).addConfiguration(racs);
        RunManager.getInstance((Project)project).setSelectedConfiguration(racs);
        return racs;
    }

    public static void updateRunnerAndConfigSettings(Project project, RunnerAndConfigurationSettings runnerAndConfig, String connectorName, String operationName, String commands) {
        runnerAndConfig.setName(String.format("%s > %s", connectorName, operationName));
        @NotNull FortiRunConfiguration config = (FortiRunConfiguration)runnerAndConfig.getConfiguration();
        config.setScriptName(ConnectorUtils.getPythonPath(project));
        config.setCommands(commands);
    }

    public static void savePythonPath(Project project, String pythonPath) {
        String localDataFilePath = Paths.get(Objects.requireNonNull(project.getBasePath()), "/.fortisoar/local_data.json").toString();
        JsonUtils.createLocalDataFileIfNotFound(localDataFilePath);
        JsonObject localData = JsonUtils.readJsonFile(localDataFilePath);
        localData.addProperty("PYTHON_PATH", pythonPath);
        JsonUtils.writeInfoJsonFile(localDataFilePath, localData);
    }

    public static String getPythonPath(Project project) {
        String pythonPath;
        String localDataFilePath = Paths.get(Objects.requireNonNull(project.getBasePath()), "/.fortisoar/local_data.json").toString();
        JsonUtils.createLocalDataFileIfNotFound(localDataFilePath);
        JsonObject localData = JsonUtils.readJsonFile(localDataFilePath);
        if (!localData.has("PYTHON_PATH")) {
            localData.addProperty("PYTHON_PATH", "");
        }
        if (!CommonUtils.stringIsNotEmptyOrNull(pythonPath = localData.get("PYTHON_PATH").getAsString()).booleanValue()) {
            Path defaultPythonPath1 = Paths.get(project.getBasePath(), "env/bin/python");
            Path defaultPythonPath2 = Paths.get(project.getBasePath(), "venv/bin/python");
            Path defaultPythonPath3 = Paths.get(project.getBasePath(), "venv/Scripts/python.exe");
            Path defaultPythonPath4 = Paths.get(project.getBasePath(), "env/Scripts/python.exe");
            if (ConnectorUtils.checkPythonPath(defaultPythonPath1)) {
                pythonPath = defaultPythonPath1.toString();
            } else if (ConnectorUtils.checkPythonPath(defaultPythonPath2)) {
                pythonPath = defaultPythonPath2.toString();
            } else if (ConnectorUtils.checkPythonPath(defaultPythonPath3)) {
                pythonPath = defaultPythonPath3.toString();
            } else if (ConnectorUtils.checkPythonPath(defaultPythonPath4)) {
                pythonPath = defaultPythonPath4.toString();
            }
        }
        return pythonPath;
    }

    public static boolean checkPythonPath(Path pythonPath) {
        File defaultPythonFile = new File(pythonPath.toString());
        return defaultPythonFile.exists() && defaultPythonFile.canExecute();
    }

    public static ColoredProcessHandler captureOutputSchema(Project project, String infoFilePath, String configName, String operationName) {
        String pythonPath = ConnectorUtils.getPythonPath(project);
        if (CommonUtils.isValidPythonPath(pythonPath)) {
            Path infoFile = Paths.get(infoFilePath, new String[0]);
            Path connectorPath = infoFile.getParent();
            String connectorName = String.valueOf(connectorPath.getFileName());
            String localDataPath = Paths.get(Objects.requireNonNull(project.getBasePath()), "/.fortisoar/local_data.json").toString();
            String[] commands = new String[]{pythonPath, "-m", "connectors.scripts.capture_output_schema", "--connector-path", connectorPath.toString(), "--connector-name", connectorName, "--config-name", configName, "--operation-name", operationName, "--local-data-path", localDataPath};
            ColoredProcessHandler process = ConnectorUtils.createFortiSOARTerminal(project, List.of(commands), operationName, "", true);
            return process;
        }
        return null;
    }
}

