/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.operation;

import com.fortinet.fortisoar.init.PropReader;
import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.model.Operation;
import com.fortinet.fortisoar.ui.CommonUIFields;
import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.operation.ArgumentsPanel;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import org.jdesktop.swingx.JXButton;

public class ExecutionPanel
extends JPanel {
    private static final Logger logger = Logger.getInstance(ExecutionPanel.class);
    private final Operation operation;
    private final Project project;
    public ArrayList<String> requiredFields = new ArrayList();
    public HashMap<String, Object> allInputFields = new HashMap();
    private JPanel inputFieldPanel;
    private JBScrollPane inputFieldScrollPane;
    private JPanel buttonPanel;
    private JPanel outputSchemaScrollPane;
    private JBScrollPane outputSchemaScrollable;
    private JTextArea outputSchemaField;
    private JsonObject paramsData;
    private JsonObject outputSchemaData;
    private JsonObject localData;
    private String localDataFilePath;
    private ComboBox selectConfigField;
    private String[] allConfigOptions;
    private JPanel configPanel;
    private JPanel executePanel;

    public ExecutionPanel(Project project, Operation operation) {
        assert (project != null);
        this.project = project;
        this.operation = operation;
        this.setLayout((LayoutManager)new GridLayoutManager(20, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        this.readLocalData();
        this.createExecutePanel();
        this.outputSchemaScrollPane = this.createOutputPanel();
        this.outputSchemaScrollable = new JBScrollPane((Component)this.outputSchemaScrollPane, 20, 30);
        this.add((Component)this.executePanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.add((Component)this.outputSchemaScrollable, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 10000)));
        FSRTheme.decorateBackground(this);
    }

    private void createExecutePanel() {
        this.createSelectConfigPanel();
        this.createInputFieldScrollPane();
        this.createButtonPanel();
        this.executePanel = new JPanel();
        this.executePanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.executePanel);
        this.executePanel.add((Component)this.configPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.executePanel.add((Component)this.inputFieldScrollPane, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.executePanel.add((Component)this.buttonPanel, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.buttonPanel);
        JXButton runButton = FSRTheme.createFSRButton("runExecuteButton", "/icons/run.png", "", this.getClass());
        runButton.addActionListener(e -> {
            if (this.validateRequiredFields()) {
                this.executeActions();
            }
        });
        JXButton reloadButton = FSRTheme.createFSRButton("resetExecuteButton", "/icons/refresh.png", "operationResetTooltip", this.getClass());
        reloadButton.addActionListener(e -> this.reloadFields());
        JXButton saveButton = FSRTheme.createFSRSaveButton("saveExecuteButton", "/icons/save.png", this.getClass());
        saveButton.addActionListener(e -> this.saveParamsFields(true));
        this.buttonPanel.add((Component)runButton, new GridConstraints(0, 0, 1, 1, 6, 0, 3, 3, null, null, null));
        this.buttonPanel.add((Component)reloadButton, new GridConstraints(0, 1, 1, 1, 6, 0, 3, 3, null, null, null));
        this.buttonPanel.add((Component)saveButton, new GridConstraints(0, 2, 1, 1, 6, 0, 3, 3, null, null, null));
    }

    private void createInputFieldScrollPane() {
        this.createInputFieldPanel();
        this.inputFieldScrollPane = new JBScrollPane((Component)this.inputFieldPanel, 20, 30);
    }

    private void createInputFieldPanel() {
        ArrayList<Argument> parameters = this.operation.getParameters();
        this.inputFieldPanel = new JPanel();
        TitledBorder titledBorder = FSRTheme.createFSRTitleBorder("executeInputFieldsBorder");
        this.inputFieldPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        FSRTheme.decorateBackground(this.inputFieldPanel);
        this.inputFieldPanel.setLayout((LayoutManager)new GridLayoutManager(parameters.size() + 1, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        for (int i = 0; i < parameters.size(); ++i) {
            this.addInputField(parameters.get(i), i + 1);
        }
    }

    private JPanel createOutputPanel() {
        JPanel outputPanel = new JPanel();
        outputPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        TitledBorder outputTitledBorder = FSRTheme.createFSRTitleBorder("executeCaptureOutputSchemaFieldsBorder");
        outputPanel.setBorder(BorderFactory.createCompoundBorder(outputTitledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        outputPanel.setToolTipText(Constants.TOOLTIP.getProperty("opOutputSchema", ""));
        FSRTheme.decorateBackground(outputPanel);
        JBScrollPane outputScrollPane = new JBScrollPane();
        this.outputSchemaField = new JTextArea(JsonUtils.convertToJsonPrettyString((JsonElement)this.outputSchemaData), 1, 1);
        FSRTheme.decorateInputField(this.outputSchemaField);
        final JTextArea lines = new JTextArea();
        lines.setBackground((Color)JBColor.LIGHT_GRAY);
        lines.setForeground((Color)JBColor.BLACK);
        lines.setEditable(false);
        int caretPosition = this.outputSchemaField.getDocument().getLength();
        Element root = this.outputSchemaField.getDocument().getDefaultRootElement();
        StringBuilder text = new StringBuilder("1" + System.getProperty("line.separator"));
        for (int i = 2; i < root.getElementIndex(caretPosition) + 2; ++i) {
            text.append(i).append(System.getProperty("line.separator"));
        }
        lines.setText(text.toString());
        this.outputSchemaField.getDocument().addDocumentListener(new DocumentListener(){

            public String getText() {
                int caretPosition = ExecutionPanel.this.outputSchemaField.getDocument().getLength();
                Element root = ExecutionPanel.this.outputSchemaField.getDocument().getDefaultRootElement();
                String text = "1" + System.getProperty("line.separator");
                for (int i = 2; i < root.getElementIndex(caretPosition) + 2; ++i) {
                    text = text + i + System.getProperty("line.separator");
                }
                return text;
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                lines.setText(this.getText());
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                lines.setText(this.getText());
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                lines.setText(this.getText());
                this.updateLabel();
            }

            private void updateLabel() {
                ExecutionPanel.this.operation.setOutput_schema((JsonElement)ExecutionPanel.this.outputSchemaData);
            }
        });
        outputScrollPane.getViewport().add(this.outputSchemaField);
        outputScrollPane.setRowHeaderView(lines);
        JPanel outputSchemaButtonPanel = this.createUpdateOutputSchemaButtonPanel();
        outputPanel.add((Component)outputScrollPane, new GridConstraints(0, 0, 1, 1, 3, 3, 3, 3, new Dimension(100, 300), null, null));
        outputPanel.add((Component)outputSchemaButtonPanel, new GridConstraints(1, 0, 1, 1, 3, 3, 3, 3, null, null, null));
        return outputPanel;
    }

    private JPanel createUpdateOutputSchemaButtonPanel() {
        JPanel outputSchemaButtonPanel = new JPanel();
        outputSchemaButtonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(outputSchemaButtonPanel);
        JXButton captureOutputSchemaButton = FSRTheme.createFSRButton("captureOutputSchemaButton", "/icons/run.png", "", this.getClass());
        captureOutputSchemaButton.addActionListener(e -> {
            if (this.validateRequiredFields()) {
                this.triggerCaptureOutputSchema();
            }
        });
        JXButton updateOutputSchemaButton = FSRTheme.createFSRSaveButton("updateOutputSchemaButton", "/icons/save.png", this.getClass());
        updateOutputSchemaButton.addActionListener(e -> this.triggerUpdateOutputSchema());
        outputSchemaButtonPanel.add((Component)captureOutputSchemaButton, new GridConstraints(0, 0, 1, 1, 6, 0, 3, 3, null, null, null));
        outputSchemaButtonPanel.add((Component)updateOutputSchemaButton, new GridConstraints(0, 1, 1, 1, 6, 0, 3, 3, null, null, null));
        return outputSchemaButtonPanel;
    }

    private void createSelectConfigPanel() {
        this.configPanel = new JPanel();
        TitledBorder titledBorder = FSRTheme.createFSRTitleBorder("executeSelectConfigBorder");
        this.configPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.configPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.configPanel);
        this.selectConfigField = CommonUIFields.createDropDownField("config", this.allConfigOptions, "", "Select a configuration", true);
        FSRTheme.decorateInputField((JComponent)this.selectConfigField);
        this.configPanel.add((Component)this.selectConfigField, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void addInputField(Argument arg, int pos) {
        if (arg.getRequired().booleanValue()) {
            this.requiredFields.add(arg.getName());
        }
        JLabel label = CommonUIFields.createLabel(arg.getName(), arg.getType(), arg.getTooltip(), arg.getRequired());
        String argType = arg.getType();
        String argName = arg.getName();
        String argValue = arg.getValue();
        String argTooltip = arg.getTooltip();
        boolean argRequired = arg.getRequired();
        if (this.paramsData.has(argName)) {
            argValue = this.paramsData.get(argName).getAsString();
        }
        if (argType.equals("Text") || argType.equals("Integer") || argType.equals("Datetime") || argType.equals("Password")) {
            JTextField inputField = CommonUIFields.createTextField(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField(inputField);
            this.allInputFields.put(argName, inputField);
        } else if (argType.equals("Textarea") || argType.equals("Json")) {
            JTextArea inputField = CommonUIFields.createTextArea(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField(inputField);
            this.allInputFields.put(argName, inputField);
        } else if (argType.equals("Select") || argType.equals("Multiselect")) {
            ComboBox inputField = CommonUIFields.createDropDownField(argName, arg.getOptions().split(",\\s*"), argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JComponent)inputField);
            this.allInputFields.put(argName, inputField);
        } else if (argType.equals("Checkbox")) {
            boolean value = argValue.equals("true");
            JCheckBox inputField = CommonUIFields.createCheckBoxField(argName, value, argTooltip);
            FSRTheme.decorateInputField(inputField);
            this.allInputFields.put(argName, inputField);
        } else if (argType.equals("Api Operation")) {
            ComboBox inputField = CommonUIFields.createDropDownField(arg.getName(), this.operation.getOperationsList(), argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JComponent)inputField);
            this.allInputFields.put(argName, inputField);
        } else {
            JTextField inputField = CommonUIFields.createTextField(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField(inputField);
            this.allInputFields.put(argName, inputField);
        }
        this.inputFieldPanel.add((Component)label, new GridConstraints(pos, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.inputFieldPanel.add((Component)this.allInputFields.get(arg.getName()), new GridConstraints(pos, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private boolean validateRequiredFields() {
        boolean flag = true;
        for (String key : this.requiredFields) {
            Object obj = this.allInputFields.get(key);
            if (obj instanceof JTextField) {
                flag = ConnectorUtils.validateRequiredField((JTextField)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue;
            }
            if (obj instanceof JTextArea) {
                flag = ConnectorUtils.validateRequiredField((JTextArea)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue;
            }
            if (!(obj instanceof ComboBox)) continue;
            flag = ConnectorUtils.validateRequiredField((ComboBox)obj, ArgumentsPanel.defaultBorderColor) && flag;
        }
        return flag;
    }

    private void updateParamsFields() {
        this.allInputFields.forEach((key, obj) -> {
            if (obj instanceof JTextField) {
                JTextField temp = (JTextField)obj;
                this.paramsData.addProperty(key, temp.getText());
            } else if (obj instanceof JTextArea) {
                JTextArea temp = (JTextArea)obj;
                this.paramsData.addProperty(key, temp.getText());
            } else if (obj instanceof ComboBox) {
                ComboBox temp = (ComboBox)obj;
                this.paramsData.addProperty(key, temp.getSelectedItem().toString());
            } else if (obj instanceof JCheckBox) {
                JCheckBox temp;
                JCheckBox abstractButton = temp = (JCheckBox)obj;
                boolean selected = abstractButton.getModel().isSelected();
                this.paramsData.addProperty(key, Boolean.valueOf(selected));
            }
        });
    }

    private boolean saveParamsFields(boolean showPopup) {
        if (this.validateRequiredFields()) {
            try {
                this.updateParamsFields();
                this.writeLocalData();
                if (showPopup) {
                    CommonUtils.showInfoMessage(PropReader.popMessage.getProperty("saveSuccessMessage"));
                }
                return true;
            }
            catch (Exception ex) {
                logger.debug("Save operation params value failed.", (Throwable)ex);
                if (showPopup) {
                    CommonUtils.showErrorMessage(PropReader.popMessage.getProperty("saveFailedMessage"));
                }
                return false;
            }
        }
        return false;
    }

    private void executeActions() {
        if (this.saveParamsFields(false) && ConnectorUtils.validateRequiredField(this.selectConfigField, ArgumentsPanel.defaultBorderColor)) {
            String config_name = (String)this.selectConfigField.getSelectedItem();
            ConnectorUtils.runOperationAction(this.project, this.operation.getInfoFilePath(), config_name, this.operation.getName());
        }
    }

    private void triggerCaptureOutputSchema() {
        if (this.saveParamsFields(false) && ConnectorUtils.validateRequiredField(this.selectConfigField, ArgumentsPanel.defaultBorderColor)) {
            String config_name = (String)this.selectConfigField.getSelectedItem();
            ColoredProcessHandler process = ConnectorUtils.captureOutputSchema(this.project, this.operation.getInfoFilePath(), config_name, this.operation.getName());
            if (process != null) {
                CompletableFuture.runAsync(() -> {
                    process.waitFor();
                    this.reloadCaptureOutputPanel();
                    CommonUtils.showInfoMessage(PropReader.popMessage.getProperty("capturedOutputSchemaMsg"));
                });
            }
        }
    }

    private void reloadCaptureOutputPanel() {
        this.readLocalData();
        this.outputSchemaField.setText(JsonUtils.convertToJsonPrettyString((JsonElement)this.outputSchemaData));
        this.outputSchemaScrollPane.revalidate();
        this.outputSchemaScrollPane.repaint();
    }

    private void triggerUpdateOutputSchema() {
        try {
            this.operation.setOutput_schema((JsonElement)this.outputSchemaData);
            this.operation.save();
        }
        catch (Exception ex) {
            CommonUtils.showErrorMessage(PropReader.popMessage.getProperty("failedUpdatedOutputSchemaMsg"));
        }
    }

    public void reloadFields() {
        this.readLocalData();
        this.remove(this.executePanel);
        this.createExecutePanel();
        this.add((Component)this.executePanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.revalidate();
        this.repaint();
    }

    private void readLocalData() {
        JsonObject allParamsData;
        JsonObject connLocalData;
        this.localDataFilePath = Paths.get(Objects.requireNonNull(this.project.getBasePath()), "/.fortisoar/local_data.json").toString();
        JsonUtils.createLocalDataFileIfNotFound(this.localDataFilePath);
        this.localData = JsonUtils.readJsonFile(this.localDataFilePath);
        if (!this.localData.has(this.operation.getConnectorName())) {
            this.localData.add(this.operation.getConnectorName(), (JsonElement)new JsonObject());
        }
        if (!(connLocalData = this.localData.get(this.operation.getConnectorName()).getAsJsonObject()).has("config")) {
            connLocalData.add("config", (JsonElement)new JsonObject());
        }
        if (!connLocalData.has("params")) {
            connLocalData.add("params", (JsonElement)new JsonObject());
        }
        if (!connLocalData.has("output_schema")) {
            connLocalData.add("output_schema", (JsonElement)new JsonObject());
        }
        if (!(allParamsData = connLocalData.get("params").getAsJsonObject()).has(this.operation.getName())) {
            allParamsData.add(this.operation.getName(), (JsonElement)new JsonObject());
        }
        this.paramsData = allParamsData.get(this.operation.getName()).getAsJsonObject();
        JsonObject configData = connLocalData.get("config").getAsJsonObject();
        this.allConfigOptions = configData.keySet().toArray(new String[0]);
        JsonObject allOutputSchema = connLocalData.get("output_schema").getAsJsonObject();
        if (!allOutputSchema.has(this.operation.getName())) {
            allOutputSchema.add(this.operation.getName(), (JsonElement)new JsonObject());
        }
        try {
            this.outputSchemaData = allOutputSchema.get(this.operation.getName()).getAsJsonObject();
        }
        catch (Exception ex) {
            this.outputSchemaData = new JsonObject();
        }
    }

    private void writeLocalData() {
        JsonObject prevLocalData = JsonUtils.readJsonFile(this.localDataFilePath);
        this.localData = JsonUtils.updateLocalDataJsonObject(prevLocalData, this.localData);
        JsonUtils.writeInfoJsonFile(this.localDataFilePath, this.localData);
    }
}

