/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.operation;

import com.fortinet.fortisoar.ui.operation.OperationDialog;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.intellij.openapi.util.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class CloseButtonPanel
extends JPanel {
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setIcon(IconLoader.getIcon((String)"/icons/cancel.png", this.getClass()));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setIcon(IconLoader.getIcon((String)"/icons/cancel.png", this.getClass()));
            }
        }
    };
    private JTabbedPane parent;

    public CloseButtonPanel(JTabbedPane parent, String name) {
        this.parent = parent;
        JLabel label = new JLabel(name);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.setOpaque(false);
        this.add(label);
        TabButton button = new TabButton();
        this.add(button);
        this.setVisible(true);
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText("close");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setIcon(IconLoader.getIcon((String)"/icons/cancel.png", this.getClass()));
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = CloseButtonPanel.this.parent.indexOfTabComponent(CloseButtonPanel.this);
            OperationDialog operationDialog = (OperationDialog)((Object)CloseButtonPanel.this.parent.getComponentAt(i));
            if ((!operationDialog.isChanged || CommonUtils.askYesNoQuestion(Constants.POP_MESSAGE.getProperty("closeOperationConfirmationMsg"))) && i != -1) {
                CloseButtonPanel.this.parent.remove(i);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    }
}

