/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.connector;

import com.fortinet.fortisoar.model.Connector;
import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.operation.ArgumentsPanel;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.IOUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXButton;

public class ConnectorDetailsPanel
extends JPanel {
    public static final Logger logger = Logger.getInstance(ConnectorDetailsPanel.class);
    public Project project;
    public Connector connector;
    public JPanel basicPanel;
    public JPanel actionButtonPanel;
    public JPanel saveButtonPanel;
    private JTabbedPane connectorDialog;
    private JTextField nameTextField;
    private JTextField labelTextField;
    private JTextField versionTextField;
    private JTextField smallIconTextField;
    private JTextField largeIconTextField;
    private JTextField publisherTextField;
    private JTextArea helpOnlineTextField;
    private ComboBox categoryField;
    private JTextArea descriptionTextField;

    public ConnectorDetailsPanel(Connector connectorDetail, Project project) {
        this.connector = connectorDetail;
        this.project = project;
        this.createBasicPanel();
        this.createActionsButtonPanel();
        this.createSaveButtonPanel();
        this.setLayout((LayoutManager)new GridLayoutManager(8, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this);
        FSRTheme.decorateBackground(this.basicPanel);
        FSRTheme.decorateBackground(this.actionButtonPanel);
        FSRTheme.decorateBackground(this.saveButtonPanel);
        this.add((Component)this.basicPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 10000)));
        this.add((Component)this.actionButtonPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 200)));
        this.add((Component)this.saveButtonPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 500)));
    }

    private void createBasicPanel() {
        this.basicPanel = new JPanel();
        this.basicPanel.setLayout((LayoutManager)new GridLayoutManager(12, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        TitledBorder titledBorder = FSRTheme.createFSRTitleBorder("detailsBasicPanelBorder");
        this.basicPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.createNameField();
        this.createLabelField();
        this.createVersionField();
        this.createPublisherField();
        this.createHelpOnlineField();
        this.createCategoryField();
        this.createLargeIconField();
        this.createDescriptionField();
        this.createAttributesField();
    }

    private void createNameField() {
        JLabel nameLabel = new JLabel();
        this.nameTextField = FSRTheme.createFSRTextField(this.connector.getName());
        this.nameTextField.setEditable(false);
        this.nameTextField.setEnabled(false);
        nameLabel.setLabelFor(this.nameTextField);
        nameLabel.setText(Constants.UI_TEXT.getProperty("detailsBasicNameField"));
        nameLabel.setToolTipText(Constants.TOOLTIP.getProperty("basicNameTooltip", ""));
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                if (ConnectorUtils.validateRequiredField(ConnectorDetailsPanel.this.nameTextField, ArgumentsPanel.defaultBorderColor)) {
                    ConnectorDetailsPanel.this.connector.setName(ConnectorDetailsPanel.this.nameTextField.getText());
                }
            }
        });
        this.basicPanel.add((Component)nameLabel, new GridConstraints(0, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)this.nameTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createLabelField() {
        JLabel labelLabel = new JLabel();
        this.labelTextField = new JTextField(this.connector.getLabel());
        this.labelTextField.setName("labelTextField");
        FSRTheme.decorateInputField(this.labelTextField);
        labelLabel.setLabelFor(this.labelTextField);
        labelLabel.setText(Constants.UI_TEXT.getProperty("detailsBasicLabelField"));
        labelLabel.setToolTipText(Constants.TOOLTIP.getProperty("basicLabelTooltip", ""));
        this.labelTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                if (ConnectorUtils.validateRequiredField(ConnectorDetailsPanel.this.labelTextField, ArgumentsPanel.defaultBorderColor)) {
                    ConnectorDetailsPanel.this.connector.setLabel(ConnectorDetailsPanel.this.labelTextField.getText());
                }
            }
        });
        this.basicPanel.add((Component)labelLabel, new GridConstraints(1, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)this.labelTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createVersionField() {
        JLabel versionLabel = new JLabel();
        this.versionTextField = new JTextField(this.connector.getVersion());
        this.versionTextField.setName("versionTextField");
        FSRTheme.decorateInputField(this.versionTextField);
        versionLabel.setLabelFor(this.versionTextField);
        versionLabel.setText(Constants.UI_TEXT.getProperty("detailsBasicVersionField"));
        versionLabel.setToolTipText(Constants.TOOLTIP.getProperty("basicVersionTooltip", ""));
        this.versionTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                if (ConnectorUtils.validateVersionTextField(ConnectorDetailsPanel.this.versionTextField, ArgumentsPanel.defaultBorderColor)) {
                    ConnectorDetailsPanel.this.connector.setVersion(ConnectorDetailsPanel.this.versionTextField.getText());
                }
            }
        });
        this.basicPanel.add((Component)versionLabel, new GridConstraints(2, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)this.versionTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createPublisherField() {
        JLabel publisherLabel = new JLabel();
        this.publisherTextField = new JTextField(this.connector.getPublisher());
        this.publisherTextField.setName("publisherTextField");
        FSRTheme.decorateInputField(this.publisherTextField);
        publisherLabel.setLabelFor(this.publisherTextField);
        publisherLabel.setText(Constants.UI_TEXT.getProperty("detailsBasicPublisherField"));
        publisherLabel.setToolTipText(Constants.TOOLTIP.getProperty("basicPublisherTooltip", ""));
        this.publisherTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                ConnectorDetailsPanel.this.connector.setPublisher(ConnectorDetailsPanel.this.publisherTextField.getText());
            }
        });
        this.basicPanel.add((Component)publisherLabel, new GridConstraints(3, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)this.publisherTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createHelpOnlineField() {
        JLabel helpOnlineLabel = new JLabel();
        this.helpOnlineTextField = new JTextArea(this.connector.getHelp_online());
        this.helpOnlineTextField.setName("helpOnlineTextField");
        FSRTheme.decorateInputField(this.helpOnlineTextField);
        helpOnlineLabel.setLabelFor(this.helpOnlineTextField);
        helpOnlineLabel.setText(Constants.UI_TEXT.getProperty("detailsBasicHelpOnlineField"));
        helpOnlineLabel.setToolTipText(Constants.TOOLTIP.getProperty("basicHelpOnlineTooltip", ""));
        this.helpOnlineTextField.setLineWrap(true);
        this.helpOnlineTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                ConnectorDetailsPanel.this.connector.setHelp_online(ConnectorDetailsPanel.this.helpOnlineTextField.getText());
            }
        });
        this.basicPanel.add((Component)helpOnlineLabel, new GridConstraints(4, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)this.helpOnlineTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createCategoryField() {
        JLabel categoryLabel = new JLabel();
        categoryLabel.setLabelFor((Component)this.categoryField);
        categoryLabel.setText(Constants.UI_TEXT.getProperty("detailsBasicCategoryField"));
        categoryLabel.setToolTipText(Constants.TOOLTIP.getProperty("basicCategoryTooltip", ""));
        this.categoryField = FSRTheme.createFSRComboBox(Constants.CONNECTOR_CATEGORY_OPTIONS);
        String currentType = this.connector.getCategory();
        if (List.of(Constants.CONNECTOR_CATEGORY_OPTIONS).contains(currentType)) {
            this.categoryField.setSelectedItem((Object)currentType);
        } else {
            this.categoryField.setSelectedItem((Object)"Other");
        }
        this.basicPanel.add((Component)categoryLabel, new GridConstraints(5, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)this.categoryField, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 3, null, null, null));
        this.categoryField.addActionListener(e -> {
            ComboBox comboBox = (ComboBox)e.getSource();
            String selectedType = (String)comboBox.getSelectedItem();
            this.connector.setCategory(selectedType);
        });
    }

    private void createLargeIconField() {
        JLabel largeIconLabel = new JLabel();
        this.largeIconTextField = new JTextField(this.connector.getIcon_large_name(false));
        this.largeIconTextField.setName("largeIconTextField");
        FSRTheme.decorateInputField(this.largeIconTextField);
        TextFieldWithBrowseButton largeIconFileButton = new TextFieldWithBrowseButton(this.largeIconTextField);
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        largeIconFileButton.addBrowseFolderListener("Select Image File", "Select image file", this.project, fileChooserDescriptor);
        largeIconLabel.setLabelFor(this.largeIconTextField);
        largeIconLabel.setText(Constants.UI_TEXT.getProperty("detailsBasicLargeIconField"));
        largeIconLabel.setToolTipText(Constants.TOOLTIP.getProperty("basicLargeIconTooltip", ""));
        this.largeIconTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                ConnectorDetailsPanel.this.connector.setIcon_large_name(ConnectorDetailsPanel.this.largeIconTextField.getText());
            }
        });
        JBScrollPane largeIconTextScroll = new JBScrollPane((Component)largeIconFileButton, 20, 30);
        this.basicPanel.add((Component)largeIconLabel, new GridConstraints(7, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)largeIconTextScroll, new GridConstraints(7, 1, 1, 1, 1, 3, 3, 3, null, null, null));
    }

    private void createDescriptionField() {
        JLabel descriptionLabel = new JLabel();
        this.descriptionTextField = FSRTheme.createFSRTextAreaField(this.connector.getDescription(), 1, 1);
        this.descriptionTextField.setLineWrap(true);
        this.descriptionTextField.setWrapStyleWord(true);
        this.descriptionTextField.setFont(descriptionLabel.getFont());
        descriptionLabel.setLabelFor(this.descriptionTextField);
        descriptionLabel.setText(Constants.UI_TEXT.getProperty("detailsBasicDescriptionField"));
        descriptionLabel.setToolTipText(Constants.TOOLTIP.getProperty("basicDescriptionTooltip", ""));
        this.descriptionTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                if (ConnectorUtils.validateRequiredField(ConnectorDetailsPanel.this.descriptionTextField, ArgumentsPanel.defaultBorderColor)) {
                    ConnectorDetailsPanel.this.connector.setDescription(ConnectorDetailsPanel.this.descriptionTextField.getText());
                }
            }
        });
        this.basicPanel.add((Component)descriptionLabel, new GridConstraints(8, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)this.descriptionTextField, new GridConstraints(8, 1, 1, 1, 8, 3, 3, 3, new Dimension(100, 80), null, new Dimension(400, 1000)));
    }

    private void createAttributesField() {
        JPanel checkBoxesWrapPanel = new JPanel();
        checkBoxesWrapPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(checkBoxesWrapPanel);
        JLabel attributesLabel = new JLabel("Attributes");
        checkBoxesWrapPanel.add((Component)attributesLabel, new GridConstraints(0, 0, 1, 1, 3, 3, 0, 0, null, null, null));
        JCheckBox csApprovedField = FSRTheme.createFSRCheckBox("detailsBasicCSApprovedField", "basicAttributeCSApprovedTooltip", this.connector.getCs_approved());
        checkBoxesWrapPanel.add((Component)csApprovedField, new GridConstraints(0, 1, 1, 1, 8, 1, 1, 1, null, null, null));
        csApprovedField.addActionListener(e -> {
            AbstractButton abstractButton = (AbstractButton)e.getSource();
            boolean selected = abstractButton.getModel().isSelected();
            this.connector.setCs_approved(selected);
        });
        this.basicPanel.add((Component)attributesLabel, new GridConstraints(9, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.basicPanel.add((Component)checkBoxesWrapPanel, new GridConstraints(9, 1, 1, 1, 8, 3, 3, 3, null, null, null));
    }

    private void createActionsButtonPanel() {
        this.actionButtonPanel = new JPanel();
        this.actionButtonPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        TitledBorder actionTitledBorder = FSRTheme.createFSRTitleBorder("detailsActionsBorder");
        this.actionButtonPanel.setBorder(BorderFactory.createCompoundBorder(actionTitledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.createPlaybookButton();
        this.createDocumentsButton();
        this.createTestButton();
        this.createCodeReviewButton();
        this.createInstallRequirementsButton();
        this.createExportButton();
        this.createDeployOnFortiSOARButton();
        this.createContributeButton();
    }

    private void createPlaybookButton() {
        JXButton playbooksButton = FSRTheme.createFSRButton("detailsActionsGeneratePlaybook", "/icons/playbook.png", "actionPlaybooksTooltip", this.getClass());
        playbooksButton.addActionListener(e -> ConnectorUtils.runPlaybookGenerationScript(this.project, this.connector.infoFilePath));
        this.actionButtonPanel.add((Component)playbooksButton, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    private void createDocumentsButton() {
        JXButton documentsButton = FSRTheme.createFSRButton("detailsActionsGenerateDocuments", "/icons/create_document.png", "actionDocumentsTooltip", this.getClass());
        documentsButton.addActionListener(e -> ConnectorUtils.runDocsGenerationScript(this.project, this.connector.getInfoFilePath()));
        this.actionButtonPanel.add((Component)documentsButton, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    private void createTestButton() {
        JXButton testButton = FSRTheme.createFSRButton("detailsActionsTest", "/icons/debug.png", "actionTestTooltip", this.getClass());
        testButton.addActionListener(e -> ConnectorUtils.testConnectorAllActions(this.project, this.connector.infoFilePath, this.connector.getName()));
        this.actionButtonPanel.add((Component)testButton, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    private void createCodeReviewButton() {
        JXButton codeReviewButton = FSRTheme.createFSRButton("detailsActionsCodeReview", "/icons/code_review.png", "actionCodeReviewTooltip", this.getClass());
        codeReviewButton.addActionListener(e -> CommonUtils.showInfoMessage(Constants.POP_MESSAGE.getProperty("comingSoonMessage")));
        this.actionButtonPanel.add((Component)codeReviewButton, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    private void createSanityButton() {
        JXButton sanityButton = FSRTheme.createFSRButton("detailsActionsSanity", "/icons/sanity_20_20.png", "actionSanityTooltip", this.getClass());
        sanityButton.addActionListener(e -> {});
        this.actionButtonPanel.add((Component)sanityButton, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    private void createHealthCheckButton() {
        JXButton healthCheckButton = FSRTheme.createFSRButton("detailsActionsHealthCheck", "/icons/health_check_20_20.png", "actionHealthCheckTooltip", this.getClass());
        healthCheckButton.addActionListener(e -> {});
        this.actionButtonPanel.add((Component)healthCheckButton, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    private void createInstallRequirementsButton() {
        JXButton installRequirementsButton = FSRTheme.createFSRButton("detailsActionsInstallRequirements", "/icons/import.png", "actionInstallRequirements", this.getClass());
        installRequirementsButton.addActionListener(e -> ConnectorUtils.installConnectorRequirements(this.project, this.connector.infoFilePath));
        this.actionButtonPanel.add((Component)installRequirementsButton, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    private void createExportButton() {
        JXButton exportButton = FSRTheme.createFSRButton("detailsActionsExport", "/icons/export.png", "actionExportTooltip", this.getClass());
        exportButton.addActionListener(e -> {
            IOUtils.exportConnector(this.connector.getInfoFilePath());
            IOUtils.reloadFromDisk(this.project);
        });
        this.actionButtonPanel.add((Component)exportButton, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    private void createDeployOnFortiSOARButton() {
        JXButton deployFortiSOARButton = FSRTheme.createFSRButton("detailsActionsDeployOnFortiSOAR", "/icons/export.png", "actionDeployOnFortiSOARTooltip", this.getClass());
        deployFortiSOARButton.addActionListener(e -> CommonUtils.showInfoMessage(Constants.POP_MESSAGE.getProperty("comingSoonMessage")));
        this.actionButtonPanel.add((Component)deployFortiSOARButton, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    private void createContributeButton() {
        JXButton contributeButton = FSRTheme.createFSRButton("detailsActionsContribute", "/icons/help.png", "actionContributeTooltip", this.getClass());
        contributeButton.addActionListener(e -> CommonUtils.openWebpage(Constants.COMMUNITY_SUBMISSION_HELP_URL));
        this.actionButtonPanel.add((Component)contributeButton, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    private void createSaveButtonPanel() {
        this.saveButtonPanel = new JPanel();
        this.saveButtonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        JXButton saveButton = FSRTheme.createFSRSaveButton("detailsSave", "/icons/save.png", this.getClass());
        saveButton.addActionListener(e -> {
            if (this.validateRequiredFields()) {
                try {
                    if (this.isNotValidLOGOFormat()) {
                        CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("invalidImageFormatMessage"));
                        return;
                    }
                    this.connector.save();
                    IOUtils.reloadFromDisk(this.project);
                }
                catch (Exception ex) {
                    logger.error("Failed to save connector details. Error: ", (Throwable)ex);
                }
            }
        });
        this.saveButtonPanel.add((Component)saveButton, new GridConstraints(0, 0, 1, 1, 6, 0, 3, 3, null, null, null));
    }

    private boolean isNotValidLOGOFormat() {
        if (this.largeIconTextField.getText().isBlank()) {
            return false;
        }
        Pattern regex = Pattern.compile(Constants.VALID_LOGO_FILE_EXT);
        return !regex.matcher(this.largeIconTextField.getText()).find();
    }

    private boolean validateRequiredFields() {
        boolean flag = ConnectorUtils.validateRequiredField(this.nameTextField, ArgumentsPanel.defaultBorderColor);
        flag = ConnectorUtils.validateRequiredField(this.labelTextField, ArgumentsPanel.defaultBorderColor) && flag;
        flag = ConnectorUtils.validateVersionTextField(this.versionTextField, ArgumentsPanel.defaultBorderColor) && flag;
        flag = ConnectorUtils.validateRequiredField(this.descriptionTextField, ArgumentsPanel.defaultBorderColor) && flag;
        return flag;
    }
}

