/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.connector;

import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.model.Connector;
import com.fortinet.fortisoar.ui.CustomTabbedPane;
import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.connector.CheckHealthPanel;
import com.fortinet.fortisoar.ui.operation.ArgumentsPanel;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.IOUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import org.jdesktop.swingx.JXButton;

public class ConfigurationTabbedPane
extends JTabbedPane {
    public static final Logger logger = Logger.getInstance(ConfigurationTabbedPane.class);
    private final Connector connectorDetail;
    private final Project project;
    public JBScrollPane argsScrollPanel;
    private JPanel argumentsPanel;
    private GridBagConstraints argumentsConstraints;
    private GridBagLayout argumentsPanelLayout;
    private JPanel finalArgsPanel;
    private CheckHealthPanel checkHealthPanel;
    private ArrayList<ArgumentsPanel> argPanelList = new ArrayList();

    public ConfigurationTabbedPane(Project project, Connector connectorDetail, CustomTabbedPane parent) {
        this.project = project;
        this.connectorDetail = connectorDetail;
        this.finalArgsPanel = this.createArgumentsScroll();
        this.checkHealthPanel = new CheckHealthPanel(project, connectorDetail);
        this.addTab(Constants.UI_TEXT.getProperty("configFieldsTab"), this.finalArgsPanel);
        this.addTab(Constants.UI_TEXT.getProperty("configureTab"), this.checkHealthPanel);
    }

    private JPanel createArgumentsScroll() {
        JPanel argsPanel = this.createArgumentsPanel();
        this.argsScrollPanel = new JBScrollPane((Component)argsPanel, 20, 30);
        JPanel finalArgumentsPanel = new JPanel();
        finalArgumentsPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(finalArgumentsPanel);
        JPanel buttonPanel = this.createButtonPanel();
        FSRTheme.decorateBackground(buttonPanel);
        finalArgumentsPanel.add((Component)buttonPanel, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, new Dimension(500, 10000)));
        finalArgumentsPanel.add((Component)this.argsScrollPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(500, 10000)));
        return finalArgumentsPanel;
    }

    private JPanel createArgumentsPanel() {
        this.argumentsPanel = new JPanel();
        TitledBorder titledBorder = FSRTheme.createFSRTitleBorder("configFieldsBorder");
        this.argumentsPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        FSRTheme.decorateBackground(this.argumentsPanel);
        this.argumentsConstraints = new GridBagConstraints();
        this.argumentsConstraints.fill = 2;
        this.argumentsConstraints.weightx = 1.0;
        this.argumentsConstraints.weighty = 1.0;
        this.argumentsPanelLayout = new GridBagLayout();
        this.argumentsPanel.setLayout(this.argumentsPanelLayout);
        int i = 0;
        while (i < this.connectorDetail.getConfiguration_fields().size()) {
            ArgumentsPanel arg = new ArgumentsPanel(this.project, this.connectorDetail.getConfiguration_fields().get(i), this.connectorDetail, this);
            this.argPanelList.add(arg);
            arg.setName(this.connectorDetail.getConfiguration_fields().get(i).getName());
            this.argumentsConstraints.gridy = i++;
            this.argumentsPanelLayout.setConstraints(arg, this.argumentsConstraints);
            this.argumentsPanel.add(arg);
        }
        return this.argumentsPanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        JXButton newArgumentButton = FSRTheme.createFSRTealButton("argsAdd", "/icons/add.png", this.getClass());
        newArgumentButton.addActionListener(e -> this.addNewArgument());
        buttonPanel.add((Component)newArgumentButton, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        JXButton saveButton = FSRTheme.createFSRSaveButton("argsSave", "/icons/save.png", this.getClass());
        saveButton.addActionListener(e -> {
            if (this.validateArgsPanel()) {
                try {
                    this.connectorDetail.saveConfig();
                    IOUtils.reloadFromDisk(this.project);
                    this.checkHealthPanel.reloadExecutePanel();
                }
                catch (Exception ex) {
                    logger.error("Save configuration fields failed.", (Throwable)ex);
                }
            }
        });
        buttonPanel.add((Component)saveButton, new GridConstraints(0, 1, 1, 1, 2, 2, 3, 3, null, null, null));
        return buttonPanel;
    }

    private void addNewArgument() {
        this.argumentsConstraints.gridy = this.connectorDetail.getConfiguration_fields().size();
        this.argumentsConstraints.weightx = 1.0;
        this.argumentsConstraints.weighty = 1.0;
        this.argumentsConstraints.fill = 1;
        this.argumentsConstraints.insets = JBUI.insets((int)0);
        Argument arg = this.connectorDetail.addEmptyArg();
        ArgumentsPanel newArg = new ArgumentsPanel(this.project, arg, this.connectorDetail, this);
        this.argPanelList.add(newArg);
        this.argumentsPanelLayout.setConstraints(newArg, this.argumentsConstraints);
        this.argumentsPanel.add((Component)newArg, -1);
        this.argumentsConstraints.gridy = this.connectorDetail.getConfiguration_fields().size() + 1;
        this.argumentsConstraints.fill = 0;
        this.argumentsConstraints.anchor = 20;
        this.argumentsConstraints.insets = JBUI.insetsTop((int)10);
        this.argumentsPanel.revalidate();
        this.scrollDownPanel();
    }

    public void scrollDownPanel() {
        final JScrollBar verticalBar = this.argsScrollPanel.getVerticalScrollBar();
        AdjustmentListener scroller = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Adjustable adjustable = e.getAdjustable();
                adjustable.setValue(verticalBar.getMaximum());
                verticalBar.removeAdjustmentListener(this);
            }
        };
        verticalBar.addAdjustmentListener(scroller);
    }

    private boolean validateArgsPanel() {
        boolean flag = true;
        for (ArgumentsPanel panel : this.argPanelList) {
            flag = panel.validateRequiredField() && flag;
        }
        return flag;
    }

    public void repaintArguments() {
        int argsPanelIndex = this.getSelectedIndex();
        this.remove(this.finalArgsPanel);
        this.finalArgsPanel = this.createArgumentsScroll();
        this.insertTab(Constants.UI_TEXT.getProperty("configFieldsTab"), null, this.finalArgsPanel, "Configurations panel", argsPanelIndex);
        this.setSelectedIndex(argsPanelIndex);
    }
}

