/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui.connector;

import com.fortinet.fortisoar.init.PropReader;
import com.fortinet.fortisoar.model.Argument;
import com.fortinet.fortisoar.model.Connector;
import com.fortinet.fortisoar.ui.CommonUIFields;
import com.fortinet.fortisoar.ui.FSRTheme;
import com.fortinet.fortisoar.ui.operation.ArgumentsPanel;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXButton;

public class CheckHealthPanel
extends JPanel {
    public static final Logger logger = Logger.getInstance(CheckHealthPanel.class);
    private final Connector connector;
    private final Project project;
    public ArrayList<String> requiredFields = new ArrayList();
    public HashMap<String, Object> allInputFields = new HashMap();
    private JPanel inputFieldPanel;
    private JBScrollPane inputFieldScrollPane;
    private JPanel buttonPanel;
    private JsonObject allConfigData;
    private JsonObject localData;
    private String localDataFilePath;
    private ComboBox selectConfigField;
    private String[] allConfigOptions;
    private JPanel configPanel;
    private JPanel executePanel;
    private JTextField addNewConfigField;
    private JPanel addNewConfigPanel;
    private JXButton newConfigButton;
    private String selectedConfigName = null;
    private JsonObject selectedConfigData = new JsonObject();

    public CheckHealthPanel(Project project, Connector connector) {
        assert (project != null);
        this.project = project;
        this.connector = connector;
        this.setLayout((LayoutManager)new GridLayoutManager(20, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        this.readLocalData();
        this.createExecutePanel();
        this.createButtonPanel();
        this.add((Component)this.executePanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.add((Component)this.buttonPanel, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        FSRTheme.decorateBackground(this);
    }

    private void createExecutePanel() {
        this.createAddNewConfigButton();
        this.createAddNewConfigPanel();
        this.createSelectConfigPanel();
        this.createInputFieldScrollPane();
        this.executePanel = new JPanel();
        this.executePanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.executePanel);
        this.executePanel.add((Component)this.newConfigButton, new GridConstraints(0, 0, 1, 1, 4, 0, 3, 3, null, null, null));
        this.executePanel.add((Component)this.configPanel, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.executePanel.add((Component)this.addNewConfigPanel, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.executePanel.add((Component)this.inputFieldScrollPane, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        if (this.allConfigOptions.length == 0) {
            this.addNewConfigPanel.setVisible(true);
            this.configPanel.setVisible(false);
            this.newConfigButton.setText(Constants.UI_TEXT.getProperty("allConfig"));
            this.selectedConfigName = "";
            this.selectedConfigData = new JsonObject();
        }
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.buttonPanel);
        JXButton runButton = FSRTheme.createFSRButton("runConfigButton", "/icons/run.png", "", this.getClass());
        runButton.addActionListener(e -> {
            if (this.validateRequiredFields()) {
                this.executeActions();
            }
        });
        JXButton reloadButton = FSRTheme.createFSRButton("resetConfigButton", "/icons/refresh.png", "configResetButtonTooltip", this.getClass());
        reloadButton.addActionListener(e -> this.reloadFields());
        JXButton saveButton = FSRTheme.createFSRSaveButton("saveConfigButton", "/icons/save.png", this.getClass());
        saveButton.addActionListener(e -> this.saveConfigFields(true));
        this.buttonPanel.add((Component)runButton, new GridConstraints(0, 0, 1, 1, 6, 0, 3, 3, null, null, null));
        this.buttonPanel.add((Component)reloadButton, new GridConstraints(0, 1, 1, 1, 6, 0, 3, 3, null, null, null));
        this.buttonPanel.add((Component)saveButton, new GridConstraints(0, 2, 1, 1, 6, 0, 3, 3, null, null, null));
    }

    private void createInputFieldScrollPane() {
        this.createInputFieldPanel();
        this.inputFieldScrollPane = new JBScrollPane((Component)this.inputFieldPanel, 20, 30);
    }

    private void createInputFieldPanel() {
        ArrayList<Argument> parameters = this.connector.getConfiguration_fields();
        this.inputFieldPanel = new JPanel();
        TitledBorder titledBorder = FSRTheme.createFSRTitleBorder("configInputFieldsBorder");
        this.inputFieldPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        FSRTheme.decorateBackground(this.inputFieldPanel);
        this.inputFieldPanel.setLayout((LayoutManager)new GridLayoutManager(parameters.size() + 1, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        for (int i = 0; i < parameters.size(); ++i) {
            this.addInputField(parameters.get(i), i + 1);
        }
    }

    private void createSelectConfigPanel() {
        this.configPanel = new JPanel();
        TitledBorder titledBorder = FSRTheme.createFSRTitleBorder("selectConfigBorder");
        this.configPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.configPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.configPanel);
        this.selectConfigField = CommonUIFields.createDropDownField("config", this.allConfigOptions, "", "Select a configuration", true);
        FSRTheme.decorateInputField((JComponent)this.selectConfigField);
        this.selectConfigField.addActionListener(e -> {
            this.selectedConfigName = (String)this.selectConfigField.getSelectedItem();
            this.selectedConfigData = this.allConfigData.get(this.selectedConfigName).getAsJsonObject();
            this.reloadFields();
        });
        this.configPanel.add((Component)this.selectConfigField, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private void createAddNewConfigButton() {
        this.newConfigButton = FSRTheme.createFSRButton("addNewConfig", "", "", this.getClass());
        this.newConfigButton.addActionListener(e -> {
            if (this.addNewConfigPanel.isVisible()) {
                this.addNewConfigPanel.setVisible(false);
                this.configPanel.setVisible(true);
                this.newConfigButton.setText(Constants.UI_TEXT.getProperty("addNewConfig"));
                this.selectedConfigName = (String)this.selectConfigField.getSelectedItem();
                if (this.allConfigData.has(this.selectedConfigName)) {
                    this.selectedConfigData = this.allConfigData.get(this.selectedConfigName).getAsJsonObject();
                }
            } else {
                this.addNewConfigPanel.setVisible(true);
                this.configPanel.setVisible(false);
                this.newConfigButton.setText(Constants.UI_TEXT.getProperty("allConfig"));
                this.selectedConfigName = "";
                this.selectedConfigData = new JsonObject();
            }
            if (this.executePanel != null) {
                this.reloadFields();
            }
        });
    }

    private void createAddNewConfigPanel() {
        this.addNewConfigPanel = new JPanel();
        TitledBorder titledBorder = FSRTheme.createFSRTitleBorder("addNewConfigBorder");
        this.addNewConfigPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.addNewConfigPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.insets((int)0, (int)5), -1, -1));
        FSRTheme.decorateBackground(this.addNewConfigPanel);
        JLabel addNewConfigLabel = new JLabel(Constants.UI_TEXT.getProperty("addNewConfigName"));
        this.addNewConfigField = CommonUIFields.createTextField(Constants.UI_TEXT.getProperty("addNewConfigBorder"), "", "Specify new config name.", true);
        FSRTheme.decorateInputField(this.addNewConfigField);
        this.addNewConfigField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel();
            }

            private void updateLabel() {
                CheckHealthPanel.this.selectedConfigName = CheckHealthPanel.this.addNewConfigField.getText();
            }
        });
        this.addNewConfigPanel.add((Component)addNewConfigLabel, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.addNewConfigPanel.add((Component)this.addNewConfigField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.addNewConfigPanel.setVisible(false);
    }

    private void addInputField(Argument arg, int pos) {
        if (arg.getRequired().booleanValue()) {
            this.requiredFields.add(arg.getName());
        }
        JLabel label = CommonUIFields.createLabel(arg.getName(), arg.getType(), arg.getTooltip(), arg.getRequired());
        String argType = arg.getType();
        String argName = arg.getName();
        String argValue = arg.getValue();
        String argTooltip = arg.getTooltip();
        boolean argRequired = arg.getRequired();
        if (this.selectedConfigData.has(argName)) {
            argValue = this.selectedConfigData.get(argName).getAsString();
        }
        if (argType.equals("Text") || argType.equals("Integer") || argType.equals("Datetime") || argType.equals("Password")) {
            JTextField inputField = CommonUIFields.createTextField(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField(inputField);
            this.allInputFields.put(argName, inputField);
        } else if (argType.equals("Textarea") || argType.equals("Json")) {
            JTextArea inputField = CommonUIFields.createTextArea(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField(inputField);
            this.allInputFields.put(argName, inputField);
        } else if (argType.equals("Select") || argType.equals("Multiselect")) {
            ComboBox inputField = CommonUIFields.createDropDownField(argName, arg.getOptions().split(",\\s*"), argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JComponent)inputField);
            this.allInputFields.put(argName, inputField);
        } else if (argType.equals("Checkbox")) {
            boolean value = argValue.equals("true");
            JCheckBox inputField = CommonUIFields.createCheckBoxField(argName, value, argTooltip);
            FSRTheme.decorateInputField(inputField);
            this.allInputFields.put(argName, inputField);
        } else if (argType.equals("Api Operation")) {
            ComboBox inputField = CommonUIFields.createDropDownField(argName, this.connector.getOperationsList(), argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField((JComponent)inputField);
            this.allInputFields.put(argName, inputField);
        } else {
            JTextField inputField = CommonUIFields.createTextField(argName, argValue, argTooltip, argRequired);
            FSRTheme.decorateInputField(inputField);
            this.allInputFields.put(argName, inputField);
        }
        this.inputFieldPanel.add((Component)label, new GridConstraints(pos, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.inputFieldPanel.add((Component)this.allInputFields.get(arg.getName()), new GridConstraints(pos, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    private boolean validateRequiredFields() {
        boolean flag = true;
        if (this.addNewConfigPanel.isVisible()) {
            flag = ConnectorUtils.validateRequiredField(this.addNewConfigField, ArgumentsPanel.defaultBorderColor);
        }
        for (String key : this.requiredFields) {
            Object obj = this.allInputFields.get(key);
            if (obj instanceof JTextField) {
                flag = ConnectorUtils.validateRequiredField((JTextField)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue;
            }
            if (obj instanceof JTextArea) {
                flag = ConnectorUtils.validateRequiredField((JTextArea)obj, ArgumentsPanel.defaultBorderColor) && flag;
                continue;
            }
            if (!(obj instanceof ComboBox)) continue;
            flag = ConnectorUtils.validateRequiredField((ComboBox)obj, ArgumentsPanel.defaultBorderColor) && flag;
        }
        return flag;
    }

    private void updateConfigFields() {
        this.allInputFields.forEach((key, obj) -> {
            if (obj instanceof JTextField) {
                JTextField temp = (JTextField)obj;
                this.selectedConfigData.addProperty(key, temp.getText());
            } else if (obj instanceof JTextArea) {
                JTextArea temp = (JTextArea)obj;
                this.selectedConfigData.addProperty(key, temp.getText());
            } else if (obj instanceof ComboBox) {
                ComboBox temp = (ComboBox)obj;
                this.selectedConfigData.addProperty(key, temp.getSelectedItem().toString());
            } else if (obj instanceof JCheckBox) {
                JCheckBox temp;
                JCheckBox abstractButton = temp = (JCheckBox)obj;
                boolean selected = abstractButton.getModel().isSelected();
                this.selectedConfigData.addProperty(key, Boolean.valueOf(selected));
            }
        });
    }

    private boolean saveConfigFields(boolean showPopup) {
        if (this.validateRequiredFields()) {
            try {
                this.updateConfigFields();
                this.allConfigData.add(this.selectedConfigName, (JsonElement)this.selectedConfigData);
                this.writeLocalData();
                if (this.addNewConfigPanel.isVisible()) {
                    String currConfigName = this.selectedConfigName;
                    this.reloadExecutePanel();
                    this.selectConfigField.setSelectedItem((Object)currConfigName);
                }
                if (showPopup) {
                    CommonUtils.showInfoMessage(PropReader.popMessage.getProperty("saveSuccessMessage"));
                }
                return true;
            }
            catch (Exception ex) {
                logger.error("Save configurations fields value failed.", (Throwable)ex);
                if (showPopup) {
                    CommonUtils.showErrorMessage(PropReader.popMessage.getProperty("saveFailedMessage"));
                }
                return false;
            }
        }
        return false;
    }

    private void executeActions() {
        if (this.saveConfigFields(false) && ConnectorUtils.validateRequiredField(this.selectConfigField, ArgumentsPanel.defaultBorderColor)) {
            String config_name = (String)this.selectConfigField.getSelectedItem();
            ConnectorUtils.runOperationAction(this.project, this.connector.getInfoFilePath(), config_name, "check_health");
        }
    }

    private void reloadFields() {
        this.executePanel.remove((Component)this.inputFieldScrollPane);
        this.createInputFieldScrollPane();
        this.executePanel.add((Component)this.inputFieldScrollPane, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.executePanel.revalidate();
        this.executePanel.repaint();
    }

    private void reloadConfigPanel() {
        this.executePanel.remove(this.configPanel);
        this.createSelectConfigPanel();
        this.executePanel.add((Component)this.configPanel, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.executePanel.revalidate();
        this.executePanel.repaint();
        this.reloadFields();
    }

    public void reloadExecutePanel() {
        this.readLocalData();
        this.remove(this.executePanel);
        this.createExecutePanel();
        this.add((Component)this.executePanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.revalidate();
        this.repaint();
    }

    private void readLocalData() {
        JsonObject connLocalData;
        this.localDataFilePath = Paths.get(this.project.getBasePath(), "/.fortisoar/local_data.json").toString();
        JsonUtils.createLocalDataFileIfNotFound(this.localDataFilePath);
        this.localData = JsonUtils.readJsonFile(this.localDataFilePath);
        if (!this.localData.has(this.connector.getName())) {
            this.localData.add(this.connector.getName(), (JsonElement)new JsonObject());
        }
        if (!(connLocalData = this.localData.get(this.connector.getName()).getAsJsonObject()).has("config")) {
            connLocalData.add("config", (JsonElement)new JsonObject());
        }
        this.allConfigData = connLocalData.get("config").getAsJsonObject();
        this.allConfigOptions = this.allConfigData.keySet().toArray(new String[0]);
        if (this.allConfigOptions.length > 0) {
            this.selectedConfigName = this.allConfigOptions[0];
            this.selectedConfigData = this.allConfigData.get(this.selectedConfigName).getAsJsonObject();
        }
    }

    private void writeLocalData() {
        JsonObject prevLocalData = JsonUtils.readJsonFile(this.localDataFilePath);
        this.localData = JsonUtils.updateLocalDataJsonObject(prevLocalData, this.localData);
        JsonUtils.writeInfoJsonFile(this.localDataFilePath, this.localData);
    }
}

