/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.ui;

import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewConnectorInputDialog
extends DialogWrapper {
    public JTextField connectorName;
    public JTextField connectorLabel;
    public JTextField connectorVersion;
    public JTextArea connectorDescription;
    @NotNull
    private JPanel centerPanel;
    @NotNull
    private Project project;

    public NewConnectorInputDialog(@Nullable Project project, boolean canBeParent) {
        super(project, canBeParent);
        this.project = project;
        this.connectorName = new JTextField();
        this.connectorName.setBorder(LineBorder.createGrayLineBorder());
        this.connectorLabel = new JTextField();
        this.connectorLabel.setBorder(LineBorder.createGrayLineBorder());
        this.connectorVersion = new JTextField("1.0.0");
        this.connectorVersion.setBorder(LineBorder.createGrayLineBorder());
        this.connectorDescription = new JTextArea("\n\n\n");
        this.connectorDescription.setBorder(LineBorder.createGrayLineBorder());
        this.centerPanel = new JPanel(new GridBagLayout());
        this.connectorLabel.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateLabel(e);
            }

            private void updateLabel(DocumentEvent e) {
                if (NewConnectorInputDialog.this.connectorName != null) {
                    NewConnectorInputDialog.this.connectorName.setText(CommonUtils.convertToConnectorName(NewConnectorInputDialog.this.connectorLabel.getText()));
                }
            }
        });
        this.init();
        this.setTitle(Constants.POP_MESSAGE.getProperty("newConnectorPopTitle"));
    }

    @NotNull
    public final JPanel getCenterPanel() {
        JPanel jPanel = this.centerPanel;
        if (jPanel == null) {
            NewConnectorInputDialog.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        GridBag gridbag = new GridBag().setDefaultWeightX(1.0).setDefaultFill(2).setDefaultInsets(new Insets(0, 0, 5, 10));
        this.centerPanel.setMinimumSize(new Dimension(400, 250));
        this.centerPanel.add((Component)this.getLabel("Display Name*"), gridbag.nextLine().next().weightx(0.2));
        this.centerPanel.add((Component)this.connectorLabel, gridbag.next().weightx(0.8));
        this.centerPanel.add((Component)this.getLabel("API Name*"), gridbag.nextLine().next().weightx(0.2));
        this.centerPanel.add((Component)this.connectorName, gridbag.next().weightx(0.8));
        this.centerPanel.add((Component)this.getLabel("Version"), gridbag.nextLine().next().weightx(0.2));
        this.centerPanel.add((Component)this.connectorVersion, gridbag.next().weightx(0.8));
        this.centerPanel.add((Component)this.getLabel("Description"), gridbag.nextLine().next().weightx(0.2));
        this.centerPanel.add((Component)this.connectorDescription, gridbag.next().weightx(0.8));
        return this.centerPanel;
    }

    private JComponent getLabel(String text) {
        JBLabel label = new JBLabel(text);
        label.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        label.setFontColor(UIUtil.FontColor.NORMAL);
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)2, (int)0));
        return label;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/fortinet/fortisoar/ui/NewConnectorInputDialog", "getCenterPanel"));
    }
}

