/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.model;

import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Objects;

public class Argument {
    private String name;
    private String title;
    private String type;
    private Boolean editable;
    private Boolean visible;
    private Boolean required;
    private JsonElement placeholder;
    private JsonElement value;
    private String tooltip;
    private String description;
    private String[] options;
    private String apiOperation;

    public Argument(String name, String title, String type, Boolean editable, Boolean visible, Boolean required, String placeholder, String value, String tooltip, String description) {
        this.setName(name);
        this.setTitle(title);
        this.setType(type);
        this.setEditable(editable);
        this.setVisible(visible);
        this.setRequired(required);
        this.setPlaceholder(placeholder);
        this.setValue(value);
        this.setTooltip(tooltip);
        this.setDescription(description);
    }

    public Argument() {
        this.setName("");
        this.setTitle("");
        this.setType("text");
        this.setEditable(true);
        this.setVisible(true);
        this.setRequired(false);
        this.setPlaceholder("");
        this.setValue("");
        this.setTooltip("");
        this.setDescription("");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = CommonUtils.stringIsNotEmptyOrNull(name) != false ? name : "";
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = CommonUtils.stringIsNotEmptyOrNull(title) != false ? title : "";
    }

    public String getType() {
        return CommonUtils.revertLowerCamelCase(this.type);
    }

    public void setType(String type) {
        if (CommonUtils.stringIsNotEmptyOrNull(type).booleanValue()) {
            this.type = CommonUtils.convertLowerCamelCase(type);
            if (!(this.type.equals("select") | this.type.equals("multiselect"))) {
                this.options = null;
            }
            if (!this.type.equals("apiOperation")) {
                this.apiOperation = null;
            }
        } else {
            this.type = "text";
        }
    }

    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = CommonUtils.booleanIsNotEmptyOrNull(editable) != false ? editable : Boolean.valueOf(true);
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = CommonUtils.booleanIsNotEmptyOrNull(visible) != false ? visible : Boolean.valueOf(true);
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = CommonUtils.booleanIsNotEmptyOrNull(required) != false ? required : Boolean.valueOf(false);
    }

    public String getPlaceholder() {
        if (this.placeholder != null) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                return (String)gson.fromJson(this.placeholder, String.class);
            }
            catch (Exception ex) {
                return String.valueOf(this.placeholder);
            }
        }
        return "";
    }

    public void setPlaceholder(String placeholder) {
        if (CommonUtils.stringIsNotEmptyOrNull(placeholder).booleanValue()) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                this.placeholder = (JsonElement)gson.fromJson(placeholder, JsonElement.class);
            }
            catch (Exception ex) {
                this.placeholder = gson.toJsonTree((Object)placeholder);
            }
        } else {
            this.placeholder = null;
        }
    }

    public String getValue() {
        if (this.value != null) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                return (String)gson.fromJson(this.value, String.class);
            }
            catch (Exception ex) {
                return String.valueOf(this.value);
            }
        }
        return "";
    }

    public void setValue(String value) {
        if (CommonUtils.stringIsNotEmptyOrNull(value).booleanValue()) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                this.value = (JsonElement)gson.fromJson(value, JsonElement.class);
            }
            catch (Exception ex) {
                this.value = gson.toJsonTree((Object)value);
            }
        } else {
            this.value = null;
        }
    }

    public String getTooltip() {
        return Objects.requireNonNullElse(this.tooltip, "");
    }

    public void setTooltip(String tooltip) {
        this.tooltip = CommonUtils.stringIsNotEmptyOrNull(tooltip) != false ? tooltip : null;
    }

    public String getDescription() {
        return Objects.requireNonNullElse(this.description, "");
    }

    public void setDescription(String description) {
        this.description = CommonUtils.stringIsNotEmptyOrNull(description) != false ? description : null;
    }

    public String getOptions() {
        if (this.options != null) {
            return String.join((CharSequence)", ", this.options);
        }
        return "";
    }

    public void setOptions(String text) {
        this.options = CommonUtils.stringIsNotEmptyOrNull(text) != false ? text.trim().split("\\s*,\\s*") : null;
    }

    public String getAPIOperations() {
        return Objects.requireNonNullElse(this.apiOperation, "");
    }

    public void setAPIOperations(String apiOperation) {
        this.apiOperation = CommonUtils.stringIsNotEmptyOrNull(apiOperation) != false ? apiOperation : null;
    }

    public void removeEmptyFields() {
        if (!CommonUtils.stringIsNotEmptyOrNull(String.valueOf(this.placeholder)).booleanValue()) {
            this.placeholder = null;
        }
        if (!CommonUtils.stringIsNotEmptyOrNull(String.valueOf(this.value)).booleanValue()) {
            this.value = null;
        }
        if (!CommonUtils.stringIsNotEmptyOrNull(this.description).booleanValue()) {
            this.description = null;
        }
        if (!CommonUtils.stringIsNotEmptyOrNull(this.tooltip).booleanValue()) {
            this.tooltip = null;
        }
    }

    public String checkRequiredFields() {
        Object errorMsg = "";
        if (this.getName().strip().length() == 0) {
            errorMsg = (String)errorMsg + Constants.POP_MESSAGE.getProperty("argumentNameRequiredFieldsMsg");
        }
        if (this.getTitle().strip().length() == 0) {
            errorMsg = (String)errorMsg + Constants.POP_MESSAGE.getProperty("argumentTitleRequiredFieldsMsg");
        }
        if (this.getDescription().strip().length() == 0) {
            errorMsg = (String)errorMsg + Constants.POP_MESSAGE.getProperty("argumentDescriptionRequiredFieldsMsg");
        }
        return errorMsg;
    }
}

