/*
 * Decompiled with CFR 0.152.
 */
package com.fortinet.fortisoar.actions;

import com.fortinet.fortisoar.init.ConfigReader;
import com.fortinet.fortisoar.init.Initialize;
import com.fortinet.fortisoar.ui.NewConnectorInputDialog;
import com.fortinet.fortisoar.utils.CommonUtils;
import com.fortinet.fortisoar.utils.ConnectorUtils;
import com.fortinet.fortisoar.utils.Constants;
import com.fortinet.fortisoar.utils.IOUtils;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewConnector
extends AnAction {
    private static final Logger logger = Logger.getInstance(NewConnector.class);
    public String connectorName;
    public String connectorLabel;
    public String connectorVersion;
    public String connectorDescription;
    public Map configYmlMap;
    private Map<String, String> filesContent;

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            NewConnector.$$$reportNull$$$0(0);
        }
        Initialize.getInstance(e.getProject());
        this.configYmlMap = ConfigReader.configYML;
        String errorMessage = "";
        try {
            NewConnectorInputDialog inputDialog = this.inputDialogPopup(e.getProject());
            if (inputDialog == null) {
                return;
            }
            this.filesContent = (Map)this.configYmlMap.get("file_contents");
            this.connectorName = inputDialog.connectorName.getText();
            this.connectorLabel = inputDialog.connectorLabel.getText();
            this.connectorVersion = inputDialog.connectorVersion.getText();
            this.connectorDescription = inputDialog.connectorDescription.getText().strip();
            this.createConnectorTemplate(e.getProject());
            IOUtils.reloadFromDisk(e.getProject());
            CommonUtils.showInfoMessage(String.format(Constants.POP_MESSAGE.getProperty("connectorCreatedSuccess"), this.connectorLabel + "(" + this.connectorName + ")"));
        }
        catch (Exception ex) {
            CommonUtils.showErrorMessage(String.format(Constants.POP_MESSAGE.getProperty("createNewConnectorFailed"), ex.getMessage()));
            logger.error("Create new connector failed.", (Throwable)ex);
        }
    }

    public NewConnectorInputDialog inputDialogPopup(Project project) {
        NewConnectorInputDialog inputDialog = new NewConnectorInputDialog(project, true);
        boolean k = inputDialog.showAndGet();
        if (!k) {
            return null;
        }
        String connectorName = inputDialog.connectorName.getText();
        String connectorDisplayName = inputDialog.connectorLabel.getText();
        if (connectorName == null || connectorName.strip().length() == 0 || connectorDisplayName.strip().length() == 0) {
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("emptyConnectorNameMessage"));
            return this.inputDialogPopup(project);
        }
        if (this.isNotValidConnectorName(connectorName) || this.isNotValidConnectorName(connectorDisplayName)) {
            CommonUtils.showErrorMessage(Constants.POP_MESSAGE.getProperty("invalidConnectorNameMessage"));
            return this.inputDialogPopup(project);
        }
        return inputDialog;
    }

    public boolean isNotValidConnectorName(String connectorName) {
        Pattern regex = Pattern.compile(Constants.INVALID_SPECIAL_CHARACTERS);
        return regex.matcher(connectorName).find();
    }

    public void createConnectorTemplate(Project project) throws Exception {
        String errorMessage = "";
        @Nullable VirtualFile projectPath = LocalFileSystem.getInstance().findFileByPath(Objects.requireNonNull(project.getBasePath()));
        assert (projectPath != null);
        @Nullable PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(projectPath);
        if (directory == null) {
            errorMessage = Constants.POP_MESSAGE.getProperty("nullDirectoryMessage");
            throw new Exception(errorMessage);
        }
        @Nullable PsiDirectory isConnectorDir = directory.findSubdirectory(this.connectorName);
        if (isConnectorDir != null) {
            errorMessage = Constants.POP_MESSAGE.getProperty("directoryAlreadyExistMessage");
            throw new Exception(errorMessage);
        }
        PsiDirectory parentDir = this.createSubDir(directory, String.format("connector-%s", this.connectorName));
        PsiDirectory connectorDir = this.createFolderStructure(parentDir, this.connectorName);
        ConnectorUtils.openConnectorFile(connectorDir, project);
    }

    public PsiDirectory createFolderStructure(PsiDirectory directory, String connectorName) {
        CreateFileAction.MkDirs mkdirs = new CreateFileAction.MkDirs(connectorName, directory);
        PsiDirectory connectorDir = mkdirs.directory.createSubdirectory(FileUtilRt.getNameWithoutExtension((String)connectorName));
        Map connectorTemplates = (Map)this.configYmlMap.get("connector_templates");
        ArrayList parentFolderList = (ArrayList)connectorTemplates.get("parent_folder");
        ArrayList folderList = (ArrayList)connectorTemplates.get("folder");
        ArrayList fileList = (ArrayList)connectorTemplates.get("files");
        this.createNestedFiles(directory, parentFolderList);
        this.createNestedFiles(connectorDir, folderList);
        for (Object fileObj : fileList) {
            Map file = (Map)fileObj;
            this.createNewFile(connectorDir, file.get("name").toString());
        }
        return connectorDir;
    }

    private void createNestedFiles(PsiDirectory directory, ArrayList<Map<String, Object>> folderList) {
        for (Map<String, Object> folderObj : folderList) {
            @NotNull PsiDirectory currDir = this.createSubDir(directory, folderObj.get("name").toString());
            ArrayList files = (ArrayList)folderObj.get("files");
            if (files == null) continue;
            for (Map file : files) {
                this.createNewFile(currDir, (String)file.get("name"));
            }
        }
    }

    public void createNewFile(PsiDirectory directory, String fileName) {
        WriteAction.compute(() -> directory.createFile(fileName));
        @NotNull PsiFile file = directory.findFile(fileName);
        if (this.filesContent.containsKey(fileName)) {
            @NonNls @NotNull String filePath = file.getVirtualFile().getPath();
            String content = this.filesContent.get(fileName);
            content = String.format(content, this.connectorName, this.connectorLabel, this.connectorVersion, this.connectorDescription);
            IOUtils.writeStringToFile(filePath, content);
        }
    }

    public PsiDirectory createSubDir(@NotNull PsiDirectory directory, @NotNull String subDirName) {
        if (directory == null) {
            NewConnector.$$$reportNull$$$0(1);
        }
        if (subDirName == null) {
            NewConnector.$$$reportNull$$$0(2);
        }
        WriteAction.compute(() -> directory.createSubdirectory(subDirName));
        return directory.findSubdirectory(subDirName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirName";
                break;
            }
        }
        objectArray2[1] = "com/fortinet/fortisoar/actions/NewConnector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createSubDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

