#!/usr/bin/env python
# -*- coding: cp936 -*-
"""

proof-of-concept code for the paper "Adobe Reader's Custom Memory Management: A Heap of Trouble"

function: Dumping all Acro Blocks in the memory on Adobe Reader

by Haifei Li of Fortinet's FortiGuard Labs (hfli@fortinet.com)

"""



__VERSION__ = '1.0'

import immlib

block_all=[]


def lookup_acro_list(p_head):

    imm=immlib.Debugger()

    acro_block=p_head
    
    while (acro_block!=0):
        
        block_all.append(acro_block)

        #Flink is at offset 0x10
        acro_block=imm.readLong(acro_block+0x10)




def main(argc):
    
    imm=immlib.Debugger()

    imm.Log("******************Acro Block Dumping...******************")

    #for Adobe Reader whose AcroRd32.dll version is 9.3.0.148, the fixed address is 0x014DCE40
    #for other versions, just need to change the fixed address
    p_acro_manage_pool=imm.readLong(0x014DCE40)

    #head block on acro_list
    head_acro_block=imm.readLong(p_acro_manage_pool+0x90)

    #lookup on the list
    lookup_acro_list(head_acro_block)


    block_all.sort()

    #output
    for p_block in block_all:

        #acro_header.flag=2
        flag=imm.readLong(p_block+0x08)

        if (flag==2):
    
            dwPayLoad=imm.readLong(p_block+0x14)
            
            if (dwPayLoad<=0x80):
                imm.Error("error: acro block dwPayLoad<=0x80!")

        else:
            imm.Error("error: found error flag!")
        
        imm.Log("[%08X - %08X], dwPayLoad=%08X, flag=%08X" % (p_block,p_block+dwPayLoad+0x1C,dwPayLoad,flag))



if __name__=="__main__":
    print "This module is for use within Immunity Debugger only"
