#!/usr/bin/env python
# -*- coding: cp936 -*-
"""

proof-of-concept code for the paper "Adobe Reader's Custom Memory Management: A Heap of Trouble"

function: Dumping all free Bib Blocks in the memory on Adobe Reader

by Haifei Li of Fortinet's FortiGuard Labs (hfli@fortinet.com)

"""

__VERSION__ = '1.0'

import immlib


block_all=[]


def lookup_same_size_list(p_head):

    imm=immlib.Debugger()

    imm.Log("                %08X" % p_head)

    #Blink
    pre_same_size_block=imm.readLong(p_head+0x10)

    #Flink
    next_same_size_block=imm.readLong(p_head+0x14)

    if (pre_same_size_block!=0):
        imm.Error("error: pre_same_size_block of the head block should be NULL!")
        exit(0)

    flag=1
    
    while (next_same_size_block!=0):

        if (flag==1):
            imm.Log("                %08X*" % next_same_size_block)
        else:
            imm.Log("                %08X" % next_same_size_block)

        flag=0
        next_same_size_block=imm.readLong(next_same_size_block+0x14)


    
def lookup_additional_list(p_head):

    imm=immlib.Debugger()
    
    #record the head block
    block_all.append(p_head)
    
    #looking smaller
    p_smaller=imm.readLong(p_head) 
    while (p_smaller!=0):
        block_all.append(p_smaller)
        p_smaller=imm.readLong(p_smaller)

    #looking larger
    p_larger=imm.readLong(p_head+4)
    while (p_larger!=0):
        block_all.append(p_larger)
        p_larger=imm.readLong(p_larger+4)



def lookup_smaller_list(p_head):

    imm = immlib.Debugger()
    
    #record the head of smaller-list only, because there is no additional-list on the head of smaller-list
    block_all.append(p_head)

    p_smaller=imm.readLong(p_head)
    
    while (p_smaller!=0):
        
        block_all.append(p_smaller)

        #check if there is an additional-list linked on this node
        p_head_additional=imm.readLong(p_smaller+0x04)
        if (p_head_additional!=0):
            lookup_additional_list(p_head_additional)
        
        #Flink
        p_smaller=imm.readLong(p_smaller)



def order_by_size():
    
    imm=immlib.Debugger()
    
    num_all = len(block_all)
    
    for i in range(1,num_all):
        temp=block_all[i]
        temp_len=imm.readShort(block_all[i]-0x02)
        j=i-1
        
        while ((imm.readShort(block_all[j]-0x02))>temp_len):
            block_all[j+1]=block_all[j]
            block_all[j]=temp
            j=j-1
            if (j<0):
                break



def main():
    
    imm=immlib.Debugger()

    imm.Log("******************Free Bib Block Dumping...******************")

    #for Adobe Readder whose BIB.dll version is 1.2.1.1, the fixed address is 0x07018A98
    #for other versions, just need to change the fixed address
    p_head=imm.readLong(0x07018A98)

    if (p_head==0):
        imm.Error("error: the header pointer is NULL!")
        return
    
    while p_head!=0:

        #lookup on smaller-list
        lookup_smaller_list(p_head)

        #lookup on larger-list
        p_head=imm.readLong(p_head+4)

    
    #by size order
    order_by_size();


    #dump all blocks, including same-size blocks
    for lp_block in block_all:

        imm.Log("length %04X at:" % imm.readShort(lp_block-0x02))        
        lookup_same_size_list(lp_block)


    
if __name__=="__main__":
    print "This module is for use within Immunity Debugger only"
