import sys, base64, urllib2, ssl

def updateWatchListStateById(appServer, user, password, entryId, state):
    auth = 'Basic %s' % base64.encodestring(user + ':' + password)
    url = 'https://' + appServer + '/phoenix/rest/watchlist/entry/active/' + entryId + '?state=' + state
    request = urllib2.Request(url)
    request.add_header('Authorization', auth.rstrip())
    request.add_header('User-Agent', 'Python-urllib2/2.7')
    request.get_method = lambda: 'POST'
    try:
        ssl._https_verify_certificates(enable=False)
        ctx = ssl.SSLContext(ssl.PROTOCOL_TLSv1_2)
        opener = urllib2.build_opener(urllib2.HTTPSHandler(debuglevel=False, context=ctx))
        urllib2.install_opener(opener)
        handle = urllib2.urlopen(request)
        outJSON = handle.read()
        print outJSON
        print('Response HTTP Code: %s' % handle.getcode())
    except urllib2.HTTPError, error:
        if (error.code != 200):
            print error


if __name__ == '__main__':
    if len(sys.argv) != 6:
        print('Usage: updateWatchListStateById.py appServer user password entryId state')
        print('Example: python updateWatchListStateById.py 192.168.20.116 super/admin adm1n 885257 true')
        sys.exit()
    updateWatchListStateById(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4], sys.argv[5])