import sys, base64, urllib2, ssl

def updateLastSeenTimeByValue(appServer, user, password, groupId, value, orgId, lastSeenTime):
    auth = 'Basic %s' % base64.encodestring(user + ':' + password)
    url = 'https://' + appServer + '/phoenix/rest/watchlist/entry/lastseen?lastSeenTime=' + lastSeenTime + '&watchlistId=' + groupId + '&value=' + value + '&custId=' + orgId
    request = urllib2.Request(url)
    request.add_header('Authorization', auth.rstrip())
    request.add_header('User-Agent', 'Python-urllib2/2.7')
    request.get_method = lambda: 'POST'
    try:
        ssl._https_verify_certificates(enable=False)
        ctx = ssl.SSLContext(ssl.PROTOCOL_TLSv1_2)
        opener = urllib2.build_opener(urllib2.HTTPSHandler(debuglevel=False, context=ctx))
        urllib2.install_opener(opener)
        handle = urllib2.urlopen(request)
        outJSON = handle.read()
        print outJSON
        print('Response HTTP Code: %s' % handle.getcode())
    except urllib2.HTTPError, error:
        if (error.code != 200):
            print error


if __name__ == '__main__':
    if len(sys.argv) != 8:
        print('Usage: updateLastSeenTimeByValue.py appServer user password groupId value orgId lastSeenTime')
        print('Example: python updateLastSeenTimeByValue.py 192.168.20.116 super/admin adm1n 500547 10.10.10.1 1 1626967090000')
        sys.exit()
    updateLastSeenTimeByValue(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4], sys.argv[5], sys.argv[6], sys.argv[7])