#!/usr/bin/env python

import httplib2
import re
from xml.dom.minidom import Node, parseString, parse


def getQueryResultByOrg(appServer, user, password, inXml):
    url = "https://" + appServer + ":443/phoenix/rest/query/"
    urlfirst = url + "eventQuery"
    h = httplib2.Http(disable_ssl_certificate_validation=True)
    h.add_credentials(user, password)
    header = {'Content-Type': 'text/xml'}
    if '.xml' not in inXml:
        inXml += '.xml'

    doc = parse(inXml)
    t = doc.toxml()
    if '<DataRequest' in t:
        t1 = t.replace("<DataRequest", "<Reports><Report")
    else:
        t1 = t
    if '</DataRequest>' in t1:
        t2 = t1.replace("</DataRequest>", "</Report></Reports>")
    else:
        t2 = t1

    resp, content = h.request(urlfirst, "POST", t2, header)
    queryId = content.decode("utf-8")
    if 'error code="255"' in queryId:
        print "Query Error, check sending XML file."
        exit()

    urlSecond = url + "progress/" + queryId
    if resp['status'] == '200':
        resp, content = h.request(urlSecond)
    else:
        print "appServer doesn't return query. Error code is %s" % resp['status']
        exit()

    while content.decode("utf-8") != '100':
        resp, content = h.request(urlSecond)

    outXML = []
    if content.decode("utf-8") == '100':
        urlFinal = url + 'events/' + queryId + '/0/1000'
        resp, content = h.request(urlFinal)
        if content != '':
            outXML.append(content.decode("utf-8"))

    p = re.compile('totalCount="\d+"')
    mlist = p.findall(content)
    if mlist[0] != '':
        mm = mlist[0].replace('"', '')
        m = mm.split("=")[-1]
        num = 0
        if int(m) > 1000:
            num = int(m) / 1000
            if int(m) % 1000 > 0:
                num += 1
        if num > 0:
            for i in range(num):
                urlFinal = url + 'events/' + queryId + '/' + str((i + 1) * 1000) + '/1000'
                resp, content = h.request(urlFinal)
                if content != '':
                    outXML.append(content.decode("utf-8"))
    else:
        print "no info in this report."
        exit()
    data = dumpXML(outXML)
    return data


def dumpXML(xmlList):
    param = []
    for xml in xmlList:
        doc = parseString(xml.encode('ascii', 'xmlcharrefreplace'))
    for node in doc.getElementsByTagName("events"):
        for node1 in node.getElementsByTagName("event"):
            mapping = {}
            for node2 in node1.getElementsByTagName("attributes"):
                for node3 in node2.getElementsByTagName("attribute"):
                    itemName = node3.getAttribute("name")
                    for node4 in node3.childNodes:
                        if node4.nodeType == Node.TEXT_NODE:
                            message = node4.data
                            if '\n' in message:
                                message = message.replace('\n', '')
                            mapping[itemName] = message
            param.append(mapping)
    return param

def generateResult(param):
    if len(param) == 0:
        print "No records found. Exit"
        exit()
    else:
        print "Total records %d" % len(param)
        keys = param[0].keys()
        print ','.join(keys)
        for item in param:
            itemKeys = item.keys()
            value = []
            for key in keys:
                if key not in itemKeys:
                    value.append('')
                else:
                    value.append(item[key])
            print ','.join(value)


if __name__ == '__main__':
    import sys

if len(sys.argv) != 5:
    print "Usage: getQueryResultByOrg.py appServer user password, inputXML"
    exit()
data = getQueryResultByOrg(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4])
generateResult(data)

