package com.accelops.phoenix.servicenow;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.accelops.service.ServiceContext;

class IncidentUpdatedFromSericeNow extends AbstractServiceNowIntegration {

	IncidentUpdatedFromSericeNow(ServiceContext context) {
		super(context);
	}

	private String result;
	
	@Override
	protected void execute() throws Exception {
		
		StringBuilder ticketResults = new StringBuilder("<tickets>");
		
		String domain = (String) svcContext.getAttribute(ServiceContext.KEY_DOMAIN);
        
        Integer range = (Integer) svcContext.getAttribute(ServiceContext.KEY_RANGE);
        
        Document document = XMLUtils.createDocument(this.getIntegratedXML(), false);
        
        Map<String, String> closedTicketIds = new HashMap<String,String>();
        
        try
        {
            Document queryTicketDoc = createTicketQuery(7,range);
        
            String queryXslPath = this.getXslPath() + "/ServiceNow-Incident-Query.xsl";
        
            String getClosedTicketsXml = XMLUtils.transform(queryTicketDoc, queryXslPath);
        
            int statusCode = getSoapClient().executeSoapMethod("/incident.do?SOAP", "http://www.service-now.com/incident/getRecords", new StringEntity(getClosedTicketsXml));
            
            if (statusCode == 200){
                
                closedTicketIds = getTicketMap(getSoapClient().soapResultMessage);
                
                NodeList ticketList = document.getElementsByTagName("ticket");

                logger.log(Level.INFO, ticketList.getLength() + " tickets processing...");
                
                Set<String> closedIds = closedTicketIds.keySet();
                
                for (int i = 0; i < ticketList.getLength(); i++) {
                    
                    Node ticket = (Node)ticketList.item(i);
                    
                    try {
                        
                        String ticketResult = updateTicket(closedIds,ticket,closedTicketIds);
                        if (StringUtils.isNotBlank(ticketResult)){
                            ticketResults.append(ticketResult);
                        }
                        
                    } catch (Exception ex) {
                        logger.log(Level.SEVERE, null, ex);
                        continue;
                    }
                }
            }
            else
            {
                faultProcess(String.valueOf(statusCode));
            }
            
        }catch(Exception ex){
            Logger.getLogger(ServiceNowIntegrationServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        
        ticketResults.append("</tickets>");
        
        setResult(ticketResults.toString());		
	}

	
	 /**
     * 
     * @param ticketStatus
     * @param startDate
     * @param startTime
     * @param endDate
     * @param endTime
     * @return
     * @throws ParserConfigurationException 
     * @throws IOException 
     * @throws SAXException 
     */
    private Document createTicketQuery(int ticketStatus, Integer range) throws ParserConfigurationException, SAXException, IOException {
        
        if(range == null || range <= 0){
            range = 24;//Default one day
        }
        
        //Get external closed list
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormate = new SimpleDateFormat("HH:mm:ss");
        
        long currentTime = System.currentTimeMillis();
        
        Date startDateTime = new Date(currentTime - TimeUnit.HOURS.toMillis(range));
        
        Date endDateTime = new Date(currentTime);
        
        
        String startDate = dateFormate.format(startDateTime);
        String startTime = timeFormate.format(startDateTime);
        
        String endDate = dateFormate.format(endDateTime);
        String endTime = timeFormate.format(endDateTime);
        
        Document doc = XMLUtils.createDocument();
        Element root = XMLUtils.createChildElement(doc,"query",null);
        Element state = XMLUtils.createChildElement(doc, "state", String.valueOf(ticketStatus));
        
        Element startDateEl = XMLUtils.createChildElement(doc, "startDate", String.valueOf(startDate));
        Element startTimeEl = XMLUtils.createChildElement(doc, "startTime", String.valueOf(startTime));
        Element endDateEl = XMLUtils.createChildElement(doc, "endDate", String.valueOf(endDate));
        Element endTimeEl = XMLUtils.createChildElement(doc, "endTime", String.valueOf(endTime));
        Element rangeEl = XMLUtils.createChildElement(doc, "range", String.valueOf(range));
        root.appendChild(state);
        root.appendChild(startDateEl);
        root.appendChild(startTimeEl);
        root.appendChild(endDateEl);
        root.appendChild(endTimeEl);
        root.appendChild(rangeEl);
        doc.appendChild(root);
        
        return doc;
    }
    
    
    /**
     * 
     * @param externalClosedTickets
     * @param ticket
     * @param closedTicketIds
     * @return
     * @throws ParserConfigurationException
     * @throws SAXException
     * @throws IOException
     * @throws XPathExpressionException
     */
    private String updateTicket(Set<String> externalClosedTickets, Node ticket,Map<String,String> closedTicketIds) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException{
        
        StringBuilder ticketResult = new StringBuilder();
        
        NodeList children = ticket.getChildNodes();
        
        String internalId = null;
        String externalId = null;
        String internalState = null;
        
        for(int index=0;index<children.getLength();index++){
            Node child = children.item(index);
            
            if (child.getNodeType() == Node.ELEMENT_NODE && child.getNodeName().equalsIgnoreCase("id")){
                internalId = child.getTextContent();
            }
            else if (child.getNodeType() == Node.ELEMENT_NODE && child.getNodeName().equalsIgnoreCase("exId")){
                externalId = child.getTextContent();
            }
            else if (child.getNodeType() == Node.ELEMENT_NODE && child.getNodeName().equalsIgnoreCase("state")){
                internalState = child.getTextContent();
            }
        }
        
        if (StringUtils.isEmpty(internalId))
            return "";           
        
        // get external id
        //
        if (StringUtils.isEmpty(externalId))
            return "";
        
        // get internal state
        // 
        if (StringUtils.isEmpty(internalState))
            return "";
        
        if(externalClosedTickets.contains(externalId)){
            ticketResult.append("<ticket>");
            ticketResult.append("<id>").append(internalId).append("</id>");
            ticketResult.append("<state>1</state>");
            ticketResult.append("<exId>").append(externalId).append("</exId>");
            ticketResult.append("<exAssignedUser>").append(closedTicketIds.get(externalId)).append("</exAssignedUser>");
            ticketResult.append("<exState>closed</exState>");
            ticketResult.append("</ticket>");
        }
        
        return ticketResult.toString();
    }
    
    /**
	 * @return the result
	 */
	public String getResult() {
		return result;
	}


	/**
	 * @param result the result to set
	 */
	public void setResult(String result) {
		this.result = result;
	}
	
	
	/**
     * Mapping of sys_id to user external Id
     * 
     * @return
     */
    protected Map<String, String> getTicketMap(String soapResultMessage) {
        
        Map<String, String> ret = new HashMap<>();

        if(StringUtils.isBlank(soapResultMessage)){
            return ret;
        }

        try {
            
            logger.info("Result message of ticket " + soapResultMessage);
            
            Document resultDoc = XMLUtils.createDocument(soapResultMessage,false);
            
            NodeList nodeList = resultDoc.getElementsByTagName("getRecordsResult");
            
            if ((nodeList != null) && (nodeList.getLength() > 0)) {
                
                for(int i=0; i<nodeList.getLength(); i++){
                    
                    Node node = nodeList.item(i);
                    
                    NodeList ticketNumber = ((Element) node).getElementsByTagName(this.getIncidentFieldName());
                    NodeList elAuId = ((Element) node).getElementsByTagName("closed_by.user_name");
                    
                    if(ticketNumber != null && ticketNumber.getLength() > 0) {
                        String value = null;
                        if(elAuId != null && elAuId.getLength() > 0) {
                            value = elAuId.item(0).getTextContent();
                        }
                        ret.put(ticketNumber.item(0).getTextContent(), value);
                    }
                }
            }
        } catch (Exception e){
            logger.log(Level.WARNING, "Failed to get closed ticket list:" + e.getMessage());
        }

        return ret;
    }

}
