package com.accelops.phoenix.servicenow;

import java.util.logging.Logger;

import com.accelops.service.ServiceContext;
import com.accelops.service.integration.IntegrationService;


/**
 *
 *
 */
public class ServiceNowIntegrationServiceImpl implements IntegrationService {
    
    static final Logger logger = Logger.getLogger(ServiceNowIntegrationServiceImpl.class.getName());
    
    protected static final String Intergrated_Device   = "Device";
    protected static final String Intergrated_Incident = "Incident";

    
    @Override
    public void doIntegration(ServiceContext cxt) throws Exception {

    	String integratedType = (String)cxt.getAttribute(ServiceContext.KEY_TYPE);
    	
    	if (Intergrated_Device.equals(integratedType))
    	{
    		integerateDevice(cxt);
    	}
    	else if (Intergrated_Incident.equals(integratedType))
    	{
    		integerateIncident(cxt);
    	}
    }
    
    protected void integerateIncident(ServiceContext cxt) throws Exception {
    	IncidentServiceNowIntegration integrateIncident = new IncidentServiceNowIntegration(cxt);
		integrateIncident.integrating();
	}

	protected void integerateDevice(ServiceContext cxt) throws Exception {
		
	}

	@Override
    public String checkUpdate(ServiceContext cxt) {

		IncidentUpdatedFromSericeNow updateIncident = new IncidentUpdatedFromSericeNow(cxt);
		
		try {
            updateIncident.integrating();
        } catch (Exception e) {
            logger.info(e.getMessage());
        }
		
        return updateIncident.getResult();
    }
    

       

    
      
}
